/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.ItemHandle;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public final class LikeFood
implements Named {
    public static final Item NO_PROTOTYPE = null;
    public static final float DEFAULT_SATURATION_MODIFIER = 0.6f;
    public static final float NO_SMELT_XP = -1.0f;
    public static final OneXp NO_CRAFT_XP = null;
    public static final LikeFood air = new LikeFood("air", 0, 0.0f, NO_PROTOTYPE, true);
    public static final LikeFood crumb = new LikeFood("crumb", 1, 0.05f, NO_PROTOTYPE, true);
    public static final LikeFood water = new LikeFood("water", 1, 0.05f, (Item)Items.field_151068_bn, false);
    public static final LikeFood flavored_water = new LikeFood("flav_water", 2, 0.05f, (Item)Items.field_151068_bn, false);
    public static final LikeFood bone = new LikeFood("bone", 0, 0.0f, 0.25f, OneXp.Per06, Items.field_151103_aS, true);
    public static final LikeFood cake_slice = new LikeFood("", 2, 0.1f, NO_PROTOTYPE, false);
    public static final LikeFood cake = new LikeFood("cake", 12, 0.1f, -1.0f, Items.field_151105_aU, true);
    public static final LikeFood cookie = new LikeFood("cookie", 2, 0.1f, Items.field_151106_aX, true);
    public static final LikeFood seed = new LikeFood("seed", 2, 0.05f, 0.030625f, OneXp.Per16, NO_PROTOTYPE, true);
    public static final LikeFood wheat = new LikeFood("wheat", 0, -1.0f, Items.field_151015_O, true);
    public static final LikeFood melon_slice = new LikeFood("mslice", 2, 0.3f, Items.field_151127_ba, true);
    public static final LikeFood pumpkin_pie = new LikeFood("punkinpie", 8, 0.3f, Items.field_151158_bO, true);
    public static final LikeFood apple = new LikeFood("apple", 4, 0.3f, 0.1f, Items.field_151034_e, true);
    public static final LikeFood muscle_boost = new LikeFood("muscle", 3, 0.2f, -1.0f, NO_CRAFT_XP, NO_PROTOTYPE, false).setEnhancer();
    public static final LikeFood bread = new LikeFood("bread", 5, 0.6f, 0.3f, Items.field_151025_P, true);
    public static final LikeFood flouronly_bread = new LikeFood("_bread", 0, bread).setCraftExperience(OneXp.Per08.value());
    public static final LikeFood enriched_bread = new LikeFood("xx_bread", 8, 0.7f, 0.3f, OneXp.Per05, Items.field_151025_P, false);
    public static final LikeFood mini_bread = new LikeFood("roll", 2, 0.6f, 0.15f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood sandwich = new LikeFood("sandwich", 2, 0.6f, -1.0f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood specialty_bread = new LikeFood("sp_bread", 11, 0.75f, 0.35f, OneXp.Per04, Items.field_151025_P, false);
    public static final LikeFood muffin = new LikeFood("muffin", 4, 0.5f, 0.15f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood bread_pocket = new LikeFood("pocket", 2, 0.5f, NO_PROTOTYPE, false);
    public static final LikeFood carrot = new LikeFood("carrot", 2, 0.6f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_carrot = new LikeFood("u_carrot", 3, 0.6f, 0.1f, Items.field_151172_bF, true);
    public static final LikeFood potato = new LikeFood("potato", 5, 0.6f, Items.field_151168_bH, true);
    public static final LikeFood uncooked_potato = new LikeFood("u_potato", 1, 0.3f, 0.3f, Items.field_151174_bG, true);
    public static final LikeFood bad_potato = new LikeFood("bad_potato", 1, 0.3f, Items.field_151170_bI, true);
    public static final LikeFood fries = new LikeFood("fries", 3, 0.5f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_mushroom = new LikeFood("ubrw_shroom", 1, 0.3f, 0.04375f, new ItemStack((Block)Blocks.field_150338_P, 1), true);
    public static final LikeFood mushroom = new LikeFood("brw_shroom", 2, 0.3f, -1.0f, new ItemStack((Block)Blocks.field_150338_P, 1), true);
    public static final LikeFood red_mushroom = new LikeFood("red_shroom", 2, 0.3f, -1.0f, new ItemStack((Block)Blocks.field_150337_Q, 1), true);
    public static final LikeFood chicken = new LikeFood("chikin", 6, 0.6f, -1.0f, Items.field_151077_bg, true);
    public static final LikeFood uncooked_chicken = new LikeFood("u_chikin", 2, 0.3f, 0.35f, Items.field_151076_bf, true);
    public static final LikeFood pork = new LikeFood("pork", 8, 0.8f, -1.0f, Items.field_151157_am, true);
    public static final LikeFood uncooked_pork = new LikeFood("u_pork", 3, 0.3f, 0.35f, Items.field_151147_al, true);
    public static final LikeFood beef = new LikeFood("beef", 8, 0.8f, -1.0f, Items.field_151083_be, true);
    public static final LikeFood uncooked_beef = new LikeFood("u_beef", 3, 0.3f, 0.35f, Items.field_151082_bd, true);
    public static final LikeFood mutton = new LikeFood("mutton", 6, 0.8f, -1.0f, Items.field_179557_bn, true);
    public static final LikeFood uncooked_mutton = new LikeFood("u_mutton", 2, 0.3f, 0.35f, Items.field_179561_bm, true);
    public static final LikeFood rabbit = new LikeFood("rabit", 5, 0.6f, -1.0f, Items.field_179559_bp, true);
    public static final LikeFood uncooked_rabbit = new LikeFood("u_rabit", 3, 0.3f, 0.35f, Items.field_179558_bo, true);
    public static final LikeFood egg = new LikeFood("egg", 5, 0.6f, 0.2f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_egg = new LikeFood("u_egg", 3, 0.6f, 0.25f, Items.field_151110_aK, true);
    public static final LikeFood fried_egg = new LikeFood("fr_egg", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood fish = new LikeFood("codfish", 5, 0.6f, -1.0f, new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.COD.func_150976_a()), true);
    public static final LikeFood uncooked_fish = new LikeFood("u_fish", 4, 0.6f, 0.35f, new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), true);
    public static final LikeFood salt_fish_portion = new LikeFood("bito_saltfish", 2, 0.3f, -1.0f, OneXp.Per02, NO_PROTOTYPE, false);
    public static final LikeFood salmon = new LikeFood("salmon", 5, 0.6f, -1.0f, new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()), true);
    public static final LikeFood uncooked_salmon = new LikeFood("u_salmon", 4, 0.6f, 0.35f, new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), true);
    public static final LikeFood salt_pork = new LikeFood("saltpork", 8, 0.8f, -1.0f, Items.field_151157_am, false);
    public static final LikeFood uncooked_salt_pork = new LikeFood("u_saltpork", 3, 0.3f, 0.4f, Items.field_151147_al, false);
    public static final LikeFood smoked_pork_hocks = new LikeFood("hocks", 5, 0.6f, -1.0f, Items.field_151157_am, false);
    public static final LikeFood uncooked_pork_hocks = new LikeFood("u_hocks", 3, 0.3f, 0.35f, Items.field_151147_al, false);
    public static final LikeFood uncooked_pigtail = new LikeFood("u_pigtail", 1, 0.3f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood salt_pigtail = new LikeFood("pigtail", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood bat = new LikeFood("bat", 4, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_bat = new LikeFood("u_bat", 2, 0.3f, 0.4f, NO_PROTOTYPE, false);
    public static final LikeFood horse = new LikeFood("horse", 8, 0.8f, -1.0f, Items.field_151083_be, false);
    public static final LikeFood uncooked_horse = new LikeFood("u_horse", 3, 0.4f, 0.35f, Items.field_151082_bd, false);
    public static final LikeFood wolf = new LikeFood("wolf", 5, 0.6f, -1.0f, Items.field_151077_bg, false);
    public static final LikeFood uncooked_wolf = new LikeFood("u_wolf", 3, 0.3f, 0.35f, Items.field_151076_bf, false);
    public static final LikeFood squid = new LikeFood("squid", 4, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood uncooked_squid = new LikeFood("u_squid", 3, 0.3f, 0.3f, NO_PROTOTYPE, false);
    public static final LikeFood squid_on_stick = new LikeFood("squid_stick", -1, squid, squid);
    public static final LikeFood sugar = new LikeFood("sugar", 1, 0.1f, 0.3f, Items.field_151102_aT, true);
    public static final LikeFood hardened_sugar = new LikeFood("hrd_sugar", -1, sugar, sugar, sugar, sugar);
    public static final LikeFood cocoa_seed = new LikeFood("coco_seed", 0, 0.0f, -1.0f, VfpObj.Cocoa_Seed_obj, true);
    public static final LikeFood cane_section = new LikeFood("cane", 0, 0.0f, 0.1f, VfpObj.Sugarcane_obj, true);
    public static final LikeFood golden_apple = new LikeFood("gold_aple", 4, 1.2f, Items.field_151153_ao, true);
    public static final LikeFood golden_carrot = new LikeFood("gold_carot", 6, 1.2f, Items.field_151150_bK, true);
    public static final LikeFood spidereye = new LikeFood("spdr_eye", 2, 0.8f, Items.field_151070_bp, true);
    public static final LikeFood rotten_flesh = new LikeFood("rotn_flesh", 4, 0.3f, 0.35f, Items.field_151078_bh, true);
    public static final LikeFood rabbit_stew = new LikeFood("rabit_stw", 10, 0.7f, Items.field_179560_bq, true);
    public static final LikeFood vegetable_stew = new LikeFood("veg_stw", 7, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood vegetable_stew_meal = new LikeFood("veg_stw_meal", 0, vegetable_stew, sandwich);
    public static final LikeFood meat_stew = new LikeFood("meat_stw", 12, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood meat_stew_meal = new LikeFood("meat_stw_meal", 0, meat_stew, sandwich);
    public static final LikeFood uncooked_meat_pie = new LikeFood("u_meatpie", 0, 0.0f, 0.8f, NO_PROTOTYPE, false).setCraftExperience(OneXp.Per03.value());
    public static final LikeFood meat_pie = new LikeFood("meatpie", 16, 0.8f, NO_PROTOTYPE, false);
    public static final LikeFood mini_pie = new LikeFood("minipie", 3, 0.7f, 0.3f, NO_PROTOTYPE, true);
    public static final LikeFood uncooked_meat_portion = new LikeFood("u_bito_meat", 1, 0.7f, 0.04375f, NO_PROTOTYPE, false);
    public static final LikeFood meat_portion = new LikeFood("bito_meat", 2, 0.7f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood veg_portion = new LikeFood("bito_veg", 2, 0.4f, NO_PROTOTYPE, true);
    public static final LikeFood milk = new LikeFood("milk_botl", 2, 0.6f, -1.0f, OneXp.Per08, Items.field_151117_aB, false);
    public static final LikeFood cream = new LikeFood("cream_botl", 4, 0.6f, -1.0f, OneXp.Per08, Items.field_151117_aB, false);
    public static final LikeFood sweet_milk = new LikeFood("sweet_milk_botl", -1, milk, sugar, sugar);
    public static final LikeFood milk_bucket = new LikeFood("milk_bukt", 8, 0.6f, 0.3f, Items.field_151117_aB, true);
    public static final LikeFood juice = new LikeFood("juice", 6, 0.45f, NO_PROTOTYPE, false);
    public static final LikeFood bush_tea = new LikeFood("bushtea", 2, 0.3f, -1.0f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood milky_bush_tea = new LikeFood("milky_bushtea", -1, cream, bush_tea);
    public static final LikeFood birch_sap = new LikeFood("bsap_botl", 3, 0.8f, -1.0f, OneXp.Per08, NO_PROTOTYPE, false);
    public static final LikeFood cheese_portion = new LikeFood("cheez", 4, 0.6f, -1.0f, OneXp.Per02, NO_PROTOTYPE, false);
    public static final LikeFood cream_soup = new LikeFood("cream_soup", 8, 0.8f, NO_PROTOTYPE, false).setCraftExperience(OneXp.Per03.value());
    public static final LikeFood fish_chowder = new LikeFood("fish_chwdr", -1, milk, potato, fish).setCraftExperience(cream_soup.craftExperience());
    public static final LikeFood tato_chowder = new LikeFood("tato_chwdr", -1, milk, potato, meat_portion).setCraftExperience(cream_soup.craftExperience());
    public static final LikeFood fryegg_sandwich = new LikeFood("fryegg_sandwch", -1, fried_egg, sandwich);
    public static final LikeFood cheese_sandwich = new LikeFood("cheeze_sandwch", -1, cheese_portion, sandwich);
    public static final LikeFood hamegg_sandwich = new LikeFood("hamegg_sandwch", -1, fried_egg, meat_portion, sandwich);
    public static final LikeFood uncooked_kebab = new LikeFood("u_kebab", 4, 0.6f, 0.3f, OneXp.Per06, NO_PROTOTYPE, false);
    public static final LikeFood kebab = new LikeFood("kebab", 6, 0.6f, -1.0f, NO_PROTOTYPE, false);
    public static final LikeFood nugget_combo = new LikeFood("nugt_meal", -1, meat_portion, meat_portion, meat_portion, fries);
    public static final LikeFood pocket_eggwich = new LikeFood("pocket_eggwich", -1, egg, mushroom, bread_pocket);
    public static final LikeFood egg_n_tatoes = new LikeFood("egg_tatoes", -1, fried_egg, potato, potato);
    private final boolean _readonly;
    private final String _name;
    private final int _healAmount;
    private final float _saturationModifier;
    private float _smeltXp;
    private float _craftXp = 0.0f;
    private final ItemHandle _sampleFood;
    private boolean _boost;

    private LikeFood(String nm, int healBy, float satModifier, float smeltXp, OneXp craftXp, Item food, boolean locked) {
        this._name = nm;
        this._sampleFood = new ItemHandle(food);
        this._healAmount = healBy;
        this._saturationModifier = satModifier;
        this._smeltXp = smeltXp;
        this._craftXp = craftXp != null ? craftXp.value() : 0.0f;
        this._readonly = locked;
    }

    private LikeFood(String nm, int healBy, float satModifier, float smeltXp, Item food, boolean locked) {
        this(nm, healBy, satModifier, smeltXp, NO_CRAFT_XP, food, locked);
    }

    private LikeFood(String nm, int healBy, float satModifier, Item food, boolean locked) {
        this(nm, healBy, satModifier, -1.0f, food, locked);
    }

    public LikeFood(int healBy, float satModifier, float smeltXp, Item food) {
        this("", healBy, satModifier, smeltXp, food, false);
    }

    private LikeFood(String nm, int healBy, float satModifier, float smeltXp, ItemStack food, boolean locked) {
        Validate.isTrue((food == null || food.field_77994_a == 1 ? 1 : 0) != 0, (String)"A non-null single item cooked food itemstack is required", (Object[])new Object[0]);
        this._name = nm;
        this._sampleFood = new ItemHandle(food);
        this._healAmount = healBy;
        this._saturationModifier = satModifier;
        this._smeltXp = smeltXp;
        this._readonly = locked;
    }

    public LikeFood(int healBy, float satModifier, float smeltXp, ItemStack food) {
        this("", healBy, satModifier, smeltXp, food, false);
    }

    public LikeFood(int healBy, float satModifier, Item food) {
        this("", healBy, satModifier, -1.0f, food, false);
    }

    public LikeFood(int healBy, float satModifier) {
        this("", healBy, satModifier, -1.0f, (Item)null, false);
    }

    public LikeFood(ItemFood like) {
        Validate.notNull((Object)like, (String)"A non-null prototype food item is required", (Object[])new Object[0]);
        this._name = "";
        this._sampleFood = new ItemHandle((Item)like);
        this._healAmount = like.func_150905_g(this._sampleFood.item());
        this._saturationModifier = like.func_150906_h(this._sampleFood.item());
        this._smeltXp = -1.0f;
        this._readonly = false;
    }

    public LikeFood(LikeFood from) {
        Validate.notNull((Object)from, (String)"A non-null source like food is required", (Object[])new Object[0]);
        this._name = "";
        this._sampleFood = from._sampleFood.copy();
        this._healAmount = from._healAmount;
        this._saturationModifier = from._saturationModifier;
        this._smeltXp = from._smeltXp;
        this._craftXp = from._craftXp;
        this._readonly = false;
    }

    public LikeFood(String nm, int sampleIndex, LikeFood ... foods) {
        Validate.isTrue((foods != null && foods.length >= 1 ? 1 : 0) != 0, (String)"At least one source food must be defined", (Object[])new Object[0]);
        int healBy = 0;
        float satModifier = 0.0f;
        float satBoost = 0.0f;
        float smeltXp = 0.0f;
        float craftXp = 0.0f;
        LikeFood like = null;
        int i = 0;
        for (LikeFood food : foods) {
            healBy += food.healAmount();
            if (food.isEnhancer()) {
                satBoost += food.saturationModifier();
            } else if (food.saturationModifier() > satModifier) {
                satModifier = food.saturationModifier();
            }
            if (food.smeltExperience() > smeltXp) {
                smeltXp = food.smeltExperience();
            }
            if (food.craftExperience() > craftXp) {
                craftXp = food.craftExperience();
            }
            if (i == sampleIndex) {
                like = food;
            }
            ++i;
        }
        this._name = nm;
        this._sampleFood = new ItemHandle(like != null ? like.sample() : null);
        this._healAmount = Math.min(20, healBy);
        this._saturationModifier = satModifier + satBoost;
        this._smeltXp = smeltXp;
        this._craftXp = craftXp;
        this._readonly = this._sample() != null;
    }

    public LikeFood(int sampleIndex, LikeFood ... foods) {
        this("", sampleIndex, foods);
    }

    public int healAmount() {
        return this._healAmount;
    }

    public float saturationModifier() {
        return this._saturationModifier;
    }

    public float smeltExperience() {
        return this._smeltXp;
    }

    public LikeFood setSmeltExperience(float value) {
        if (!this._readonly) {
            this._smeltXp = value;
        }
        return this;
    }

    public float craftExperience() {
        return this._craftXp;
    }

    public LikeFood setCraftExperience(float value) {
        if (!this._readonly) {
            this._craftXp = value;
        }
        return this;
    }

    public boolean isEnhancer() {
        return this._boost;
    }

    public LikeFood setEnhancer() {
        if (!this._readonly) {
            this._boost = true;
        }
        return this;
    }

    private ItemStack _sample() {
        return this._sampleFood.item();
    }

    public ItemStack sample() {
        ItemStack food = this._sample();
        return food != null && this._readonly ? food.func_77946_l() : food;
    }

    public ItemStack sample(int amount) {
        ItemStack food = this._sample();
        if (food != null) {
            food = food.func_77946_l();
            food.field_77994_a = amount;
        }
        return food;
    }

    public final Item sampleitem() {
        ItemStack underneath = this.sample();
        return underneath != null ? underneath.func_77973_b() : null;
    }

    public ItemHandle food() {
        ItemHandle food = this._sampleFood;
        return this._readonly ? food.copy() : food;
    }

    public static final boolean something(LikeFood arg) {
        return arg != null && arg != air && arg != crumb && (arg._readonly || arg.healAmount() > 0);
    }

    public static final boolean really(LikeFood arg) {
        return LikeFood.something(arg) && arg.sample() != null;
    }

    public int hashCode() {
        return Objects.hash(this._healAmount, Float.valueOf(this._saturationModifier), this._sample());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            LikeFood other = (LikeFood)LikeFood.class.cast(o);
            return this._sample() == other._sample() && this._healAmount == other._healAmount && this._saturationModifier == other._saturationModifier;
        }
        return false;
    }

    public String toString() {
        return "(" + this._name + "," + this._healAmount + "[heal]," + this._saturationModifier + "[sat]," + this._smeltXp + "[smlt]," + this._craftXp + "[crft])";
    }

    @Override
    public final String name() {
        return this._name;
    }
}

