/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpFertilizerItem
extends VfpPlainItem {
    public VfpFertilizerItem(VfpProfile oid, CreativeTabs tab) {
        super(oid, tab);
    }

    public VfpFertilizerItem(VfpProfile oid) {
        this(oid, null);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_175151_a(pos.func_177972_a(side), side, stack) && VfpFertilizerItem.applyBonemeal(stack, world, pos, player)) {
            if (!world.field_72995_K) {
                world.func_175718_b(2005, pos, 0);
            }
            return true;
        }
        return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
    }

    private static final boolean bonemealAlwaysEffective(IGrowable growable) {
        return growable instanceof BlockSapling || growable instanceof BlockMushroom;
    }

    public static boolean applyBonemeal(ItemStack stack, World world, BlockPos to, EntityPlayer player) {
        IGrowable growable;
        IBlockState blockstate = world.func_180495_p(to);
        int hook = ForgeEventFactory.onApplyBonemeal((EntityPlayer)player, (World)world, (BlockPos)to, (IBlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (growable = (IGrowable)blockstate.func_177230_c()).func_176473_a(world, to, blockstate, world.field_72995_K)) {
            if (!world.field_72995_K) {
                boolean always;
                boolean bl = always = stack.func_77973_b() instanceof VfpFertilizerItem && VfpFertilizerItem.bonemealAlwaysEffective(growable);
                if (always || growable.func_180670_a(world, world.field_73012_v, to, blockstate)) {
                    growable.func_176474_b(world, world.field_73012_v, to, blockstate);
                }
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack stack, World world, BlockPos to) {
        if (world instanceof WorldServer) {
            return VfpFertilizerItem.applyBonemeal(stack, world, to, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        }
        return false;
    }

    public static final void initDispenseBehavior(Item instance) {
        Validate.notNull((Object)instance, (String)"A non-null fertilizer item is required", (Object[])new Object[0]);
        BlockDispenser.field_149943_a.func_82595_a((Object)instance, (Object)new BehaviorDefaultDispenseItem(){
            private boolean _dispensed = true;

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                World world = source.func_82618_k();
                if (VfpFertilizerItem.applyBonemeal(stack, world, blockpos = source.func_180699_d().func_177972_a(BlockDispenser.func_149937_b((int)source.func_82620_h())))) {
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, blockpos, 0);
                    }
                } else {
                    this._dispensed = false;
                }
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                if (this._dispensed) {
                    source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
                } else {
                    source.func_82618_k().func_175718_b(1001, source.func_180699_d(), 0);
                }
            }
        });
    }
}

