/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftedStorage;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPantryBlock
extends VfpPlainBlock
implements VfpAware,
VfpCraftedStorage {
    protected final ItemStack _constituent;
    protected final int _multiplier;

    public VfpPantryBlock(VfpProfile oid, Material likeMaterial, Block likeBlock, ItemStack constituent, CreativeTabs tab) {
        super(oid, likeMaterial, likeBlock);
        Validate.notNull((Object)constituent, (String)"A non-null constituent item is required for a pantry block", (Object[])new Object[0]);
        Validate.isTrue((constituent.field_77994_a == 1 ? 1 : 0) != 0, (String)"A pantry block's constituent must be of stacksize ONE", (Object[])new Object[0]);
        this._constituent = constituent.func_77946_l();
        this._multiplier = 1;
        VfpUtils.copy(likeBlock, this, 1.0f).func_149672_a(field_149767_g).func_149647_a(VfpUtils.bestTab(oid, tab));
    }

    public VfpPantryBlock(VfpProfile oid, Block likeBlock, ItemStack constituent) {
        this(oid, null, likeBlock, constituent, null);
    }

    public VfpPantryBlock(VfpProfile oid, Block likeBlock, Item constituent) {
        this(oid, null, likeBlock, new ItemStack(constituent), null);
    }

    public VfpPantryBlock(VfpProfile oid, LikeFood constituent) {
        this(oid, Material.field_151583_m, Blocks.field_180399_cE, constituent.sample(), null);
        this.func_149672_a(Block.field_176231_q);
    }

    VfpPantryBlock(VfpProfile oid, VfpPantryBlock from, int compressionIncrement, boolean checkFlag) {
        super(oid, from.field_149764_J, null);
        VfpPantryBlock.validatePoorManCompression(oid, from, checkFlag);
        this._constituent = from._constituent;
        this._multiplier = VfpCapacity.pinCompressionMultiplier(from._oid, from._multiplier, compressionIncrement);
        this.func_149663_c(oid.fmlid());
        VfpUtils.copy(from, this, 1.0f).func_149647_a(VfpUtils.bestTab(from.func_149708_J()));
    }

    public VfpPantryBlock(VfpOid oid, VfpPantryBlock from, int compressionIncrement) {
        this((VfpProfile)oid, from, compressionIncrement, true);
    }

    public int func_149656_h() {
        return this.isEffectivelyDense(null) ? MinecraftGlue.FREE_MOBILITY() : MinecraftGlue.NO_PUSH_MOBILITY();
    }

    public int func_149745_a(Random random) {
        return this._oid.capacity().count() * this._multiplier;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this._constituent.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return this._constituent.func_77960_j();
    }

    protected boolean isEffectivelyDense(IBlockState state) {
        if (this._oid.isLiquid()) {
            return false;
        }
        return this._oid.isDense() || this._multiplier > 1 && this._oid.capacity().count() * this._multiplier >= VfpCapacity.DENSE_BLOCK.count();
    }

    private static final void validatePoorManCompression(VfpProfile to, VfpPantryBlock from, boolean checkFlag) {
        Validate.isTrue((!checkFlag || from._oid.isCompressible() ? 1 : 0) != 0, (String)"A compressible Vfp source block is required", (Object[])new Object[0]);
        Validate.isTrue((from._oid.capacity() == to.capacity() ? 1 : 0) != 0, (String)"The per-compression capacity of source and target blocks MUST match", (Object[])new Object[0]);
        Validate.isTrue((from._oid.compressedCapacity() == to.compressedCapacity() ? 1 : 0) != 0, (String)"The max compression capacity of source and target blocks MUST match", (Object[])new Object[0]);
    }

    @Override
    public String storedTypeName() {
        return "ITEM";
    }

    @Override
    public int quantityStored(ItemStack stack, EntityPlayer player) {
        int m;
        int n = 1;
        if (this._constituent.func_77973_b() instanceof VfpCraftedStorage && (m = ((VfpCraftedStorage)this._constituent.func_77973_b()).quantityStored(this._constituent, player)) > 0) {
            n = m;
        }
        m = VfpCapacity.STANDARD_BLOCK.count();
        if (this._oid.capacity() != null) {
            m = this._oid.capacity().count();
        }
        return n * m * (stack == null ? 1 : stack.field_77994_a);
    }

    @Override
    public int quantityStored(IBlockState block, EntityPlayer player) {
        return -1;
    }
}

