/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPantryItem
extends ItemFood
implements VfpAware {
    public static final int DEFAULT_GOOD_POTION_EFFECT_DURATION_SECS = 30;
    public static final int DEFAULT_BAD_POTION_EFFECT_DURATION_SECS = 15;
    static final EnumChatFormatting _BLUE = EnumChatFormatting.BLUE;
    static final EnumChatFormatting _ENDD = EnumChatFormatting.RESET;
    protected final VfpProfile _oid;
    protected final boolean _debugFlag;

    protected VfpPantryItem(VfpProfile oid, int foodLevel, float saturationFactor, boolean isWolfFood, CreativeTabs tab, boolean delayed) {
        super(foodLevel, saturationFactor, isWolfFood);
        Validate.isTrue((boolean)oid.isItem(), (String)"A pantry item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._oid = oid;
        this._debugFlag = VfpConfig.getInstance().isDebugMode();
        this.func_77655_b(oid.fmlid());
        tab = VfpUtils.bestTab(tab, null);
        if (tab != null) {
            this.func_77637_a(tab);
        }
        if (!delayed) {
            this.completeInit(oid);
        }
    }

    public VfpPantryItem(VfpProfile oid, int foodLevel, float saturationFactor, boolean isWolfFood, CreativeTabs tab) {
        this(oid, foodLevel, saturationFactor, isWolfFood, tab, false);
    }

    public VfpPantryItem(VfpProfile oid, int foodLevel, float saturationFactor, CreativeTabs tab) {
        this(oid, foodLevel, saturationFactor, false, tab);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, CreativeTabs tab) {
        this(oid, like.healAmount(), like.saturationModifier(), false, tab);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, CreativeTabs tab, boolean delayed) {
        this(oid, like.healAmount(), like.saturationModifier(), false, tab, delayed);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, boolean isWolfFood, CreativeTabs tab) {
        this(oid, like.healAmount(), like.saturationModifier(), isWolfFood, tab);
    }

    public VfpPantryItem(VfpProfile oid) {
        this(oid, LikeFood.crumb, null);
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public final <T extends VfpPantryItem> T autoregister(Class<T> of) {
        GameRegistry.registerItem((Item)this, (String)this._oid.fmlid());
        return (T)((VfpPantryItem)of.cast(this));
    }

    public final VfpPantryItem autoregister() {
        GameRegistry.registerItem((Item)this, (String)this._oid.fmlid());
        return this;
    }

    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 30 : 15;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return !this.isEdible(stack) ? EnumAction.NONE : (this.isDrinkable(stack) ? EnumAction.DRINK : super.func_77661_b(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return !this.isEdible(stack) ? 0 : super.func_77626_a(stack);
    }

    protected boolean isEdible(ItemStack stack) {
        return this._oid.isEdible();
    }

    protected boolean isDrinkable(ItemStack stack) {
        return this.isEdible(stack) && this._oid.isLiquid();
    }

    protected void completeInit(VfpProfile oid) {
        if (this.isEdible(null)) {
            if (oid.isHarmfulIfEatenDirectly()) {
                float chance = 0.0625f;
                if (oid.isHarmfulIfEatenDirectlyAlways()) {
                    chance = 1.0f;
                }
                this.func_77844_a(Potion.field_76431_k.field_76415_H, this.getPotionEffectDurationSecs(false), 1, chance);
            } else if (oid.isEmptyCalorieSugarHigh()) {
                this.func_77844_a(Potion.field_76424_c.field_76415_H, this.getPotionEffectDurationSecs(true), 1, 1.0f);
                this.func_77848_i();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        if (this._debugFlag && this.isEdible(stack)) {
            String displayString = "VFP: " + _BLUE + "H: " + _ENDD + this.func_150905_g(stack) + ", " + _BLUE + "S: " + _ENDD + String.format("%.3f", Float.valueOf(this.func_150906_h(stack)));
            tooltip.add(displayString);
        }
    }
}

