/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class VfpPantryMultiItem
extends VfpPantryItem {
    public static final String UNKNOWN_NAME = MinecraftGlue.I18N_ITEM_KEY_PREFIX() + RandomStringUtils.randomAlphabetic((int)16);
    protected final VfpVariant[] _variants;
    protected final VfpVariant _variant_default;
    private final boolean _inedible;
    private CreativeTabs[] _tabs;

    protected VfpPantryMultiItem(VfpProfile oid, boolean isWolfFood, VfpVariant[] variants, CreativeTabs tab, boolean delayed) {
        super(oid, LikeFood.air.healAmount(), LikeFood.air.saturationModifier(), isWolfFood, tab, true);
        Validate.noNullElements((Object[])variants, (String)"All %s variants must be defined (non-null)", (Object[])new Object[]{oid});
        Validate.isTrue((variants.length > 1 ? 1 : 0) != 0, (String)"Must have at least TWO variants of a %s item to need multiItem", (Object[])new Object[]{oid});
        this._variants = variants;
        this._variant_default = this.findBaseVariant(variants);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("");
        this._inedible = this.allInedible(oid, variants);
        if (!delayed) {
            this.completeInit(oid);
        }
    }

    public VfpPantryMultiItem(VfpProfile oid, boolean isWolfFood, VfpVariant[] variants, CreativeTabs tab) {
        this(oid, isWolfFood, variants, tab, false);
    }

    public String func_77658_a() {
        return super.func_77658_a() + this._oid.fmlid();
    }

    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? super.func_77658_a() + variant.fmlid() : UNKNOWN_NAME;
    }

    public float func_150906_h(ItemStack stack) {
        if (this._inedible) {
            return 0.0f;
        }
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? variant.food().saturationModifier() : super.func_150906_h(stack);
    }

    public int func_150905_g(ItemStack stack) {
        if (this._inedible) {
            return 0;
        }
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? variant.food().healAmount() : super.func_150905_g(stack);
    }

    public CreativeTabs[] getCreativeTabs() {
        if (this._tabs == null) {
            this._tabs = VfpUtils.getTabs(this._variants, this.func_77640_w(), this._inedible ? CreativeTabs.field_78026_f : CreativeTabs.field_78039_h);
        }
        return this._tabs;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        CreativeTabs defaultTab = this.func_77640_w();
        if (tab == null) {
            for (int index = 0; index < this._variants.length; ++index) {
                subItems.add(new ItemStack(itemIn, 1, this._variants[index].metadata()));
            }
        } else {
            for (int index = 0; index < this._variants.length; ++index) {
                VfpVariant variant = this._variants[index];
                CreativeTabs wantTab = VfpUtils.preferredTab();
                if (wantTab == null) {
                    CreativeTabs creativeTabs = variant.tab() != null ? variant.tab() : (this._inedible ? defaultTab : (wantTab = LikeFood.something(variant.food()) ? CreativeTabs.field_78039_h : defaultTab));
                }
                if (wantTab != tab) continue;
                subItems.add(new ItemStack(itemIn, 1, this._variants[index].metadata()));
            }
        }
    }

    boolean allInedible(VfpProfile oid, VfpVariant[] variants) {
        for (int i = 0; i < variants.length; ++i) {
            if (!LikeFood.something(variants[i].food())) continue;
            return false;
        }
        return !oid.isEdible();
    }

    @Override
    protected boolean isEdible(ItemStack stack) {
        if (this._inedible) {
            return false;
        }
        if (stack == null) {
            return true;
        }
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? LikeFood.something(variant.food()) : false;
    }

    private VfpVariant findBaseVariant(VfpVariant[] variants) {
        for (VfpVariant variant : variants) {
            if (!variant.isbase()) continue;
            return variant;
        }
        return variants[0];
    }
}

