/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPlainBlock
extends Block
implements VfpAware {
    protected final VfpProfile _oid;

    protected VfpPlainBlock(VfpProfile oid, Material likeMaterial, Block likeBlock) {
        super(likeMaterial == null ? likeBlock.func_149688_o() : likeMaterial);
        Validate.isTrue((boolean)oid.isBlock(), (String)"A VFP block's type MUST align as a Block", (Object[])new Object[0]);
        this._oid = oid;
        this.func_149663_c(oid.fmlid());
    }

    public VfpPlainBlock(VfpProfile oid, Material likeMaterial, Block likeBlock, CreativeTabs tab) {
        this(oid, likeMaterial, likeBlock);
        VfpUtils.copy(likeBlock, this, 1.0f);
        tab = VfpUtils.bestTab(tab, CreativeTabs.field_78030_b);
        this.func_149647_a(tab);
    }

    public VfpPlainBlock(VfpProfile oid, Block likeBlock) {
        this(oid, null, likeBlock, null);
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public VfpPlainBlock autoregister() {
        GameRegistry.registerBlock((Block)this, VfpItemBlock.class, (String)this._oid.fmlid());
        return this;
    }

    public final <T extends VfpPlainBlock> T autoregister(Class<T> of) {
        return (T)((VfpPlainBlock)of.cast(this.autoregister()));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return this._oid.isRehydratable() ? EnumWorldBlockLayer.TRANSLUCENT : super.func_180664_k();
    }

    public boolean func_149662_c() {
        return this._oid == null || !this._oid.isRehydratable();
    }

    public static class VfpItemBlock
    extends ItemBlock
    implements VfpAware {
        public VfpItemBlock(Block block) {
            super(block);
            Validate.isInstanceOf(VfpPlainBlock.class, (Object)block);
        }

        protected final <T extends VfpPlainBlock> VfpPlainBlock getVfpBlock(Class<T> of) {
            return (VfpPlainBlock)of.cast(this.func_179223_d());
        }

        @Override
        public final VfpProfile vfplink() {
            return this.getVfpBlock(VfpPlainBlock.class).vfplink();
        }
    }
}

