/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public final class VfpUtils {
    public static final CreativeTabs[] EMPTY_TABS_ARRAY = new CreativeTabs[0];
    private static CreativeTabs _tabToRuleThemAllInstance;

    public static void setVfpTabOverride(CreativeTabs tab) {
        _tabToRuleThemAllInstance = tab;
    }

    public static final CreativeTabs[] getTabs(VfpVariant[] variants, CreativeTabs ... requiredTabs) {
        ArrayList<CreativeTabs> tabs = new ArrayList<CreativeTabs>();
        if (_tabToRuleThemAllInstance != null) {
            tabs.add(_tabToRuleThemAllInstance);
        } else {
            if (requiredTabs != null) {
                for (CreativeTabs tab : requiredTabs) {
                    if (tab == null || tabs.contains(tab)) continue;
                    tabs.add(tab);
                }
            }
            for (int index = 0; index < variants.length; ++index) {
                VfpVariant variant = variants[index];
                CreativeTabs tab = variant.tab();
                if (tab == null || tabs.contains(tab)) continue;
                tabs.add(tab);
            }
        }
        return tabs.toArray(EMPTY_TABS_ARRAY);
    }

    public static final CreativeTabs bestTab(VfpProfile oid, CreativeTabs tab) {
        if (VfpUtils.preferredTab() != null) {
            tab = VfpUtils.preferredTab();
        }
        if (tab == null) {
            tab = oid.isItem() ? CreativeTabs.field_78026_f : (oid.isDense() ? CreativeTabs.field_78030_b : CreativeTabs.field_78035_l);
            if (oid.isEdible() && !oid.isHarmfulIfEatenDirectly()) {
                tab = CreativeTabs.field_78039_h;
            }
        }
        return tab;
    }

    public static final CreativeTabs bestTab(CreativeTabs tab, CreativeTabs defaultTab) {
        if (VfpUtils.preferredTab() != null) {
            tab = VfpUtils.preferredTab();
        } else if (tab == null) {
            tab = defaultTab;
        }
        return tab;
    }

    public static final CreativeTabs bestTab(CreativeTabs defaultTab) {
        return VfpUtils.bestTab((CreativeTabs)null, defaultTab);
    }

    public static final CreativeTabs preferredTab() {
        return _tabToRuleThemAllInstance;
    }

    public static Block copy(Block from, Block to, float fallbackHardness) {
        float hardness;
        int lightLevel;
        float resistance;
        block2: {
            resistance = -1.0f;
            lightLevel = (int)((float)from.func_149750_m() * MinecraftGlue.LIGHT_TO_LEVEL_MULTIPLIER());
            try {
                resistance = from.func_149638_a(null) * MinecraftGlue.BLAST_RESISTENCE_TO_RESISTENCE_MULTIPLIER();
                hardness = from.func_176195_g(null, null);
            }
            catch (RuntimeException nullX) {
                hardness = fallbackHardness;
                FMLLog.warning((String)"Prototype '%s' derived hardness code requires mod adjustment!", (Object[])new Object[]{from.getClass().getSimpleName()});
                if (!(resistance < 0.0f)) break block2;
                resistance = hardness * MinecraftGlue.HARDNESS_TO_RESISTENCE_MULTIPLIER();
            }
        }
        to.func_149752_b(resistance * MinecraftGlue.RESISTENCE_TO_RESISTENCE_SETTER_MULTIPLIER());
        to.func_149711_c(hardness);
        to.func_149715_a((float)lightLevel);
        to.func_149672_a(from.field_149762_H);
        return to;
    }

    public static final void validState(VfpProfile oid, VfpVariantSet set, VfpVariant[] array) {
        Validate.validState((set != null && array != null ? 1 : 0) != 0, (String)"Either variant set and/or declared array for item '%s' not present (is NULL)", (Object[])new Object[]{oid.fmlid()});
        Validate.validState((set.size() == array.length ? 1 : 0) != 0, (String)"Some '%s' items missing from variant set!", (Object[])new Object[]{set.typeName()});
        if (oid.isBlock()) {
            MinecraftGlue.validForBlockmeta(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            Validate.validState((array[i].index() == i ? 1 : 0) != 0, (String)"%s variant items are NOT ordered as expected (item.index does not match index in array)", (Object[])new Object[]{set.typeName()});
            if (array[i].getClass() != VfpVariant.class) continue;
            Validate.validState((i == array[i].metadata() ? 1 : 0) != 0, (String)"%s variant items are NOT ordered as expected (item.meta does not match index in array)", (Object[])new Object[]{oid.fmlid()});
            VfpVariant v = set.lookup(i);
            Validate.validState((v == array[i] ? 1 : 0) != 0, (String)"Lookup of %d-th %s variant in set does not return same variant as index in array", (Object[])new Object[]{i, oid.fmlid()});
        }
    }

    public static final void validIndexAsMeta(VfpProfile oid, VfpVariant[] array) {
        for (int i = 0; i < array.length; ++i) {
            Validate.validState((array[i].index() == i ? 1 : 0) != 0, (String)"%s variant items are NOT ordered as expected (item.index does not match index in array)", (Object[])new Object[]{oid.fmlid()});
            Validate.validState((i == array[i].metadata() ? 1 : 0) != 0, (String)"%s variant items are NOT ordered as expected (item.meta does not match index in array)", (Object[])new Object[]{oid.fmlid()});
        }
    }

    public static final boolean ingredientDefined(String name) {
        return name != null && !OreDictionary.getOres((String)name, (boolean)false).isEmpty();
    }

    private VfpUtils() {
    }
}

