/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.AgentsBuildHelper;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.carton.VfpPantryJar;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpBrewingItem;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpStorageItem;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.configui.VfpConfigChangedListener;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.core.VfpIconItem;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.eggs.EggExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.milk.MilkExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.misc.MiscBuildHelper;
import org.jwaresoftware.mcmods.vfp.sugar.SugarExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.wheat.WheatExtrasBuildHelper;

public class VfpBuilder
implements VfpBuildHelper {
    private static final Class[] MULTI_ITEM_CTOR_SIG_X = new Class[]{VfpProfile.class, CreativeTabs.class};
    private static final Class[] MULTI_ITEM_CTOR_SIG_I = new Class[]{VfpOid.class, CreativeTabs.class};
    private static final Class[] MULTI_BLOCK_CTOR_SIG_X = new Class[]{VfpProfile.class, VfpVariantSet.class, CreativeTabs.class};
    private static final Class[] MULTI_BLOCK_CTOR_SIG_I = new Class[]{VfpOid.class, VfpVariantSet.class, CreativeTabs.class};
    private final VfpBuildHelper _additivesBuilder;
    private final VfpBuildHelper _milkExtrasBuilder;
    private final VfpBuildHelper _wheatExtrasBuilder;
    private final VfpBuildHelper _eggExtrasBuilder;
    private final VfpBuildHelper _meatExtrasBuilder;
    private final VfpBuildHelper _sugarExtrasBuilder;
    private final VfpBuildHelper _cartonsBuilder;
    private final VfpBuildHelper _alwaysLastBuilder;
    private final VfpBuildHelper[] _subBuilders;
    private int _other_mod_count = 0;

    public static VfpPantryItem newPortion(VfpProfile oid) {
        CreativeTabs tab = oid.isEdible() ? null : CreativeTabs.field_78035_l;
        return new VfpPantryItem(oid, LikeFood.air, tab).autoregister();
    }

    public static Item newAdditive(VfpProfile oid, CreativeTabs tab) {
        return oid.isEdible() ? new VfpPantryItem(oid, LikeFood.air, tab).autoregister() : (oid.capacity() == VfpCapacity.NONE ? new VfpPlainItem(oid, tab).autoregister() : new VfpStorageItem(oid, tab).autoregister());
    }

    public static Item newAdditive(VfpProfile oid) {
        return VfpBuilder.newAdditive(oid, null);
    }

    public static VfpPantryItem newFood(VfpProfile oid, LikeFood food) {
        return new VfpPantryItem(oid, food, oid.isEdible() ? null : CreativeTabs.field_78035_l).autoregister();
    }

    public static VfpPantryItem newWolfFood(VfpProfile oid, LikeFood food) {
        return new VfpPantryItem(oid, food, true, oid.isEdible() ? null : CreativeTabs.field_78035_l).autoregister();
    }

    public static VfpPlainItem newMisc(VfpProfile oid) {
        return oid.capacity() == VfpCapacity.NONE ? new VfpPlainItem(oid, CreativeTabs.field_78026_f).autoregister() : new VfpStorageItem(oid, CreativeTabs.field_78026_f).autoregister();
    }

    public static VfpPlainItem newItem(VfpProfile oid) {
        return new VfpPlainItem(oid).autoregister();
    }

    public static VfpPlainItem newOptionalItem(VfpProfile oid, boolean hide) {
        return new VfpPlainItem(oid, hide).autoregister();
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile oid, Block likeBlock, Item constituent, CreativeTabs tab) {
        return new VfpPantryBlock(oid, null, likeBlock, new ItemStack(constituent), tab).autoregister(VfpPantryBlock.class);
    }

    public static VfpPantryBlock newStorageBlock(VfpProfile oid, Item constituent) {
        VfpPantryBlock block = new VfpPantryBlock(oid, Blocks.field_150325_L, constituent).autoregister(VfpPantryBlock.class);
        block.func_149672_a(Blocks.field_150325_L.field_149762_H);
        return block;
    }

    public static VfpPlainItem newStorageItem(VfpProfile oid) {
        return new VfpStorageItem(oid).autoregister();
    }

    public static VfpPlainItem newStorageJar(VfpProfile oid) {
        return new VfpPantryJar(oid).autoregister();
    }

    public static VfpBrewingItem newBrewingItem(VfpProfile oid, String effect, boolean uncommon) {
        return new VfpBrewingItem(oid, effect).autoregister(VfpBrewingItem.class).setUncommon(uncommon);
    }

    public static <T extends VfpPantryMultiItem> T newMultiItem(VfpProfile oid, Class<T> ofType, User u) {
        VfpPantryMultiItem item = null;
        CreativeTabs tab = oid.isEdible() ? null : CreativeTabs.field_78035_l;
        Object[] args = new Object[]{oid, tab};
        try {
            item = (VfpPantryMultiItem)ConstructorUtils.invokeExactConstructor(ofType, (Object[])args, (Class[])(User.internal(u) ? MULTI_ITEM_CTOR_SIG_I : MULTI_ITEM_CTOR_SIG_X));
        }
        catch (Throwable ctorX) {
            throw new IllegalArgumentException("Unable to create dynamic VFP multi-item " + oid, ctorX);
        }
        return (T)((VfpPantryMultiItem)item.autoregister(ofType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends VfpPantryMultiBlock> T newMultiBlock(VfpOid oid, VfpVariantSet set, Class<T> ofType, User u) {
        VfpPantryMultiBlock block = null;
        Object[] args = new Object[]{oid, set, null};
        Class<VfpPantryMultiBlock> clazz = VfpPantryMultiBlock.class;
        synchronized (VfpPantryMultiBlock.class) {
            try {
                VfpPantryMultiBlock.set_under_construction(set);
                block = (VfpPantryMultiBlock)ConstructorUtils.invokeExactConstructor(ofType, (Object[])args, (Class[])(User.internal(u) ? MULTI_BLOCK_CTOR_SIG_I : MULTI_BLOCK_CTOR_SIG_X));
            }
            catch (Throwable ctorX) {
                throw new IllegalArgumentException("Unable to create dynamic VFP multi-block " + oid, ctorX);
            }
            finally {
                VfpPantryMultiBlock.set_under_construction(null);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return (T)((VfpPantryMultiBlock)block.autoregister(ofType));
        }
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, ItemStack pantryobject, Item agent, ItemStack vfpconstituent) {
        VfpBuilder.autorecipe(category, capacity, constituent, pantryobject, new ItemStack(agent), vfpconstituent);
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, ItemStack pantryobject, ItemStack agent, ItemStack vfpconstituent) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        Validate.notNull((Object)((Object)capacity), (String)"A non-null composite capacity is required", (Object[])new Object[0]);
        Validate.notNull((Object)constituent, (String)"A non-null constituent item(stack) is required", (Object[])new Object[0]);
        boolean regular = constituent instanceof Item;
        switch (capacity) {
            case TRAY: {
                if (regular) {
                    GameRegistry.addRecipe((ItemStack)pantryobject.func_77946_l(), (Object[])new Object[]{"XXX", "XaX", "XXX", Character.valueOf('X'), constituent, Character.valueOf('a'), agent});
                    if (vfpconstituent == null) break;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)constituent, capacity.count()), (Object[])new Object[]{pantryobject.func_77946_l()});
                    break;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pantryobject.func_77946_l(), new Object[]{"XXX", "XaX", "XXX", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}));
                if (vfpconstituent == null) break;
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(vfpconstituent.func_77973_b(), capacity.count(), vfpconstituent.func_77960_j()), new Object[]{pantryobject.func_77946_l()}));
                break;
            }
            case HALF_TRAY: {
                if (regular) {
                    GameRegistry.addRecipe((ItemStack)pantryobject.func_77946_l(), (Object[])new Object[]{"XX ", "XX ", "a  ", Character.valueOf('X'), constituent, Character.valueOf('a'), agent});
                    if (vfpconstituent == null) break;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)constituent, capacity.count()), (Object[])new Object[]{pantryobject.func_77946_l()});
                    break;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pantryobject.func_77946_l(), new Object[]{"XX ", "XX ", "a  ", Character.valueOf('X'), constituent, Character.valueOf('a'), agent}));
                if (vfpconstituent == null) break;
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(vfpconstituent.func_77973_b(), capacity.count(), vfpconstituent.func_77960_j()), new Object[]{pantryobject.func_77946_l()}));
            }
        }
    }

    static final void validAutorecipeArgs(String category, VfpCapacity capacity, Object constituent, Object pantryobject) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        Validate.validState((pantryobject != null ? 1 : 0) != 0, (String)"VFP mod's %s object builders must complete SUCCESSFULLY (pantry object is null)", (Object[])new Object[]{category});
        Validate.notNull((Object)constituent, (String)"A non-null recipe constituent item is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)capacity), (String)"A non-null composite capacity is required", (Object[])new Object[0]);
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, Block pantryblock, Item vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryblock);
        VfpBuilder._autorecipe(category, capacity, constituent, new ItemStack(pantryblock), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, Block pantryblock, Block vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryblock);
        VfpBuilder._autorecipe(category, capacity, constituent, new ItemStack(pantryblock), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, Item pantryitem, Item vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryitem);
        VfpBuilder._autorecipe(category, capacity, constituent, new ItemStack(pantryitem), vfpconstituent != null ? new ItemStack(vfpconstituent, capacity.count()) : null);
    }

    public static final void autorecipe(String category, VfpCapacity capacity, Object constituent, ItemStack pantryitem, ItemStack vfpconstituent) {
        VfpBuilder.validAutorecipeArgs(category, capacity, constituent, pantryitem);
        VfpBuilder._autorecipe(category, capacity, constituent, pantryitem, vfpconstituent != null ? new ItemStack(vfpconstituent.func_77973_b(), capacity.count(), vfpconstituent.func_77960_j()) : null);
    }

    static final void _autorecipe(String category, VfpCapacity capacity, Object constituent, ItemStack pantryobject, ItemStack vfpconstituent) {
        category = StringUtils.defaultString((String)category, (String)"pantry");
        boolean regular = constituent instanceof Item;
        switch (capacity) {
            case PORTABLE: {
                if (regular) {
                    GameRegistry.addRecipe((ItemStack)pantryobject.func_77946_l(), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), constituent});
                    if (vfpconstituent == null) break;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)constituent, capacity.count()), (Object[])new Object[]{pantryobject.func_77946_l()});
                    break;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pantryobject.func_77946_l(), new Object[]{"xx", "xx", Character.valueOf('x'), constituent}));
                if (vfpconstituent == null) break;
                GameRegistry.addShapelessRecipe((ItemStack)vfpconstituent, (Object[])new Object[]{pantryobject.func_77946_l()});
                break;
            }
            case STANDARD_BLOCK: {
                if (regular) {
                    GameRegistry.addRecipe((ItemStack)pantryobject.func_77946_l(), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), constituent});
                    if (vfpconstituent == null) break;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)constituent, capacity.count()), (Object[])new Object[]{pantryobject.func_77946_l()});
                    break;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pantryobject.func_77946_l(), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), constituent}));
                if (vfpconstituent == null) break;
                GameRegistry.addShapelessRecipe((ItemStack)vfpconstituent, (Object[])new Object[]{pantryobject.func_77946_l()});
            }
        }
    }

    public VfpBuilder(VfpRuntime runtime) {
        Validate.isTrue((runtime != null && runtime.getConfig() != null ? 1 : 0) != 0, (String)"sided runtime MUST be initialized", (Object[])new Object[0]);
        this._subBuilders = new VfpBuildHelper[8];
        int i = 0;
        this._subBuilders[i++] = this._additivesBuilder = new AgentsBuildHelper();
        this._subBuilders[i++] = this._milkExtrasBuilder = new MilkExtrasBuildHelper();
        this._subBuilders[i++] = this._sugarExtrasBuilder = new SugarExtrasBuildHelper();
        this._subBuilders[i++] = this._wheatExtrasBuilder = new WheatExtrasBuildHelper();
        this._subBuilders[i++] = this._eggExtrasBuilder = new EggExtrasBuildHelper();
        this._subBuilders[i++] = this._meatExtrasBuilder = new MeatExtrasBuildHelper();
        this._subBuilders[i++] = this._cartonsBuilder = new CartonsBuildHelper();
        this._subBuilders[i++] = this._alwaysLastBuilder = new MiscBuildHelper();
        VfpConfig config = runtime.getConfig();
        for (Integrations ii : Integrations.values()) {
            boolean other_present = config.isModLoaded(ii);
            if (other_present) {
                ++this._other_mod_count;
            }
            FMLLog.finer((String)"[pre] %s mod loaded before me: %b", (Object[])new Object[]{ii.modid(), other_present});
        }
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].doBuildEventBusHandlers(event, runtime);
        }
        if (config.includeCraftXpAndAchievements()) {
            VfpRewards.init(config);
            MinecraftForge.EVENT_BUS.register((Object)VfpRewards.ForgeEventHandler.init(config));
        }
        MinecraftForge.EVENT_BUS.register((Object)new VfpConfigChangedListener(runtime));
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        VfpIconItem modicon = new VfpIconItem();
        config.builderContext().put(VfpOid.Vfp_Icon.fmlid(), (Object)modicon);
        VfpObj.Eek_obj = VfpBuilder.newOptionalItem(VfpOid.Eek_Vfp, true);
        if (runtime.hasUI()) {
            this.setupVfpTab(runtime, modicon);
        }
        IntegrationsImpl.detectFeatureSupport(config);
        this._additivesBuilder.doBuildPrimaryObjects(event, runtime);
        this._milkExtrasBuilder.doBuildPrimaryObjects(event, runtime);
        this._sugarExtrasBuilder.doBuildPrimaryObjects(event, runtime);
        this._wheatExtrasBuilder.doBuildPrimaryObjects(event, runtime);
        this._eggExtrasBuilder.doBuildPrimaryObjects(event, runtime);
        this._meatExtrasBuilder.doBuildPrimaryObjects(event, runtime);
        this.lockdownPackagedFoodReservedMetaIds();
        this._cartonsBuilder.doBuildPrimaryObjects(event, runtime);
        this._alwaysLastBuilder.doBuildPrimaryObjects(event, runtime);
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].doBuildSecondaryObjects(event, runtime);
        }
        this.doInitLikeFoods(runtime);
        IntegrationsImpl.registerForgeIds(config);
        this.doAddChestGenLoot(runtime);
    }

    @Override
    public void doAddChestGenLoot(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (!config.builderContext().containsKey("_ran.ChestGenLoot")) {
            config.builderContext().put("_ran.ChestGenLoot", true);
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].doAddChestGenLoot(runtime);
            }
        }
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (!config.builderContext().containsKey("_ran.initLikeFoods")) {
            config.builderContext().put("_ran.initLikeFoods", true);
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].doInitLikeFoods(runtime);
            }
        }
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].doBuildRecipes(runtime);
        }
    }

    @Override
    public void doSendApiMessages(FMLStateEvent event, VfpRuntime runtime) {
        IntegrationsImpl.registerAutocraftingRecipes(runtime.getConfig());
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.includeCraftXpAndAchievements()) {
            VfpAchievements.define(config);
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].doBuildAchievementList(event, runtime);
            }
            VfpAchievements.autoregister();
        }
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            Item tabIcon = (Item)runtime.getConfig().builderContext().get(VfpOid.Vfp_Icon.fmlid());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Vfp_Icon, tabIcon);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Eek_Vfp, VfpObj.Eek_obj);
            for (int i = 0; i < this._subBuilders.length; ++i) {
                this._subBuilders[i].doInitRenderModels(event, runtime);
            }
        }
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        for (int i = 0; i < this._subBuilders.length; ++i) {
            this._subBuilders[i].doFinish(event, runtime);
        }
    }

    private void setupVfpTab(VfpRuntime runtime, final Item tabIcon) {
        if (runtime.getConfig().useOwnTab()) {
            CreativeTabs tabVfp = new CreativeTabs("VFP"){

                @SideOnly(value=Side.CLIENT)
                public Item func_78016_d() {
                    return tabIcon;
                }
            };
            runtime.setVfpTab(tabVfp);
        }
    }

    private void lockdownPackagedFoodReservedMetaIds() {
        boolean locked_ok = PackagedFood.lockdown();
        Validate.validState((this._other_mod_count == 0 || locked_ok ? 1 : 0) != 0, (String)"Detected packaged food cannot assure fixed starting metas for thirdparty mod additions", (Object[])new Object[0]);
    }

    public static enum User {
        INTERNAL,
        EXTERNAL;


        public static boolean internal(User u) {
            return u == null || INTERNAL == u;
        }
    }
}

