/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import java.util.Hashtable;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.RenderingHelper;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

public abstract class VfpSharedRuntime
implements VfpRuntime {
    protected static final Logger _vfpLogInstance = LogManager.getLogger((String)"VFP");
    protected final Map<String, Boolean> _flags = new Hashtable<String, Boolean>();
    protected VfpConfig _vfpConfig;

    protected abstract String getId();

    protected VfpSharedRuntime() {
        this._flags.put("vc", false);
    }

    @Override
    public Logger getLog() {
        return _vfpLogInstance;
    }

    @Override
    public void startUp(FMLPreInitializationEvent event) {
        this.getLog().info("Starting {}...", new Object[]{this.getId()});
        this._vfpConfig = new VfpConfig(event);
        Validate.validState((VfpConfig.setInstance(this._vfpConfig) == null ? 1 : 0) != 0, (String)"There is an active config|builder (illegal state)", (Object[])new Object[0]);
    }

    @Override
    public Boolean isEnabled(String id) {
        Boolean flag = null;
        flag = "ui".equals(id) ? Boolean.valueOf(this.hasUI()) : this._flags.get(id);
        return flag;
    }

    @Override
    public boolean hasUI() {
        return false;
    }

    @Override
    public final VfpConfig getConfig() {
        return this._vfpConfig;
    }

    @Override
    public RenderingHelper getRenderingHelper() {
        return RenderingHelper.noINSTANCE;
    }

    @Override
    public final CreativeTabs getVfpTab() {
        return this._vfpConfig.getVfpTab();
    }

    @Override
    public final void setVfpTab(CreativeTabs tab) {
        this._vfpConfig.setVfpTab(tab);
    }

    @Override
    public void reloadConfig() {
        this._vfpConfig.changed();
    }

    @Override
    public void shutDown(FMLServerStoppingEvent event) {
        this.getLog().info("Stopping {}...", new Object[]{this.getId()});
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton) {
        this.getRenderingHelper().doRenderSetupOrFail(oid, singleton);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Block singleton) {
        this.getRenderingHelper().doRenderSetupOrFail(oid, singleton);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton, VfpVariantSet variants) {
        this.getRenderingHelper().doRenderSetupOrFail(oid, singleton, variants);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Block singleton, VfpVariantSet variants) {
        this.getRenderingHelper().doRenderSetupOrFail(oid, singleton, variants);
    }

    @Override
    public final void doRenderSetupOrFail(VfpProfile oid, Item singleton, String[] fmlids, int[] metas) {
        this.getRenderingHelper().doRenderSetupOrFail(oid, singleton, fmlids, metas);
    }

    @Override
    public final void doRenderWaterBottlesOrFail(int fizzy_index, int end_index) {
        this.getRenderingHelper().doRenderWaterBottlesOrFail(fizzy_index, end_index);
    }

    @Override
    public final void doRenderTonicAndPotionBottlesOrFail() {
        this.getRenderingHelper().doRenderTonicAndPotionBottlesOrFail();
    }
}

