/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplPMP {
    private static final String _CORN = "foodCorn";
    private static final String _CASSAVA = "foodCassavaRoot";
    private static final String _TARO = "foodTaroRoot";
    private static final String _RICE = "foodRice";
    private static final String _TOMATO = "foodTomato";
    private static final String _CELERY = "foodCelery";
    private static final String _ONION = "foodOnion";
    private static final String _GARLIC = "foodGarlic";
    private static final String _LEEK = "foodLeek";
    private static final String _CUCUMBER = "foodCucumber";
    private static final String _SWEETPEPPER_Y = "foodBellPepperYellow";
    private static final String _SWEETPEPPER_R = "foodBellPepperRed";
    private static final String _SWEETPEPPER_O = "foodBellPepperOrange";
    private static final String _EGGPLANT = "foodEggplant";
    private static final String _BROCCOLI = "foodBroccoli";
    private static final String _CAULIFLOWER = "foodCauliflower";
    private static final String _GREENBEANS = "foodGreenBeans";
    private static final String _BEETS = "foodBeet";
    private static final String _SPINACH = "foodSpinach";
    private static final String _WATERCRESS = "foodWatercress";
    private static final String _GRAPES = "foodGrapesPurple";
    private static final String _STRAWBERRY = "foodStrawberry";
    private static final String _BLUEBERRY = "foodBlueberry";
    private static final String _KIWI = "foodKiwi";
    private static final String _PEANUTS = "foodPeanuts";
    private static final String _MANGO = "foodMango";
    private static final String _ORANGE = "foodOrange";
    private static final String _GRAPEFRUIT = "foodGrapefruit";
    private static final String _BANANA = "foodBanana";
    private static final String _AVOCADO = "foodAvocado";
    private static final String _COCONUT = "foodCoconut";
    private static final String _PLUMS = "foodPlum";
    private static final String _PEAR = "foodPear";
    private static final String _CHERRY = "foodCherry";
    private static final String _APPLE_G = "foodAppleGreen";
    private static final String _APPLE_Y = "foodAppleYellow";
    private static final String _PBJ_SANDWICH = "foodSandwichPBJ";
    private static final String _COOKED_RICE = "foodCookedRice";
    private static final String _T = "_T";
    private static final String _F = "_F";

    ImplPMP() {
    }

    private static String[] SEEDS() {
        return new String[]{"Eggplant", "Tomato", "Corn", "Cucumber", "Spinach", "Asparagus", "Garlic", "Cassava", "Broccoli", "Celery", "Leek", "Cauliflower", "GreenBeans", "BellPepperYellow", "BellPepperRed", "BellPepperOrange", "Lettuce", "Pineapple"};
    }

    static final void fixFoodDictionary(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && config.fixPMPFoodDictionary()) {
            boolean registered;
            boolean bl = registered = mappings.contains(_TARO) && mappings.contains(_SWEETPEPPER_O) && mappings.contains(_CASSAVA);
            if (!registered) {
                String[] pmp_pantry;
                for (String pmp_fooditem : pmp_pantry = new String[]{_CORN, _CASSAVA, _TARO, _RICE, _EGGPLANT, _BROCCOLI, _GREENBEANS, _SPINACH, _WATERCRESS, _AVOCADO, _TOMATO, _CELERY, _ONION, _GARLIC, _LEEK, _CUCUMBER, _BEETS, _CAULIFLOWER, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O, _GRAPES, _STRAWBERRY, _BLUEBERRY, _KIWI, _PEANUTS, _APPLE_G, _APPLE_Y, _MANGO, _ORANGE, _GRAPEFRUIT, _BANANA, _COCONUT, _PLUMS, _PEAR, _CHERRY}) {
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, pmp_fooditem, pmp_fooditem);
                }
            }
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodApple", _APPLE_G);
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodApple", _APPLE_Y);
        }
    }

    static final void detectFeatureSupport(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String forgeid;
            boolean generalize = config.fixPMPFoodDictionary();
            if (!config.isPresent("cassava") && mappings.contains(_CASSAVA)) {
                forgeid = _CASSAVA;
                if (generalize) {
                    forgeid = "foodCassava";
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _CASSAVA);
                }
                config.setPresentAs("cassava", forgeid);
            }
            if (!config.isPresent("grapes") && mappings.contains(_GRAPES)) {
                forgeid = _GRAPES;
                if (generalize) {
                    forgeid = "foodGrapes";
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _GRAPES);
                }
                config.setPresentAs("grapes", forgeid);
            }
            if (!config.isPresent("bellpepper") && mappings.contains(_SWEETPEPPER_Y)) {
                if (generalize) {
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_O);
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_Y);
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_R);
                    config.setPresentAs("bellpepper", "foodBellPepper");
                } else {
                    config.setPresentAs("bellpepper", _SWEETPEPPER_Y);
                }
            }
            if (mappings.contains(_BEETS)) {
                if (!config.isPresent("beets")) {
                    forgeid = _BEETS;
                    if (generalize) {
                        forgeid = "foodBeets";
                        IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _BEETS);
                    }
                    config.setPresentAs("beets", forgeid);
                }
                IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBeets", _BEETS);
            }
        }
    }

    static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && !config.fixPMPFoodDictionary()) {
            String[] primary = new String[]{_BROCCOLI, _EGGPLANT, _CASSAVA, _CAULIFLOWER};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabMain", primary);
            String[] fillers = new String[]{_TOMATO, _ONION, _LEEK, _CORN, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabFill", fillers);
            String[] fruit = new String[]{_MANGO, _APPLE_G, _APPLE_Y, _BANANA, _PLUMS, _PEAR, _ORANGE};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabFruit", fruit);
            String[] nuggets = new String[]{_BROCCOLI, _EGGPLANT, _CAULIFLOWER};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientVegNugget", nuggets);
        }
    }

    static final void registerFoodPowders(int slotid_0th, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && !config.fixPMPFoodDictionary()) {
            FoodPowders.Type fpt;
            Item item;
            boolean debug = config.isDebugMode();
            int id = slotid_0th;
            if (FoodPowders.findType("strawberry") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_STRAWBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "strawberry", new ItemStack(item), 1, 2, null, (Integer)0xDD6161);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("blueberry") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_BLUEBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "blueberry", new ItemStack(item), 1, 3, null, (Integer)6384842);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("peanuts") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_PEANUTS))) != null) {
                fpt = new FoodPowders.Type(id, "peanuts", new ItemStack(item), 0, 3, null, (Integer)12816928);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("leek") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_LEEK))) != null) {
                fpt = new FoodPowders.Type(id, "leek", new ItemStack(item), 0x101000, null, (Integer)15859668);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("tomato") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_TOMATO))) != null) {
                fpt = new FoodPowders.Type(id, "tomato", new ItemStack(item), 4096, 2, "ingredientTomato", (Integer)14111549);
                OreDictionary.registerOre((String)"ingredientTomato", (Item)item);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("celery") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_CELERY))) != null) {
                fpt = new FoodPowders.Type(id, "celery", new ItemStack(item), 0x100000, null, null);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("garlic") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_GARLIC))) != null) {
                fpt = new FoodPowders.Type(id, "garlic", new ItemStack(item), 0x100000, "ingredientGarlic", null);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
        }
    }

    static final void registerEdibleFlowers(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] flowers;
            boolean generalize = config.fixPMPFoodDictionary();
            for (String flower_name : flowers = config.getPMPWaterFlavorFlowers()) {
                Block flower;
                if (!flower_name.startsWith("flower") || (flower = Block.func_149684_b((String)Integrations.PMP.itemid(flower_name))) == null) continue;
                ItemStack all_varieties = new ItemStack(flower, 1, Item.func_150898_a((Block)flower).func_77614_k() ? Short.MAX_VALUE : 0);
                if (generalize) {
                    OreDictionary.registerOre((String)"foodFlower", (ItemStack)all_varieties);
                }
                OreDictionary.registerOre((String)"ingredientFlower", (ItemStack)all_varieties);
                if (!flower_name.startsWith("flowerRose")) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodRoseFlower", (Block)flower);
                }
                OreDictionary.registerOre((String)"ingredientRoseFlower", (Block)flower);
            }
        }
    }

    static final void registerMushrooms(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] fungi;
            boolean generalize = config.fixPMPFoodDictionary();
            for (String fungus : fungi = config.getPMPEdibleMushrooms()) {
                Block item = Block.func_149684_b((String)Integrations.PMP.itemid(fungus));
                if (item == null) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodMushroom", (Block)item);
                }
                OreDictionary.registerOre((String)"ingredientMushroom", (Block)item);
                OreDictionary.registerOre((String)"ingredientKebabFill", (Block)item);
                OreDictionary.registerOre((String)"greenLitterFungi", (Block)item);
            }
        }
    }

    static final void registerPackagedFoods(VfpConfig config) {
        if (!config.isModLoaded(Integrations.PMP)) {
            return;
        }
        boolean debug = config.isDebugMode();
        VfpCapacity BULK = VfpCapacity.BULK_STACK;
        String[] baggables = new String[]{"fruit", _STRAWBERRY, "strawberries", _F, "fruit", _BLUEBERRY, "blueberries", _F, "fruit", _PEANUTS, "peanuts", _F, "fruit", _GRAPES, "grapes", _T, "vegetable", _CORN, "corn", _F, "vegetable", _BROCCOLI, "broccoli", _F, "vegetable", _SPINACH, "spinach", _F, "vegetable", _TOMATO, "tomatoes", _F, "vegetable", _EGGPLANT, "eggplant", _F, "vegetable", _CASSAVA, "cassava", _F, "bakery", _PBJ_SANDWICH, "sandwich_pbj", _F, "general", _COOKED_RICE, "precooked_rice", _T};
        for (int i = 0; i < baggables.length; i += 4) {
            PackagedFood.Type type = PackagedFood.Type.valueOf(baggables[i]);
            Item item = Item.func_111206_d((String)Integrations.PMP.itemid(baggables[i + 1]));
            if (!(item instanceof ItemFood)) continue;
            PackagedFood pf = new PackagedFood(type.name(), baggables[i + 2], new LikeFood((ItemFood)item), null, null, BULK);
            if (baggables[i + 3] == _T) {
                CartonsBuildHelper.exclude(type, pf);
            }
            if (!debug) continue;
            FMLLog.finer((String)"PMP packagedFood '%s' registers: %s", (Object[])new Object[]{baggables[i], pf});
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] crops = ImplPMP.SEEDS();
            Item corn = null;
            for (String cropname : crops) {
                Item seed = Item.func_111206_d((String)Integrations.PMP.itemid("seed" + cropname));
                if (seed == null) continue;
                OreDictionary.registerOre((String)"greenLitterSeeds", (Item)seed);
                OreDictionary.registerOre((String)"itemDryableSeed", (Item)seed);
                if (!"Corn".equals(cropname)) continue;
                corn = seed;
            }
            if (corn != null) {
                OreDictionary.registerOre((String)"additiveScaffold", corn);
            }
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "ingredientBeet", _BEETS);
            if (config.fixPMPTreeDictionary()) {
                String[] logs;
                String[] leaves;
                String[] saplings;
                for (String sapling : saplings = config.getPMPTreeSaplingBlocks()) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(sapling));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String leaf : leaves = config.getPMPTreeLeavesBlocks()) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(leaf));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String log : logs = config.getPMPWoodLogBlocks()) {
                    Block block = Block.func_149684_b((String)Integrations.PMP.itemid(log));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
            }
        }
    }

    static final void autorecipeMisc(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            Item eggplant;
            int yes = 0;
            Item corn_on_cob = Item.func_111206_d((String)Integrations.PMP.itemid(_CORN));
            if (corn_on_cob instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(corn_on_cob), (ItemStack)new ItemStack(VfpObj.Roast_Corn_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if ((eggplant = Item.func_111206_d((String)Integrations.PMP.itemid(_EGGPLANT))) instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(eggplant), (ItemStack)new ItemStack(VfpObj.Roasted_Eggplant_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if (yes == 2) {
                String[] crops;
                for (String cropname : crops = ImplPMP.SEEDS()) {
                    Item seed = Item.func_111206_d((String)Integrations.PMP.itemid("seed" + cropname));
                    Item food = Item.func_111206_d((String)Integrations.PMP.itemid("food" + cropname));
                    if (seed == null || food == null) continue;
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(seed, 2), new Object[]{"s", "p", Character.valueOf('s'), food, Character.valueOf('p'), "itemPaper"}));
                }
            }
        }
    }
}

