/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHVC;
import org.jwaresoftware.mcmods.vfp.integrations.ImplLMod;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPMP;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPNKS;
import org.jwaresoftware.mcmods.vfp.integrations.ImplYAFM;

public final class IntegrationsImpl {
    static final String COMPOST_SEEDS_LISTID = "greenLitterSeeds";
    static final String COMPOST_FUNGI_LISTID = "greenLitterFungi";
    static final int _ANY_TYPE = Short.MAX_VALUE;
    public static final String[] COMMON_INGREDIENTS = new String[]{"Corn", "Soybean", "Peanuts", "SweetPotato", "Cassava", "Onion", "Garlic", "Pepper", "Celery", "Tomato", "Leek", "Scallions", "BellPepper", "Cucumber", "Avocado", "Spinach", "Dasheen", "Kale", "MustardGreens", "Cabbage", "Beets", "Thyme", "Parsley", "Basil", "Sage", "Oregano", "Paprika", "Peppercorn", "Eggplant", "Zucchini", "Okra", "Broccoli", "Cauliflower", "BrusselSprouts", "GreenBeans", "KidneyBeans", "PintoBeans", "ButterBeans", "BlackBeans", "Ginger", "Cinnamon", "Apple", "Coconut", "Mango", "Banana", "Strawberry", "Blueberry", "Kiwi", "Grapes", "Cantaloupe", "Pineapple", "Papaya", "Plums", "Pear", "Cherry", "Orange", "Lime", "Lemon", "Grapefruit", "Rice", "Tofu", "CoffeeBean"};
    public static final String[] COMMON_MIXTURE_SEEDS = new String[]{"Peppercorn", "Celery", "Mustard", "Dill", "Cloves", "Allspice", "Fennel"};
    static final String _XP_NBT_TAG = "vanillafoodpantry:craftXp";

    private static final String getPresentAs(String prefix, Collection<String> mappings, String foodid) {
        String forgeid = prefix + foodid;
        boolean present = mappings.contains(forgeid);
        if (!present && foodid.charAt(foodid.length() - 1) == 's') {
            forgeid = prefix + foodid.substring(0, foodid.length() - 1);
            present = mappings.contains(forgeid);
        }
        return present ? forgeid : null;
    }

    private static final void fixFoodIsSeed(Collection<String> mappings, VfpConfig config) {
        if (!config.isPresent("peppercorn") && config.isPresent("peppercorn_seed")) {
            config.setPresentAs("peppercorn", config.getPresentAs("peppercorn_seed"));
        }
        if (!config.isPresent("corn") && config.isPresent("corn_seed")) {
            config.setPresentAs("corn", config.getPresentAs("corn_seed"));
        }
    }

    public static final void detectFeatureSupport(VfpConfig config) {
        boolean roastSeedsPresent;
        boolean boneDropsPresent;
        boolean friedEggPresent;
        if (config.includeModRecipes()) {
            String forgeid;
            List<String> mappings = config.capturedContextOres();
            ImplPMP.fixFoodDictionary(mappings, config);
            ImplHVC.fixFoodDictionary(mappings, config);
            config.captureContextOres();
            mappings = config.capturedContextOres();
            for (String foodid : COMMON_INGREDIENTS) {
                forgeid = IntegrationsImpl.getPresentAs("food", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase(), forgeid);
            }
            for (String foodid : COMMON_MIXTURE_SEEDS) {
                forgeid = IntegrationsImpl.getPresentAs("seed", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase() + "_seed", forgeid);
            }
            IntegrationsImpl.fixFoodIsSeed(mappings, config);
            ImplPMP.detectFeatureSupport(mappings, config);
            ImplHVC.detectFeatureSupport(mappings, config);
        }
        if (friedEggPresent = IntegrationsImpl.detectSimpleFriedEggRecipe(config)) {
            config.setPresent("fried_eggs");
        }
        if (boneDropsPresent = IntegrationsImpl.detectBoneDroppingFromAnimals(config)) {
            config.setPresent("bone_drops");
        }
        if (roastSeedsPresent = IntegrationsImpl.detectRoastedSeedsRecipes(config)) {
            config.setPresent("roast_seeds");
        }
    }

    static final void _registerFoodItem(Integrations mod, String ingredient_id, String itemname) {
        Item item = Item.func_111206_d((String)mod.itemid(itemname));
        if (item instanceof ItemFood) {
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(Integrations mod, String ingredient_id, String[] choices) {
        for (String itemname : choices) {
            Item item = Item.func_111206_d((String)mod.itemid(itemname));
            if (!(item instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(String ingredient_id, Collection<ItemStack> choices) {
        for (ItemStack item : choices) {
            if (!(item.func_77973_b() instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)item);
        }
    }

    private static final void foodItemToIngredient(String dictid, String ingredient_id) {
        List matches = OreDictionary.getOres((String)dictid);
        for (ItemStack food : matches) {
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)food);
        }
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname) {
        String moditemid = mod.itemid(itemname);
        Item item = Item.func_111206_d((String)moditemid);
        if (item != null) {
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        } else {
            Block blok = Block.func_149684_b((String)moditemid);
            if (blok != null) {
                OreDictionary.registerOre((String)ingredient_id, (Block)blok);
            }
        }
    }

    public static final void registerFoodPowders(Collection<String> mappings, VfpConfig config) {
        FoodPowders.Type fpt;
        if (!config.includeModRecipes()) {
            return;
        }
        boolean debug = config.isDebugMode();
        int slotid = FoodPowders.Type.reservedPowderCount();
        int MAX_COMMON_SLOTS = 16;
        int id = slotid;
        String item = config.getPresentAs("strawberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "strawberry", DictionaryNameItemAdaptor.newi(item), 1, 2, null, (Integer)0xDD6161);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(strawberry): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("blueberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "blueberry", DictionaryNameItemAdaptor.newi(item), 1, 3, null, (Integer)6384842);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(blueberry): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("peanuts");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peanuts", DictionaryNameItemAdaptor.newi(item), 0, 3, null, (Integer)12816928);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(peanuts): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("peppercorn");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peppercorn", DictionaryNameItemAdaptor.newi(item), 0x100000, 3, "ingredientPeppercorn", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientPeppercorn");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(peppercorn): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("onion");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "onion", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientOnion", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientOnion");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(onion): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("leek");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "leek", DictionaryNameItemAdaptor.newi(item), 0x101000, null, (Integer)15859668);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(leek): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("tomato");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "tomato", DictionaryNameItemAdaptor.newi(item), 4096, 2, "ingredientTomato", (Integer)14111549);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientTomato");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(tomato): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("celery");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "celery", DictionaryNameItemAdaptor.newi(item), 0x100000, null, null);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(celery): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("garlic");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "garlic", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientGarlic", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientGarlic");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(garlic): '%s'", (Object[])new Object[]{fpt});
            }
        }
        int slotid_mixes_0 = id + 1;
        int slotid_mixes_N = slotid + 16;
        Validate.validState((slotid_mixes_0 - slotid < 16 ? 1 : 0) != 0, (String)"Only expected to have at most %d predefined food powders (including mixes); have %d ", (Object[])new Object[]{16, slotid_mixes_0 - slotid});
        slotid += 16;
        for (Integrations ii : Integrations.orderedValues()) {
            if (config.isModLoaded(ii)) {
                switch (ii) {
                    case PMP: {
                        ImplPMP.registerFoodPowders(slotid, config);
                    }
                }
            }
            if (ii.reserve() <= 0) continue;
            for (int i = 0; i < ii.reserve(); ++i) {
                slotid += 8;
            }
        }
        IntegrationsImpl.registerMixedFoodPowders(mappings, config, slotid_mixes_0, slotid_mixes_N);
    }

    private static void registerMixedFoodPowders(Collection<String> mappings, VfpConfig config, int slotid_0, int slotid_N) {
        String[] required;
        int id = slotid_0;
        boolean craftable = true;
        for (String ingredient : required = new String[]{"peppercorn", "celery", "onion"}) {
            if (config.isPresent(ingredient)) continue;
            craftable = false;
            break;
        }
        if (craftable) {
            FoodPowders.Type fpt = new FoodPowders.Type(id, "stew_mix", DictionaryNameItemAdaptor.newi("unused"), 0x100000, null, true);
            if (config.isDebugMode()) {
                FMLLog.fine((String)"GEN foodPowder(stew_mix): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
    }

    private static boolean detectSimpleFriedEggRecipe(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        boolean recipePresent = ImplYAFM.isFriedEggRecipePresent(config);
        if (!recipePresent) {
            recipePresent = config.isModLoaded(Integrations.HVC) || config.isModLoaded(Integrations.LOF) || config.isModLoaded(Integrations.MTRP);
        }
        return recipePresent;
    }

    public static boolean detectBoneDroppingFromAnimals(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        return config.isModLoaded(Integrations.LMOD) || config.isModLoaded(Integrations.MTRP);
    }

    private static boolean detectRoastedSeedsRecipes(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        return config.isModLoaded(Integrations.HVC);
    }

    public static final void registerRedMeat(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplLMod.registerRedMeat(config);
            ImplHVC.registerRedMeat(config);
        }
    }

    public static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        String[] nuggets;
        String[] fruits;
        String[] fillers;
        String forgeid;
        String[] primary;
        if (!config.includeModRecipes()) {
            return;
        }
        for (String foodid : primary = new String[]{"tofu", "broccoli", "eggplant", "cauliflower", "cassava", "sweetpotato"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            List choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMain", choices);
        }
        for (String foodid : fillers = new String[]{"tomato", "onion", "leek", "corn", "bellpepper", "zucchini", "brusselsprouts", "pineapple"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            List choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFill", choices);
        }
        for (String foodid : fruits = new String[]{"pineapple_slice", "cantaloupe_slice", "mango", "banana", "kiwi", "orange", "pear", "plum"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            List choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFruit", choices);
        }
        String[] small_fruits = new String[]{"strawberry", "cherry"};
        int hits = 0;
        for (String foodid : small_fruits) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            List choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMiniFruit", choices);
            ++hits;
        }
        if (hits > 0) {
            config.setPresent("mini_fruit");
        }
        for (String foodid : nuggets = new String[]{"broccoli", "eggplant", "cauliflower", "zucchini", "pack_okra"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            List choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientVegNugget", choices);
        }
        ImplPNKS.registerKebabItems(mappings, config);
        ImplPMP.registerKebabItems(mappings, config);
        ImplHVC.registerKebabItems(mappings, config);
        ImplLMod.registerKebabItems(mappings, config);
        ImplYAFM.registerKebabItems(mappings, config);
    }

    public static final void registerEdibleFlowers(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplPMP.registerEdibleFlowers(mappings, config);
        }
    }

    public static final void registerMushrooms(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplPMP.registerMushrooms(mappings, config);
            ImplHVC.registerMushrooms(mappings, config);
        }
    }

    public static final void registerPackagedFoods(VfpConfig config) {
        if (!config.includeModRecipes()) {
            return;
        }
        for (Integrations ii : Integrations.orderedValues()) {
            switch (ii) {
                case PMP: {
                    ImplPMP.registerPackagedFoods(config);
                    break;
                }
                case HVC: {
                    ImplHVC.registerPackagedFoods(config);
                }
            }
            if (ii.reserve() <= 0) continue;
            for (int j = 0; j < ii.reserve(); ++j) {
                PackagedFood.shift16();
            }
        }
    }

    public static final void registerAsTie(Item item) {
        OreDictionary.registerOre((String)"itemTieStrong", (Item)item);
        OreDictionary.registerOre((String)"itemTieNormal", (Item)item);
        OreDictionary.registerOre((String)"itemTieWeak", (Item)item);
        OreDictionary.registerOre((String)"string", (Item)item);
    }

    public static final void registerForgeIds(VfpConfig config) {
        IntegrationsImpl.registerVanillaItemForgeIds();
        IntegrationsImpl.registerItemBucketIfMissing();
        ImplPMP.registerCompatibleForgeIds(config);
        ImplHVC.registerCompatibleForgeIds(config);
    }

    private static final void registerVanillaItemForgeIds() {
    }

    private static final void registerItemBucketIfMissing() {
        if (!VfpUtils.ingredientDefined("itemEmptyBucket")) {
            OreDictionary.registerOre((String)"itemEmptyBucket", (Item)Items.field_151133_ar);
        }
        if (!VfpUtils.ingredientDefined("itemWaterBucket")) {
            OreDictionary.registerOre((String)"itemWaterBucket", (Item)Items.field_151131_as);
        }
        if (!VfpUtils.ingredientDefined("itemLavaBucket")) {
            OreDictionary.registerOre((String)"itemLavaBucket", (Item)Items.field_151129_at);
        }
        if (!VfpUtils.ingredientDefined("itemMilkBucket")) {
            OreDictionary.registerOre((String)"itemMilkBucket", (Item)Items.field_151117_aB);
        }
    }

    private static final void addAllRegisteredCraftingXpRecipes(VfpConfig config) {
        ImmutableList registrations = FMLInterModComms.fetchRuntimeMessages((Object)"vanillafoodpantry");
        if (config.includeCraftXpAndAchievements()) {
            for (FMLInterModComms.IMCMessage msg : registrations) {
                if (!"addRewardingCraftItem".equals(msg.key) || !msg.isItemStackMessage()) continue;
                ItemStack crafted = msg.getItemStackValue();
                NBTTagCompound itemdata = null;
                if (!crafted.func_77942_o() || !(itemdata = crafted.func_77978_p()).func_150297_b(_XP_NBT_TAG, 99)) continue;
                float xp = itemdata.func_74760_g(_XP_NBT_TAG);
                VfpRewards.addRewardingCraftItem(crafted, xp);
            }
        }
    }

    public static final void registerAutocraftingRecipes(VfpConfig config) {
        IntegrationsImpl.addAllRegisteredCraftingXpRecipes(config);
        if (config.isModLoaded(Integrations.SMH) && config.isAutocraftingEnabled()) {
            IntegrationsImpl.registerItemBucketIfMissing();
            IntegrationsImpl.addHoardercraftRecipesBuilder(config, "org.jwaresoftware.mcmods.vfp.integrations.ImplSMH");
        }
    }

    static final void addHoardercraftRecipesBuilder(VfpConfig config, String builderClassName) {
        FMLInterModComms.sendMessage((String)Integrations.SMH.modid(), (String)"registerRecipes", (String)builderClassName);
    }

    public static final void autorecipeMisc(VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplPNKS.autorecipeMisc(config);
            ImplPMP.autorecipeMisc(config);
            ImplLMod.autorecipeMisc(config);
            ImplHVC.autorecipeMisc(config);
        }
    }
}

