/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class MeatPortions
extends VfpPantryMultiItem {
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static MeatPortions INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private List<PackagedFood> _meats;

    public static final void validState() {
        VfpUtils.validState(VfpOid.Portion, VARIANT_SET, VARIANT_ARRAY);
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"Meat portion item singleton not allocated", (Object[])new Object[0]);
    }

    public MeatPortions(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    private static final boolean isFish(VfpVariant variant) {
        return variant.fmlid().endsWith("fish") || variant.fmlid().endsWith("cod") || variant.fmlid().endsWith("salmon");
    }

    static final synchronized MeatPortions get() {
        if (INSTANCE == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(16);
            String basename = VARIANT_SET.typeName();
            List<PackagedFood> meats = PackagedFood.values(PackagedFood.Type.meat.name(), Arrays.asList(PackagedFood.EGG, PackagedFood.BONES, PackagedFood.ROTTEN_FLESH, PackagedFood.WOLF, PackagedFood.PORK_HOCKS, PackagedFood.PIGTAILS));
            int j = 0;
            for (PackagedFood meat : meats) {
                String fmlid = basename + "_" + meat.fmlid_suffix();
                variants.add(new VfpVariant(j, fmlid, LikeFood.uncooked_meat_portion, VARIANT_SET, j == 0));
                ++j;
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Meat_Portion, MeatPortions.class, VfpBuilder.User.INTERNAL);
            MeatPortions.INSTANCE._meats = meats;
            MeatPortions.validState();
            for (j = 0; j < VARIANT_ARRAY.length; ++j) {
                VfpVariant variant = VARIANT_ARRAY[j];
                ItemStack a_portion = new ItemStack((Item)INSTANCE, 1, j);
                OreDictionary.registerOre((String)"portionMeat", (ItemStack)a_portion);
                if (!MeatPortions.isFish(variant)) continue;
                OreDictionary.registerOre((String)"portionFish", (ItemStack)a_portion);
            }
        }
        return INSTANCE;
    }

    static final synchronized void autorecipe(Item jerky_obj) {
        if (TYPED_INSTANCES == null) {
            MeatPortions.get();
            int portions_count = VfpCapacity.ADDITIVE_BATCH.count();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            for (int j = 0; j < VARIANT_ARRAY.length; ++j) {
                VfpVariant variant = VARIANT_ARRAY[j];
                boolean is_fish = MeatPortions.isFish(variant);
                boolean is_squid = variant.fmlid().contains("squid");
                ItemStack portions = new ItemStack((Item)INSTANCE, is_fish ? 4 : (is_squid ? 3 : portions_count), j);
                instances.add(new ItemStack((Item)INSTANCE, 1, j));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(portions, new Object[]{MeatPortions.INSTANCE._meats.get(j).food().sample(), "itemFoodCutter"}));
                if (jerky_obj == null || is_fish) continue;
                GameRegistry.addSmelting((ItemStack)new ItemStack((Item)INSTANCE, 1, j), (ItemStack)new ItemStack(jerky_obj), (float)LikeFood.uncooked_meat_portion.smeltExperience());
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack get(PackagedFood food) {
        if (PackagedFood.Type.meat.name().equals(food.type())) {
            for (int i = 0; i < MeatPortions.INSTANCE._meats.size(); ++i) {
                if (food != MeatPortions.INSTANCE._meats.get(i)) continue;
                return TYPED_INSTANCES != null ? TYPED_INSTANCES[i].func_77946_l() : new ItemStack((Item)INSTANCE, 1, i);
            }
        }
        return null;
    }

    public static final boolean registerSourcesUnder(String dictid) {
        boolean done = false;
        if (INSTANCE != null) {
            for (int i = 0; i < MeatPortions.INSTANCE._meats.size(); ++i) {
                ItemStack meat = MeatPortions.INSTANCE._meats.get(i).food().sample();
                OreDictionary.registerOre((String)dictid, (ItemStack)meat);
            }
            done = true;
        }
        return done;
    }

    public static final List<ItemStack> achievementCandidates() {
        return Arrays.asList(TYPED_INSTANCES);
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstanceVType((VfpProfile)VfpOid.Portion, (Class)MeatPortions.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

