/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;

public final class Nuggets
extends VfpPantryMultiItem {
    private static final int NUGGET_BATCH = 6;
    private static final String DARK_MEAT = "dark_meat";
    private static final String LIGHT_MEAT = "light_meat";
    private static final String ANY_FISH = "fish";
    private static final String ANY_VEGGIE = "veggie";
    private static final String SQUID = "squid";
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Nuggets INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static List<ItemStack> COMBO_INSTANCES;

    public Nuggets(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    static final synchronized Nuggets get() {
        if (INSTANCE == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(51);
            for (NuggetDef nuggetDef : NuggetDef.values()) {
                nuggetDef.install(variants, VARIANT_SET);
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Nuggets, Nuggets.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static final void addFried(NuggetDef def, ItemStack battermix, List<ItemStack> instances) {
        if (!def._can_fry) {
            return;
        }
        ItemStack fried_prepped = new ItemStack((Item)INSTANCE, 6, def.fried_prep_meta());
        ItemStack fried = new ItemStack((Item)INSTANCE, 1, def.fried_meta());
        if (def._type == ANY_VEGGIE) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fried_prepped, new Object[]{"vv", "bw", Character.valueOf('v'), def.raw_ingredient(), Character.valueOf('b'), battermix, Character.valueOf('w'), "portionWater"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fried_prepped, new Object[]{"nnn", "nnn", "bw ", Character.valueOf('n'), def.raw_ingredient(), Character.valueOf('b'), battermix, Character.valueOf('w'), "portionWater"}));
        }
        fried_prepped.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)fried_prepped, (ItemStack)fried, (float)LikeFood.uncooked_meat_portion.smeltExperience());
        instances.add(fried_prepped);
        instances.add(fried);
    }

    private static final void addJerky(NuggetDef def, ItemStack rubmix, List<ItemStack> instances) {
        if (!def._can_dry) {
            return;
        }
        ItemStack jerky_prepped = new ItemStack((Item)INSTANCE, 6, def.jerky_prep_meta());
        ItemStack jerky = new ItemStack((Item)INSTANCE, 1, def.jerky_meta());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(jerky_prepped, new Object[]{"nnn", "nnn", "rd ", Character.valueOf('n'), def.raw_ingredient(), Character.valueOf('r'), rubmix, Character.valueOf('d'), "additiveDrying"}));
        jerky_prepped.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)jerky_prepped, (ItemStack)jerky, (float)LikeFood.uncooked_meat_portion.smeltExperience());
        instances.add(jerky_prepped);
        instances.add(jerky);
    }

    private static final void addCombo(NuggetDef def, List<ItemStack> instances, List<ItemStack> combos) {
        if (!def._can_mix || !def._can_fry) {
            return;
        }
        ItemStack combo = new ItemStack((Item)INSTANCE, 1, def.combo_meta());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(combo, new Object[]{"nnn", "fp ", Character.valueOf('n'), new ItemStack((Item)INSTANCE, 1, def.fried_meta()), Character.valueOf('f'), def._type == ANY_VEGGIE ? Fries.klingon(1) : "foodFrenchFries", Character.valueOf('p'), Items.field_151121_aF}));
        instances.add(combo);
        combos.add(combo);
    }

    static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null) {
            Nuggets.get();
            COMBO_INSTANCES = new ArrayList<ItemStack>();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(51);
            ItemStack battermix = FoodPowders.get(FoodPowders.Type.BATTER_MIX, 1);
            ItemStack jerkyrub = FoodPowders.get(FoodPowders.Type.JERKY_RUB, 1);
            for (NuggetDef def : NuggetDef.values()) {
                if (def.raw_ingredient() instanceof String && !VfpUtils.ingredientDefined((String)def.raw_ingredient())) {
                    Nuggets.addCombo(def, instances, COMBO_INSTANCES);
                    continue;
                }
                Nuggets.addFried(def, battermix, instances);
                Nuggets.addJerky(def, jerkyrub, instances);
                Nuggets.addCombo(def, instances, COMBO_INSTANCES);
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static final List<ItemStack> achievementCandidates() {
        return COMBO_INSTANCES;
    }

    public static final ItemStack battered(NuggetDef def) {
        ItemStack stack = null;
        if (def != null && def._can_fry) {
            stack = new ItemStack((Item)INSTANCE, 1, def.fried_prep_meta());
        }
        return stack;
    }

    public static final ItemStack combo(NuggetDef def) {
        ItemStack stack = null;
        if (def != null && def._can_mix) {
            stack = new ItemStack((Item)INSTANCE, 1, def.combo_meta());
        }
        return stack;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Nuggets, (Class)Nuggets.class, "type"){

            @Override
            public String[] renderNames() {
                VfpVariant[] enumset = this.declaredVariants();
                String[] names = new String[enumset.length];
                for (int i = 0; i < enumset.length; ++i) {
                    names[i] = "vanillafoodpantry:" + enumset[i].datadata(String.class);
                }
                return names;
            }

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }

    public static enum NuggetDef {
        Chicken(12, "chicken", "light_meat", MeatPortions.get(PackagedFood.CHICKEN), true, false, true),
        Beef(24, "beef", "dark_meat", MeatPortions.get(PackagedFood.BEEF), true, true, true),
        Fish(36, "fish", "fish", "portionFish", true, true, true),
        Mushroom(48, "mushrooms", "mushroom", "foodMushroom", true, false, true),
        Veggie(60, "veggies", "veggie", "ingredientVegNugget", true, false, true),
        Squid(72, "squid", "squid", MeatPortions.get(PackagedFood.SQUID), true, false, true);

        private final int _meta_raw;
        private final String _name;
        final String _type;
        private final Object _raw_ingredient;
        final boolean _can_fry;
        final boolean _can_dry;
        final boolean _can_mix;

        private NuggetDef(int meta, String name, String kind, Object raw, boolean fry, boolean dry, boolean mix) {
            this._meta_raw = meta;
            this._name = name;
            this._type = kind;
            this._raw_ingredient = raw;
            this._can_fry = fry;
            this._can_dry = dry;
            this._can_mix = mix;
        }

        private void install(int prep_meta, String variety, LikeFood plate, List<VfpVariant> variants, VfpVariantSet variantset) {
            String rendername;
            String fmlid;
            if (plate == null) {
                fmlid = "nuggets_" + this._name + "_" + variety + "_prep";
                rendername = "nugget_" + this._type + "_" + variety + "_prep";
                variants.add(new VfpTransientVariant(prep_meta + 0, fmlid, LikeFood.uncooked_meat_portion, rendername, null, variantset));
            }
            fmlid = "nuggets_" + this._name + "_" + variety;
            rendername = "nugget_" + this._type + "_" + variety;
            variants.add(new VfpTransientVariant(prep_meta + 1, fmlid, plate == null ? LikeFood.meat_portion : plate, rendername, null, variantset));
        }

        void install(List<VfpVariant> variants, VfpVariantSet variantset) {
            if (this._can_fry) {
                this.install(this.fried_prep_meta(), "fried", null, variants, variantset);
            }
            if (this._can_dry) {
                this.install(this.jerky_prep_meta(), "jerky", null, variants, variantset);
            }
            if (this._can_mix) {
                this.install(this.combo_prep_meta(), "combo", LikeFood.nugget_combo, variants, variantset);
            }
        }

        final Object raw_ingredient() {
            return this._raw_ingredient;
        }

        final int fried_prep_meta() {
            return this._meta_raw + 0;
        }

        final int fried_meta() {
            return this._meta_raw + 1;
        }

        final int jerky_prep_meta() {
            return this._meta_raw + 2;
        }

        final int jerky_meta() {
            return this._meta_raw + 3;
        }

        final int combo_prep_meta() {
            return this._meta_raw + 4;
        }

        final int combo_meta() {
            return this._meta_raw + 5;
        }
    }
}

