/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;

public class WolfItems
extends VfpBuildHelperSupport {
    private static final String NBT_EFFECTS = "CustomPotionEffects";

    @Override
    protected String categoryName() {
        return "WolfDrops";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Wolf_Raw_obj = VfpBuilder.newFood(VfpOid.Wolf_Raw, LikeFood.uncooked_wolf);
        VfpObj.Wolf_Cooked_obj = VfpBuilder.newFood(VfpOid.Wolf_Cooked, LikeFood.wolf);
        VfpObj.Wolf_Spirit_obj = VfpBuilder.newMisc(VfpOid.Wolf_Spirit).func_77631_c("").func_77637_a(CreativeTabs.field_78038_k);
        VfpObj.Wolf_Spirit_Element_obj = WolfsSpiritElement.get();
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Wolf_Raw_obj);
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        LikeFood.wolf.food().item(VfpObj.Wolf_Cooked_obj);
        LikeFood.uncooked_wolf.food().item(VfpObj.Wolf_Raw_obj);
    }

    private ItemStack buildWolfsSpiritPotion(boolean levelUp) {
        ItemStack potion = new ItemStack(VfpObj.Potion_Base_obj);
        NBTTagList itemsNbt = new NBTTagList();
        int duration = levelUp ? 9600 : 3600;
        NBTTagCompound effectNbt = new NBTTagCompound();
        new PotionEffect(Potion.field_76439_r.func_76396_c(), duration, 0, false, false).func_82719_a(effectNbt);
        itemsNbt.func_74742_a((NBTBase)effectNbt);
        effectNbt = new NBTTagCompound();
        new PotionEffect(Potion.field_76441_p.func_76396_c(), duration, 0, false, false).func_82719_a(effectNbt);
        itemsNbt.func_74742_a((NBTBase)effectNbt);
        effectNbt = new NBTTagCompound();
        new PotionEffect(Potion.field_76424_c.func_76396_c(), duration, levelUp ? 1 : 0, false, false).func_82719_a(effectNbt);
        itemsNbt.func_74742_a((NBTBase)effectNbt);
        effectNbt = new NBTTagCompound();
        new PotionEffect(Potion.field_76430_j.func_76396_c(), duration, levelUp ? 2 : 1, false, false).func_82719_a(effectNbt);
        itemsNbt.func_74742_a((NBTBase)effectNbt);
        potion.func_77983_a("vfp_unlocalizedName", (NBTBase)new NBTTagString("wolf_spirit_potion" + (levelUp ? "II" : "")));
        potion.func_77983_a("vfp_colorValue", (NBTBase)new NBTTagInt(levelUp ? 4741120 : 5931008));
        potion.func_77983_a(NBT_EFFECTS, (NBTBase)itemsNbt);
        return potion;
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        GameRegistry.addSmelting((Item)VfpObj.Wolf_Raw_obj, (ItemStack)new ItemStack(VfpObj.Wolf_Cooked_obj), (float)LikeFood.uncooked_wolf.smeltExperience());
        ItemStack anyElement = new ItemStack(VfpObj.Wolf_Spirit_Element_obj, 1, Short.MAX_VALUE);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(VfpObj.Wolf_Spirit_obj, new Object[]{anyElement, anyElement, Items.field_151074_bl}));
        ItemStack potion = this.buildWolfsSpiritPotion(false);
        int awkward = PotionHelper.func_77913_a((int)0, (String)MinecraftGlue.AWKWARD_POTION_EFFECT_ENCODING());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, awkward), (ItemStack)new ItemStack(VfpObj.Wolf_Spirit_obj), (ItemStack)potion);
        ItemStack potionII = this.buildWolfsSpiritPotion(true);
        BrewingRecipeRegistry.addRecipe((ItemStack)potion, (ItemStack)anyElement, (ItemStack)potionII);
    }

    @Override
    public void doAddChestGenLoot(VfpRuntime runtime) {
        ChestGenHooks temple = ChestGenHooks.getInfo((String)"pyramidJungleChest");
        temple.addItem(new WeightedRandomChestContent(this.buildWolfsSpiritPotion(false), 1, 1, MinecraftGlue.TREASURE_WEIGHT()));
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Raw, VfpObj.Wolf_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Cooked, VfpObj.Wolf_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit, VfpObj.Wolf_Spirit_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit_Element, VfpObj.Wolf_Spirit_Element_obj, WolfsSpiritElement.variants());
        }
    }
}

