/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpStew;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.milk.CondensedMilkHelper;
import org.jwaresoftware.mcmods.vfp.milk.CreamSoups;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;
import org.jwaresoftware.mcmods.vfp.milk.TeaDrinks;

public final class MilkExtrasBuildHelper
extends VfpBuildHelperSupport {
    private CondensedMilkHelper _condensedHelper = new CondensedMilkHelper();

    @Override
    protected String categoryName() {
        return "MilkExtras";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Cloth_Bag_obj = VfpBuilder.newMisc(VfpOid.Cloth_Bag);
        OreDictionary.registerOre((String)"itemCheeseCloth", (Item)VfpObj.Cloth_Bag_obj);
        MilkDrinks.register(FoodPowders.Type.COCOA);
        MilkDrinks.register(FoodPowders.Type.CREAM);
        MilkDrinks.register(FoodPowders.Type.PUMPKIN);
        MilkDrinks.register(FoodPowders.Type.CACTUS);
        MilkDrinks.register(FoodPowders.Type.APPLE);
        MilkDrinks.register(FoodPowders.Type.MUSCLE);
        String[] others = new String[]{"blueberry", "strawberry", "peanuts"};
        for (String other : others) {
            FoodPowders.Type powder = FoodPowders.findType(other);
            if (powder == null) continue;
            MilkDrinks.register(powder);
        }
        VfpObj.CheeseBall_obj = VfpBuilder.newFood(VfpOid.Cheese_Ball, LikeFood.cheese_portion);
        VfpObj.Cheese_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Cheese_Pantry_Block, VfpObj.CheeseBall_obj);
        VfpObj.Cheese_Sandwich_obj = VfpBuilder.newFood(VfpOid.Cheese_Sandwich, LikeFood.cheese_sandwich);
        OreDictionary.registerOre((String)"foodCheese", (Item)VfpObj.CheeseBall_obj);
        OreDictionary.registerOre((String)"ingredientCheese", (Item)VfpObj.CheeseBall_obj);
        TeaDrinks.register(FoodPowders.Type.BUSHTEA);
        TeaDrinks.register(new Ingredient("milky_bushtea", FoodPowders.Usage.DRINK_FLAVOR.idFirst() + 0, FoodPowders.get(FoodPowders.Type.BUSHTEA, 1), 2), 11060315);
        TeaDrinks.register(FoodPowders.Type.DANDTEA);
        TeaDrinks.register(new Ingredient("milky_dandtea", FoodPowders.Usage.DRINK_FLAVOR.idFirst() + 1, FoodPowders.get(FoodPowders.Type.DANDTEA, 1), 2), 13943960);
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isSoupFlavor()) continue;
            CreamSoups.register(powder);
        }
        VfpObj.Fish_Chowder_obj = VfpStew.newStew(VfpOid.Fish_Chowder, LikeFood.fish_chowder);
        VfpObj.Potato_Chowder_obj = VfpStew.newStew(VfpOid.Potato_Chowder, LikeFood.tato_chowder);
        this._condensedHelper.doBuildPrimaryObjects(event, runtime);
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.MilkDrinks_obj = MilkDrinks.get();
        OreDictionary.registerOre((String)"portionMilk", (ItemStack)MilkDrinks.plain(1));
        OreDictionary.registerOre((String)"ingredientMilk", (ItemStack)MilkDrinks.plain(1));
        OreDictionary.registerOre((String)"ingredientCream", (ItemStack)MilkDrinks.heavy(1));
        VfpObj.TeaDrinks_obj = TeaDrinks.get();
        VfpObj.CreamSoups_obj = CreamSoups.get(runtime.getConfig());
        OreDictionary.registerOre((String)"foodSoup", (Item)VfpObj.Fish_Chowder_obj);
        OreDictionary.registerOre((String)"foodSoup", (Item)VfpObj.Potato_Chowder_obj);
        this._condensedHelper.doBuildSecondaryObjects(event, runtime);
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        LikeFood.milk.food().item(MilkDrinks.plain(1));
        LikeFood.cream.food().item(MilkDrinks.heavy(1));
        LikeFood.sweet_milk.food().item(MilkDrinks.other(FoodPowders.Type.CREAM, 1));
        LikeFood.cheese_portion.food().item(VfpObj.CheeseBall_obj);
        LikeFood.cheese_sandwich.food().item(VfpObj.Cheese_Sandwich_obj);
        LikeFood.bush_tea.food().item(TeaDrinks.bush(1));
        this._condensedHelper.doInitLikeFoods(runtime);
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        Object tieObject = Items.field_151007_F;
        if (VfpUtils.ingredientDefined("itemTieNormal")) {
            tieObject = "itemTieNormal";
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Cloth_Bag_obj, VfpCapacity.MAX_STACK_LCD.count() * 3), new Object[]{".t.", "wsw", ".w.", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('s'), tieObject, Character.valueOf('t'), "stickWood"}));
        MilkDrinks.autorecipe();
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.CheeseBall_obj, 2), new Object[]{"portionMilkLarge", "additiveMilkCurdle", VfpObj.Cloth_Bag_obj}), LikeFood.cheese_portion.craftExperience()));
        VfpBuilder.autorecipe("Cheese", VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.CheeseBall_obj, VfpObj.Cheese_Pantry_Block_obj, VfpObj.CheeseBall_obj);
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Cheese_Sandwich_obj, VfpCapacity.SANDWICH_BATCH.count()), new Object[]{"ccc", " b ", Character.valueOf('c'), "foodCheese", Character.valueOf('b'), "foodBreadSandwich"}), LikeFood.sandwich.craftExperience()));
        TeaDrinks.autorecipe();
        CreamSoups.autorecipe();
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fish_Chowder_obj, 3), new Object[]{"CSC", "pmc", "bbb", Character.valueOf('C'), new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.COD.func_150976_a()), Character.valueOf('S'), new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()), Character.valueOf('p'), Items.field_151168_bH, Character.valueOf('c'), Items.field_151172_bF, Character.valueOf('m'), MilkDrinks.heavy(1), Character.valueOf('b'), Items.field_151054_z}), VfpOid.Fish_Chowder.craftingXp()));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fish_Chowder_obj, 3), new Object[]{"qSq", "pmc", "bbb", Character.valueOf('q'), new ItemStack(VfpObj.Squid_Cooked_obj), Character.valueOf('S'), new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()), Character.valueOf('p'), Items.field_151168_bH, Character.valueOf('c'), Items.field_151172_bF, Character.valueOf('m'), MilkDrinks.heavy(1), Character.valueOf('b'), Items.field_151054_z}));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Potato_Chowder_obj, 3), new Object[]{"ppp", "hmh", "bbb", Character.valueOf('p'), Items.field_151168_bH, Character.valueOf('h'), VfpObj.Portion_Ham_obj, Character.valueOf('m'), MilkDrinks.heavy(1), Character.valueOf('b'), Items.field_151054_z}), VfpOid.Potato_Chowder.craftingXp()));
        this._condensedHelper.doBuildRecipes(runtime);
    }

    @Override
    public void doAddChestGenLoot(VfpRuntime runtime) {
        ChestGenHooks dungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        dungeon.addItem(new WeightedRandomChestContent(MilkDrinks.other(FoodPowders.Type.MUSCLE, 1), 1, 2, MinecraftGlue.UNCOMMON_WEIGHT()));
        this._condensedHelper.doAddChestGenLoot(runtime);
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(MilkDrinks.heavy(1), VfpAchievements.Id.MooRiches);
        VfpRewards.addRewardingCraftItem(VfpObj.CheeseBall_obj, VfpAchievements.Id.NewWorldsOfTaste);
        VfpRewards.addRewardingCraftItem(VfpObj.Fish_Chowder_obj, VfpAchievements.Id.ChowderHound);
        VfpRewards.addRewardingCraftItem(VfpObj.Potato_Chowder_obj, VfpAchievements.Id.ChowderHound);
        for (ItemStack tea : TeaDrinks.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(tea, VfpAchievements.Id.TeaTime);
        }
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cloth_Bag, VfpObj.Cloth_Bag_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Ball, VfpObj.CheeseBall_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Pantry_Block, VfpObj.Cheese_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cheese_Sandwich, VfpObj.Cheese_Sandwich_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fish_Chowder, VfpObj.Fish_Chowder_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Potato_Chowder, VfpObj.Potato_Chowder_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.MilkDrink, VfpObj.MilkDrinks_obj, MilkDrinks.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.TeaDrink, VfpObj.TeaDrinks_obj, TeaDrinks.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.CreamSoup, VfpObj.CreamSoups_obj, CreamSoups.variants());
        }
        this._condensedHelper.doInitRenderModels(event, runtime);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        this._condensedHelper.doFinish(event, runtime);
    }
}

