/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;

public final class Breads
extends VfpPantryMultiItem {
    static final LikeFood B_PLAIN = LikeFood.flouronly_bread;
    static final LikeFood B_ENRICHED = LikeFood.enriched_bread;
    static final LikeFood B_SPECIALTY = LikeFood.specialty_bread;
    static final LikeFood B_MUSCLE = new LikeFood("musclebread", 0, B_SPECIALTY, LikeFood.muscle_boost, LikeFood.muscle_boost);
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Breads INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final void validState() {
        Validate.validState((VARIANT_ARRAY != null ? 1 : 0) != 0, (String)"Breads variant array not allocated?", (Object[])new Object[0]);
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"Breads item singleton not allocated?", (Object[])new Object[0]);
    }

    public Breads(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        BreadDef breadDef;
        if (!world.field_72995_K && (breadDef = VfpVariant.byItemStack(stack, this._variant_default).datadata(BreadDef.class)).id() == BreadDef.Muscle.id()) {
            MinecraftGlue.onMuscleFoodEaten(player, -1);
        }
        super.func_77849_c(stack, world, player);
    }

    public static final synchronized Breads get() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(16);
            for (BreadDef breadDef : BreadDef.values()) {
                String fmlid = breadDef.unlocalizedName();
                LikeFood like = breadDef.cooked() ? breadDef.likeFood() : null;
                CreativeTabs tab = breadDef.cooked() ? null : CreativeTabs.field_78035_l;
                variants.add(new VfpTransientVariant(breadDef.id(), fmlid, like, (Object)breadDef, tab, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Breads, Breads.class, VfpBuilder.User.INTERNAL);
            Breads.validState();
            for (BreadDef breadDef : BreadDef.values()) {
                if (!breadDef.cooked()) continue;
                ItemStack a_bread = new ItemStack((Item)INSTANCE, 1, breadDef.id());
                OreDictionary.registerOre((String)"foodBread", (ItemStack)a_bread);
                if (!breadDef.sandwichOk()) continue;
                OreDictionary.registerOre((String)"foodBreadSandwich", (ItemStack)a_bread);
            }
            VfpObj.Flat_Bread_Pocket_obj = VfpBuilder.newFood(VfpOid.Flat_Bread_Pocket, LikeFood.bread_pocket);
        }
        return INSTANCE;
    }

    public static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null && Breads.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            ItemStack milk_powder = FoodPowders.get(FoodPowders.Type.MILK, 1);
            ItemStack bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_French.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "ew.", "...", Character.valueOf('d'), "foodDough", Character.valueOf('e'), VfpObj.Egg_White_obj, Character.valueOf('w'), "portionWaterSmall"}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.French.id()), (float)LikeFood.flouronly_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.French.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Plain.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "...", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('m'), milk_powder}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Plain.id()), (float)LikeFood.enriched_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Plain.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Egg.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "EE.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('m'), milk_powder, Character.valueOf('E'), FoodPowders.get(FoodPowders.Type.EGG, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Egg.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Egg.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Potato.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "pp.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('m'), milk_powder, Character.valueOf('p'), FoodPowders.get(FoodPowders.Type.POTATO, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Potato.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Potato.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Pumpkin.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "pp.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('p'), FoodPowders.get(FoodPowders.Type.PUMPKIN, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Pumpkin.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Pumpkin.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Apple.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "aa.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('a'), FoodPowders.get(FoodPowders.Type.APPLE, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Apple.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Apple.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Molasses.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "mc.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('m'), VfpObj.Molasses_Ball_obj, Character.valueOf('c'), FoodPowders.get(FoodPowders.Type.COCOA, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Molasses.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Molasses.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Klingon.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "xx.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('x'), FoodPowders.get(FoodPowders.Type.CACTUS, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Klingon.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Klingon.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Muscle.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "xx.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('x'), FoodPowders.get(FoodPowders.Type.MUSCLE, 1)}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Muscle.id()), (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Muscle.id()));
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Flat.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(bread, new Object[]{"foodDough", VfpObj.Sand_Jar_obj}));
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)new ItemStack((Item)INSTANCE, 1, BreadDef.Flat.id()), (float)LikeFood.flouronly_bread.smeltExperience());
            instances.add(new ItemStack((Item)INSTANCE, 1, BreadDef.Flat.id()));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Flat_Bread_Pocket_obj, 2), new Object[]{new ItemStack((Item)INSTANCE, 1, BreadDef.Flat.id())}));
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
            for (VfpVariant variant : VARIANT_ARRAY) {
                BreadDef breadDef = variant.datadata(BreadDef.class);
                if (breadDef.cooked()) continue;
                VfpRewards.addRewardingCraftItem(new ItemStack((Item)INSTANCE, 1, breadDef.id()), breadDef.likeFood().craftExperience());
            }
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack french(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.French.id());
    }

    public static final ItemStack uncooked_french(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_French.id());
    }

    public static final ItemStack enriched(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Plain.id());
    }

    public static final ItemStack pumpkin(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Pumpkin.id());
    }

    public static final ItemStack uncooked_pumpkin(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_Pumpkin.id());
    }

    public static final ItemStack flat(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Flat.id());
    }

    public static final ItemStack uncooked_muscle(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_Muscle.id());
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (VfpVariant variant : VARIANT_ARRAY) {
            BreadDef breadDef = variant.datadata(BreadDef.class);
            if (!breadDef.getsAchievement()) continue;
            list.add(new ItemStack((Item)INSTANCE, 1, breadDef.id()));
        }
        return list;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Breads, (Class)Breads.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }

    static enum BreadDef {
        Plain(true, "enriched", B_ENRICHED, FoodPowders.Usage.BREAD_FLAVOR.idFirst(), true, false),
        Uncooked_Plain(false, "enriched", B_ENRICHED, BreadDef.Plain._id + 1, false),
        Molasses(true, "molasses", B_SPECIALTY, BreadDef.Uncooked_Plain._id + 1, true),
        Uncooked_Molasses(false, BreadDef.Molasses._name, BreadDef.Molasses._like, BreadDef.Molasses._id + 1, true),
        Egg(true, "egg", B_SPECIALTY, BreadDef.Uncooked_Molasses._id + 1, true, true),
        Uncooked_Egg(false, BreadDef.Egg._name, BreadDef.Egg._like, BreadDef.Egg._id + 1, true),
        Apple(true, "apple", B_SPECIALTY, BreadDef.Uncooked_Egg._id + 1, true),
        Uncooked_Apple(false, BreadDef.Apple._name, BreadDef.Apple._like, BreadDef.Apple._id + 1, true),
        Pumpkin(true, "pumpkin", B_SPECIALTY, BreadDef.Uncooked_Apple._id + 1, true),
        Uncooked_Pumpkin(false, BreadDef.Pumpkin._name, BreadDef.Pumpkin._like, BreadDef.Pumpkin._id + 1, true),
        French(true, "french", B_PLAIN, BreadDef.Uncooked_Pumpkin._id + 1, true, false),
        Uncooked_French(false, BreadDef.French._name, BreadDef.French._like, BreadDef.French._id + 1, false),
        Potato(true, "potato", B_SPECIALTY, BreadDef.Uncooked_French._id + 1, true, true),
        Uncooked_Potato(false, BreadDef.Potato._name, BreadDef.Potato._like, BreadDef.Potato._id + 1, true),
        Muscle(true, "muscle", B_MUSCLE, BreadDef.Uncooked_Potato._id + 1, false, true),
        Uncooked_Muscle(false, BreadDef.Muscle._name, BreadDef.Muscle._like, BreadDef.Muscle._id + 1, false),
        Klingon(true, "klingon", B_SPECIALTY, BreadDef.Uncooked_Muscle._id + 1, false, true),
        Uncooked_Klingon(false, BreadDef.Klingon._name, BreadDef.Klingon._like, BreadDef.Klingon._id + 1, true),
        Flat(true, "flat", B_PLAIN, BreadDef.Uncooked_Klingon._id + 1, false, false),
        Uncooked_Flat(false, BreadDef.Flat._name, BreadDef.Flat._like, BreadDef.Flat._id + 1, false);

        private final int _id;
        private final String _name;
        private final LikeFood _like;
        private final boolean _sandwich;
        private final boolean _cooked;
        private final boolean _achievement;

        private BreadDef(boolean cooked, String name, LikeFood like, int id, boolean sandwich, boolean achievement) {
            this._id = id;
            this._name = name;
            this._cooked = cooked;
            this._like = like;
            this._sandwich = cooked && sandwich;
            this._achievement = !cooked && achievement;
        }

        private BreadDef(boolean cooked, String name, LikeFood like, int id, boolean achievement) {
            this(cooked, name, like, id, false, achievement);
        }

        String unlocalizedName() {
            String p = this._cooked ? "" : "uncooked_";
            return this._name == null ? p + "bread" : p + this._name + "_bread";
        }

        int id() {
            return this._id;
        }

        boolean cooked() {
            return this._cooked;
        }

        boolean sandwichOk() {
            return this._sandwich;
        }

        LikeFood likeFood() {
            return this._like;
        }

        boolean getsAchievement() {
            return this._achievement;
        }
    }
}

