/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Fries
extends VfpPantryMultiItem {
    private static final int FRIES_BATCH = 4;
    private static boolean HARD_RECIPE = false;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Fries, Fries.class, "type");
    private static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "fries_potatoes_raw", LikeFood.uncooked_potato, VARIANT_SET, true), new VfpVariant(1, "fries_potatoes", LikeFood.fries, VARIANT_SET, false), new VfpVariant(2, "fries_carrots_raw", LikeFood.uncooked_carrot, VARIANT_SET, false), new VfpVariant(3, "fries_carrots", LikeFood.fries, VARIANT_SET, false), new VfpVariant(4, "fries_klingon_raw", LikeFood.uncooked_potato, VARIANT_SET, false), new VfpVariant(5, "fries_klingon", LikeFood.fries, VARIANT_SET, false), new VfpVariant(6, "fries_cassava_raw", LikeFood.uncooked_potato, VARIANT_SET, false), new VfpVariant(7, "fries_cassava", LikeFood.fries, VARIANT_SET, false)};
    private static Fries INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public Fries(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    static final synchronized Fries get() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Fries, Fries.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static final void addXFries(int meta_raw, int meta, Object source, Object seasoning, ItemStack vinegar, List<ItemStack> instances) {
        ItemStack prepped_fries = new ItemStack((Item)INSTANCE, 4, meta_raw);
        ItemStack cooked_fries = new ItemStack((Item)INSTANCE, 1, meta);
        if (HARD_RECIPE) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(prepped_fries, new Object[]{"ppk", seasoning == null ? "sv " : "svX", "Wh ", Character.valueOf('p'), source, Character.valueOf('k'), "itemFoodCutter", Character.valueOf('s'), "portionSaltSmall", Character.valueOf('v'), vinegar, Character.valueOf('X'), seasoning == null ? VfpObj.Eek_obj : seasoning, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall"}));
        } else if (seasoning == null) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(prepped_fries, new Object[]{source, source, "itemFoodCutter"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(prepped_fries, new Object[]{source, source, seasoning, "itemFoodCutter"}));
        }
        prepped_fries.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)prepped_fries, (ItemStack)cooked_fries, (float)(LikeFood.uncooked_potato.smeltExperience() / 2.0f));
        instances.add(prepped_fries);
        instances.add(cooked_fries);
        OreDictionary.registerOre((String)"foodFrenchFries", (ItemStack)cooked_fries);
        OreDictionary.registerOre((String)"foodFries", (ItemStack)cooked_fries);
    }

    static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null) {
            Fries.get();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(13);
            ItemStack vinegar = FoodPowders.get(FoodPowders.Type.VINEGAR, 1);
            HARD_RECIPE = config.harderFries();
            Fries.addXFries(0, 1, Items.field_151174_bG, null, vinegar, instances);
            Fries.addXFries(2, 3, Items.field_151172_bF, null, vinegar, instances);
            Fries.addXFries(4, 5, Items.field_151174_bG, FoodPowders.get(FoodPowders.Type.CACTUS, 1), vinegar, instances);
            if (config.includeModRecipes() && config.isPresent("cassava")) {
                Fries.addXFries(6, 7, config.getPresentAs("cassava"), HARD_RECIPE ? "portionSaltSmall" : null, vinegar, instances);
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static ItemStack plain(int amount) {
        ItemStack stack = null;
        if (TYPED_INSTANCES != null) {
            stack = new ItemStack((Item)INSTANCE, amount, 1);
        }
        return stack;
    }

    public static ItemStack klingon(int amount) {
        ItemStack stack = null;
        if (TYPED_INSTANCES != null) {
            stack = new ItemStack((Item)INSTANCE, amount, 5);
        }
        return stack;
    }
}

