/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBall;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;
import org.jwaresoftware.mcmods.vfp.wheat.Muffins;
import org.jwaresoftware.mcmods.vfp.wheat.PocketSandwiches;

public final class WheatExtrasBuildHelper
extends VfpBuildHelperSupport {
    private static final CreativeTabs MISC_TAB = CreativeTabs.field_78026_f;

    @Override
    protected String categoryName() {
        return "WheatExtras";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        DoughBallType.validState();
        VfpObj.Flour_Portion_obj = VfpBuilder.newPortion(VfpOid.Flour_Portion);
        VfpObj.Flour_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Flour_Pantry_Block, VfpObj.Flour_Portion_obj);
        VfpObj.Dough_Balls_obj = VfpBuilder.newMultiItem(VfpOid.Dough_Ball, DoughBall.class, VfpBuilder.User.INTERNAL);
        VfpObj.Dough_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Dough_Pantry_Block, VfpObj.Dough_Balls_obj);
        VfpObj.Breads_obj = Breads.get();
        VfpObj.Muffins_obj = Muffins.get();
        VfpObj.Fries_obj = Fries.get();
        VfpObj.Bread_Pockets_obj = PocketSandwiches.get();
        VfpObj.Sticky_Paste_obj = VfpBuilder.newAdditive(VfpOid.Sticky_Paste, MISC_TAB);
        VfpObj.Empty_Paper_Bag_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Paper_Bag, MISC_TAB).autoregister();
        VfpObj.Carton_Side_Blank_obj = new VfpPlainItem((VfpProfile)VfpOid.Carton_Side_Blank, MISC_TAB).autoregister();
        VfpObj.Empty_Carton_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Carton, MISC_TAB).autoregister();
        VfpObj.Empty_Jar_Carton_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Jar_Carton, MISC_TAB).autoregister();
        OreDictionary.registerOre((String)"itemPaper", (Item)Items.field_151121_aF);
        OreDictionary.registerOre((String)"itemPackagingBox", (Item)VfpObj.Empty_Carton_obj);
        OreDictionary.registerOre((String)"foodDough", (ItemStack)DoughBallType.plain(1));
        OreDictionary.registerOre((String)"foodBreadFried", (ItemStack)DoughBallType.cookedPlain(1));
        OreDictionary.registerOre((String)"foodBreadFried", (ItemStack)DoughBallType.cookedSweet(1));
        OreDictionary.registerOre((String)"blockFlour", (Block)VfpObj.Flour_Pantry_Block_obj);
        this.earlyInitLikeBreadFoods(runtime.getConfig());
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.alwaysIncludeSimpleFlourRecipe()) {
            config.builderContext().put("simpleFlourRecipe", true);
        } else {
            List<String> mappings = config.capturedContextOres();
            if (!mappings.contains("foodFlour")) {
                if (mappings.contains("foodFlourWheat")) {
                    List flours = OreDictionary.getOres((String)"foodFlourWheat");
                    for (ItemStack flour : flours) {
                        if (flour.func_77948_v()) continue;
                        if (config.isDebugMode()) {
                            FMLLog.finer((String)"using pre-existing '%s' registration as 'foodFlour' default", (Object[])new Object[]{flour.func_77977_a()});
                        }
                        OreDictionary.registerOre((String)"foodFlour", (ItemStack)flour);
                        break;
                    }
                }
                if (!VfpUtils.ingredientDefined("foodFlour")) {
                    config.builderContext().put("simpleFlourRecipe", true);
                }
            }
        }
        OreDictionary.registerOre((String)"foodFlour", (Item)VfpObj.Flour_Portion_obj);
    }

    private void earlyInitLikeBreadFoods(VfpConfig config) {
        LikeFood.mini_bread.food().item(DoughBallType.cookedPlain(1));
        LikeFood.sandwich.food().item(DoughBallType.cookedPlain(1));
        LikeFood.enriched_bread.food().item(Breads.french(1));
        LikeFood.specialty_bread.food().item(Breads.enriched(1));
        LikeFood.bread_pocket.food().item(VfpObj.Flat_Bread_Pocket_obj);
        LikeFood.muffin.food().item(Muffins.pumpkin(1));
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.builderContext().containsKey("simpleFlourRecipe")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Flour_Portion_obj, 1), (Object[])new Object[]{Items.field_151015_O});
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Flour_Portion_obj, 2), new Object[]{Items.field_151015_O, Items.field_151015_O, "additiveDrying"}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Flour_Portion_obj, VfpObj.Flour_Pantry_Block_obj, VfpObj.Flour_Portion_obj);
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(DoughBallType.plain(1), new Object[]{"foodFlour", "foodFlour", "additiveLeavening", "portionWaterSmall"}), LikeFood.mini_bread.craftExperience()));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(DoughBallType.sweet(1), new Object[]{"foodDough", "ingredientSweetener"}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)DoughBallType.plain(1), new ItemStack(VfpObj.Dough_Pantry_Block_obj), DoughBallType.plain(1));
        GameRegistry.addSmelting((ItemStack)DoughBallType.plain(1), (ItemStack)DoughBallType.cookedPlain(2), (float)LikeFood.mini_bread.smeltExperience());
        GameRegistry.addSmelting((ItemStack)DoughBallType.sweet(1), (ItemStack)DoughBallType.cookedSweet(2), (float)LikeFood.mini_bread.smeltExperience());
        Breads.autorecipe(config);
        Muffins.autorecipe(config);
        PocketSandwiches.autorecipe(config);
        Fries.autorecipe(config);
        this.buildPackagingRecipes(config);
    }

    private void buildPackagingRecipes(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 8), new Object[]{"foodFlour", "portionWaterSmall"}));
        Object[] ingredients = new Object[9];
        for (int i = 0; i < 8; ++i) {
            ingredients[i] = "foodFlour";
        }
        ingredients[8] = "portionWater";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, VfpCapacity.MAX_STACK.count()), ingredients));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, VfpCapacity.MAX_STACK.count()), new Object[]{"blockFlour", "portionWater"}));
        if (VfpUtils.ingredientDefined("portionAdhesive")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 16), new Object[]{"portionAdhesive", "portionWater"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 16), new Object[]{"slimeball", "portionWater"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Paper_Bag_obj), new Object[]{"...", "PgP", ".P.", Character.valueOf('P'), "itemPaper", Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Carton_Side_Blank_obj), new Object[]{"PPP", "ggg", "PPP", Character.valueOf('P'), "itemPaper", Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Carton_obj), new Object[]{"PPP", "ggg", "PPP", Character.valueOf('P'), VfpObj.Carton_Side_Blank_obj, Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Jar_Carton_obj), new Object[]{"jjj", "jcj", "jjj", Character.valueOf('j'), VfpObj.Empty_Jar_obj, Character.valueOf('c'), VfpObj.Empty_Carton_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Empty_Jar_obj, 8), new Object[]{VfpObj.Empty_Jar_Carton_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151122_aG), new Object[]{"c  ", "ppp", "c  ", Character.valueOf('c'), VfpObj.Carton_Side_Blank_obj, Character.valueOf('p'), "itemPaper"}));
    }

    @Override
    public void doAddChestGenLoot(VfpRuntime runtime) {
        int _UNCOMMON = MinecraftGlue.UNCOMMON_WEIGHT();
        ChestGenHooks place = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
        place.addItem(new WeightedRandomChestContent(Muffins.cocoa(1), 1, 3, _UNCOMMON));
        place = ChestGenHooks.getInfo((String)"strongholdLibrary");
        place.addItem(new WeightedRandomChestContent(Muffins.carrot(1), 1, 3, _UNCOMMON));
        place = ChestGenHooks.getInfo((String)"netherFortress");
        place.addItem(new WeightedRandomChestContent(Muffins.pumpkin(1), 1, 3, _UNCOMMON));
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(DoughBallType.plain(1), VfpAchievements.Id.MakingDough);
        for (ItemStack bread : Breads.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(bread, VfpAchievements.Id.BakerPrime);
        }
        for (ItemStack muffin : Muffins.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(muffin, VfpAchievements.Id.NeverMuffed);
        }
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (!runtime.hasUI()) {
            return;
        }
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flour_Portion, VfpObj.Flour_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flour_Pantry_Block, VfpObj.Flour_Pantry_Block_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dough_Ball, VfpObj.Dough_Balls_obj, DoughBallType.get());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dough_Pantry_Block, VfpObj.Dough_Pantry_Block_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Breads, VfpObj.Breads_obj, Breads.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flat_Bread_Pocket, VfpObj.Flat_Bread_Pocket_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Muffins, VfpObj.Muffins_obj, Muffins.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bread_Pocket, VfpObj.Bread_Pockets_obj, PocketSandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fries, VfpObj.Fries_obj, Fries.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sticky_Paste, VfpObj.Sticky_Paste_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Paper_Bag, VfpObj.Empty_Paper_Bag_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Carton_Side_Blank, VfpObj.Carton_Side_Blank_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Carton, VfpObj.Empty_Carton_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Jar_Carton, VfpObj.Empty_Jar_Carton_obj);
    }
}

