/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp;

import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

@Mod(modid="vanillafoodpantry", name="Vanilla Food Pantry", version="1.0", acceptedMinecraftVersions="[1.8]")
public final class VanillaFoodPantry {
    @Mod.Instance(value="vanillafoodpantry")
    public static VanillaFoodPantry instance;
    @SidedProxy(clientSide="org.jwaresoftware.mcmods.vfp.core.VfpRuntimeSP", serverSide="org.jwaresoftware.mcmods.vfp.core.VfpRuntimeDS")
    public static VfpRuntime runtime;
    public static final boolean DESPERATION_DEBUG;
    private VfpBuilder _vfpBuilder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        runtime.startUp(event);
        this._vfpBuilder = new VfpBuilder(runtime);
        this._vfpBuilder.doBuildEventBusHandlers((FMLStateEvent)event, runtime);
        VfpConfig config = runtime.getConfig();
        config.captureContextOres();
        if (config.isDebugMode()) {
            runtime.getLog().info("Mappings against which VFP to base PRIMARY adjustments: {}", new Object[]{config.capturedContextOres()});
        }
        this._vfpBuilder.doBuildPrimaryObjects((FMLStateEvent)event, runtime);
        config.persist();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VfpConfig config = runtime.getConfig();
        config.captureContextOres();
        if (config.isDebugMode()) {
            runtime.getLog().info("Mappings against which VFP to base SECONDARY adjustments: {}", new Object[]{config.capturedContextOres()});
        }
        this._vfpBuilder.doBuildSecondaryObjects((FMLStateEvent)event, runtime);
        config.captureContextOres();
        this._vfpBuilder.doBuildRecipes((FMLStateEvent)event, runtime);
        this.updatesCheck();
        this._vfpBuilder.doSendApiMessages((FMLStateEvent)event, runtime);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this._vfpBuilder.doBuildAchievementList((FMLStateEvent)event, runtime);
        this._vfpBuilder.doFinish((FMLStateEvent)event, runtime);
        runtime.getConfig().persist();
    }

    @Mod.EventHandler
    public void stop(FMLServerStoppingEvent event) {
        runtime.shutDown(event);
    }

    private final void updatesCheck() {
        if (runtime.isEnabled("vc").booleanValue()) {
            FMLInterModComms.sendRuntimeMessage((Object)"vanillafoodpantry", (String)"VersionChecker", (String)"addVersionCheck", (String)"http://jwaresoftware.org/files/mcmods/versionchecker/vanillafoodpantry.json");
        }
    }

    static {
        DESPERATION_DEBUG = Boolean.getBoolean("VanillaFoodPantry.finedebug.enabled");
    }
}

