/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.MapColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;

public final class FoodPowders
extends VfpPantryMultiItem
implements FoodColor {
    static final int MAX_POWDERS_PER_USAGE = 100;
    public static final int _NONE = 0;
    public static final int _DRINK = 1;
    public static final int _BREAD = 16;
    public static final int _COOKIE = 256;
    public static final int _SOUP = 4096;
    public static final int _COLOR = 65536;
    public static final int _SEASON = 0x100000;
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static FoodPowders INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final int[] getReservedIngredientIdRange() {
        return new int[]{Usage.DRINK_FLAVOR.idFirst(), Usage.OTHER.idLast()};
    }

    public FoodPowders(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    public int color(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        Integer color = variant.datadata(Type.class).colorValue();
        return color != null ? color : 0xF1F1F1;
    }

    static final synchronized FoodPowders get(VfpConfig config) {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(50);
            String basename = VARIANT_SET.typeName();
            List<Type> typeDefs = Type.orderedValues();
            for (Type type : typeDefs) {
                String fmlid = basename + "_" + type.name().toLowerCase();
                variants.add(new VfpTransientVariant(type.meta(), fmlid, null, type, (CreativeTabs)null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.FoodPowder, FoodPowders.class, VfpBuilder.User.INTERNAL);
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(71);
            for (Type type : typeDefs) {
                ItemStack a_powder = new ItemStack((Item)INSTANCE, 1, type.meta());
                if (type.isColorer()) {
                    OreDictionary.registerOre((String)"powderFoodColor", (ItemStack)a_powder);
                }
                if (type.isDrinkFlavor()) {
                    OreDictionary.registerOre((String)"powderDrinkFlavor", (ItemStack)a_powder);
                }
                if (type.substitutionFor() != null) {
                    OreDictionary.registerOre((String)type.substitutionFor(), (ItemStack)a_powder);
                }
                instances.add(a_powder);
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
        return INSTANCE;
    }

    private static final void autorecipeGelatin(VfpConfig config) {
        int meta = Type.GELATIN.meta();
        ItemStack gel_powder = new ItemStack((Item)INSTANCE, Type.GELATIN.item().recipeitem().field_77994_a, meta);
        Item[] ingredients = new Item[]{Items.field_151103_aS, Items.field_151123_aH, Items.field_179555_bs};
        for (int i = 0; i < ingredients.length; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gel_powder, new Object[]{"I  ", "whd", "   ", Character.valueOf('I'), ingredients[i], Character.valueOf('w'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('d'), "additiveDrying"}));
        }
        VfpRewards.addRewardingCraftItem(gel_powder, LikeFood.bone.craftExperience());
        if (config.enableBoneSmelting()) {
            GameRegistry.addSmelting((Item)Items.field_151103_aS, (ItemStack)new ItemStack((Item)INSTANCE, gel_powder.field_77994_a, meta), (float)LikeFood.bone.smeltExperience());
        }
    }

    private static final void autorecipeSeasonings(VfpConfig config) {
        ItemStack pepper = null;
        Type type = FoodPowders.findType("peppercorn");
        if (type != null) {
            pepper = FoodPowders.get(type, 1);
        }
        ArrayList<String> ingredients = new ArrayList<String>();
        ingredients.add("foodFlour");
        if (pepper != null) {
            ingredients.add((String)pepper);
        }
        ingredients.add("ingredientSalt");
        ingredients.add((String)VfpObj.Baking_Soda_obj);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(FoodPowders.get(Type.BATTER_MIX, 3), ingredients.toArray()));
        ingredients.clear();
        if (pepper != null) {
            ingredients.add((String)pepper);
        }
        ingredients.add("ingredientSalt");
        ingredients.add((String)Items.field_151102_aT);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(FoodPowders.get(Type.JERKY_RUB, 6), ingredients.toArray()));
        ingredients.clear();
        type = FoodPowders.findType("stew_mix");
        if (type != null && pepper != null && type.isSeasoningFlavor()) {
            String thyme = config.getPresentAs("thyme");
            ingredients.add("ingredientSalt");
            ingredients.add((String)pepper);
            ingredients.add((String)FoodPowders.get(Type.CARROT, 1));
            ingredients.add(config.getPresentAs("celery"));
            ingredients.add((String)FoodPowders.get(FoodPowders.findType("onion"), 1));
            if (thyme != null) {
                ingredients.add(thyme);
            }
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(FoodPowders.get(type, 6), ingredients.toArray()));
        }
    }

    private static final void autorecipeCompounds(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)INSTANCE, 1, Type.CREAM.meta()), new Object[]{new ItemStack((Item)INSTANCE, 1, Type.MILK.meta()), new ItemStack((Item)INSTANCE, 1, Type.MILK.meta())}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 1, Type.FEATHER.meta()), new Object[]{"fff", "fff", "vvd", Character.valueOf('f'), Items.field_151008_G, Character.valueOf('v'), Blocks.field_150395_bd, Character.valueOf('d'), "additiveDrying"}));
        ItemStack muscle_powder = new ItemStack((Item)INSTANCE, 1, Type.MUSCLE.meta());
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(muscle_powder, new Object[]{new ItemStack((Item)INSTANCE, 1, Type.CACTUS.meta()), new ItemStack((Item)INSTANCE, 1, Type.ROSE.meta()), Items.field_151110_aK, VfpObj.Ink_Sac_obj, "additiveDrying"}), OneXp.Per08.value()));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(muscle_powder, new Object[]{new ItemStack((Item)INSTANCE, 1, Type.CACTUS.meta()), new ItemStack((Item)INSTANCE, 1, Type.ROSE.meta()), new ItemStack((Item)INSTANCE, 1, Type.INK.meta()), new ItemStack((Item)INSTANCE, 1, Type.EGG.meta())}));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 3, Type.BUSHTEA.meta()), new Object[]{"iii", "iii", "whd", Character.valueOf('i'), "foodBush", Character.valueOf('w'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 3, Type.DANDTEA.meta()), new Object[]{"iii", "iii", "whd", Character.valueOf('i'), new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), Character.valueOf('w'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
    }

    static final synchronized void autorecipe(VfpConfig config) {
        boolean debug = config.isDebugMode();
        for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
            Object powder_source;
            Type type = VARIANT_ARRAY[i].datadata(Type.class);
            if (type.isCompound() || !type.item().isEnabled()) continue;
            ItemStack typedef = type.item().recipeitem();
            Object[] powder_ingredients = new Object[1 + type.item().multiplier()];
            powder_ingredients[0] = "additiveDrying";
            if (type.item().isClassifier()) {
                String ingredientname = type.item().recipeitemName();
                if (!VfpUtils.ingredientDefined(ingredientname)) {
                    if (!debug) continue;
                    FMLLog.fine((String)"Skipping powder %s made of %s (not present in game)", (Object[])new Object[]{type.name(), ingredientname});
                    continue;
                }
                powder_source = ingredientname;
            } else {
                powder_source = typedef.func_77946_l();
                powder_source.field_77994_a = 1;
            }
            for (int j = 1; j < powder_ingredients.length; ++j) {
                powder_ingredients[j] = powder_source;
            }
            ItemStack powder_portions = new ItemStack((Item)INSTANCE, typedef.field_77994_a, type.meta());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(powder_portions, powder_ingredients));
        }
        FoodPowders.autorecipeGelatin(config);
        FoodPowders.autorecipeCompounds(config);
        FoodPowders.autorecipeSeasonings(config);
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    private static final ItemStack _copy(Type powder, int amount) {
        ItemStack item = TYPED_INSTANCES[powder.ordinal()];
        item = new ItemStack(item.func_77973_b(), amount, item.func_77960_j());
        return item;
    }

    public static final Ingredient toIngredient(Type powder, int amount, Usage usage, String preferredName) {
        Ingredient ingredient = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            if (usage == null) {
                usage = Usage.OTHER;
            }
            if (preferredName == null) {
                preferredName = powder.name();
            }
            boolean metaCheck = powder.meta() >= 0 && powder.meta() < 100;
            Validate.validState((boolean)metaCheck, (String)"A food powder's meta value MUST be between 0 and %d exclusive", (Object[])new Object[]{100});
            ingredient = new Ingredient(preferredName, usage.idLast() - powder.meta(), FoodPowders._copy(powder, amount));
        }
        return ingredient;
    }

    public static final Ingredient toIngredient(Type powder, Usage usage, String preferredName) {
        return FoodPowders.toIngredient(powder, 1, usage, preferredName);
    }

    public static final Ingredient toIngredient(Type powder, int id, String preferredName) {
        Ingredient ingredient = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            if (preferredName == null) {
                preferredName = powder.name();
            }
            ingredient = new Ingredient(preferredName, id, TYPED_INSTANCES[powder.ordinal()].func_77946_l());
        }
        return ingredient;
    }

    public static final ItemStack get(Type powder, int amount) {
        ItemStack item = null;
        if (powder != null && VARIANT_SET.lookup(powder.meta()) != null) {
            item = FoodPowders._copy(powder, amount);
        }
        return item;
    }

    public static final Type findType(String name) {
        return Type._VALUES.get(name.toUpperCase());
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.FoodPowder, (Class)FoodPowders.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }

    public static final class Type
    implements Comparable<Type> {
        static int _NEXT_ORDINAL = 0;
        static final Map<String, Type> _VALUES = new HashMap<String, Type>();
        public static final Type SYRUP = new Type("SYRUP", new Ingredient("unused", 0, new ItemStack(VfpObj.Sugar_obj), 2), 1, null, false, (Integer)171775);
        public static final Type COCOA = new Type("COCOA", new Ingredient("unused", 0, VfpObj.Cocoa_Seed_obj, 2), 65793, null, false, (Integer)8931339);
        public static final Type APPLE = new Type("APPLE", new Ingredient("unused", 0, new ItemStack(Items.field_151034_e), 2), 273, null, false, (Integer)16774112);
        public static final Type PUMPKIN = new Type("PUMPKIN", new ItemStack(Blocks.field_150423_aK, 8), 4368, 16768161);
        public static final Type MELON = new Type("MELON", new ItemStack(Blocks.field_150440_ba, 4), 1, MapColor.field_151671_v);
        public static final Type CARROT = new Type("CARROT", new ItemStack(Items.field_151172_bF, 2), 69649, 16748827);
        public static final Type DANDELION = new Type("DANDELION", new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), 65537, 16574754);
        public static final Type CACTUS = new Type("CACTUS", new ItemStack((Block)Blocks.field_150434_aF, 4), 69889, MapColor.field_151672_u);
        public static final Type POPPY = new Type("POPPY", new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), 65537, 0xFF0000);
        public static final Type MILK = new Type("MILK", new Ingredient("milk", 0, "portionMilkLarge", 4, 1), 1, "ingredientMilk", false, (Integer)0xFFFFDD);
        public static final Type POTATO = new Type("POTATO", new ItemStack(Items.field_151174_bG, 2), 4112, 16775636);
        public static final Type EGG = new Type("EGG", new ItemStack(Items.field_151110_aK), 16, "ingredientEgg", 0xFFFF8C);
        public static final Type INK = new Type("INK", VfpObj.Ink_Sac_obj, 65537, "ingredientInk", MapColor.field_151646_E.field_76291_p);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Ingredient("unused", 0, "foodMushroom"), 4096, "ingredientMushroom", false, (Integer)11306333);
        public static final Type ROSE = new Type("ROSE", new Ingredient("unused", 0, "foodRoseFlower"), 65536, "ingredientRoseFlower", false, (Integer)MapColor.field_151645_D.field_76291_p);
        public static final Type GELATIN = new Type("GELATIN", new ItemStack(Items.field_151103_aS, 2), 0, true);
        public static final Type CHEESE = new Type("CHEESE", new Ingredient("unused", 0, "foodCheese"), 4112, "ingredientCheese", false, (Integer)16772518);
        public static final Type FEATHER = new Type("FEATHER", new ItemStack(Items.field_151008_G), 0, true);
        public static final Type MUSCLE = new Type("MUSCLE", new Ingredient("unused", 0, "unused"), 0, "powderBoost", true, (Integer)3419182);
        public static final Type BUSHTEA = new Type("BUSHTEA", new Ingredient("unused", 0, "unused"), 0, "ingredientBushTea", true, (Integer)6585650);
        public static final Type DANDTEA = new Type("DANDTEA", new Ingredient("unused", 0, "unused"), 0, "ingredientBushTea", true, (Integer)13873231);
        public static final Type CREAM = new Type("CREAM", new Ingredient("unused", 0, "unused"), 0, "ingredientCream", true, (Integer)15128708);
        public static final Type VINEGAR = new Type("VINEGAR", new Ingredient("unused", 0, "unused"), 0, "ingredientVinegar", true, null);
        public static final Type FILLER = new Type("CLEAR", new Ingredient("unused", 0, "unused", 0, 1), 0, null, true, null);
        public static final Type BATTER_MIX = new Type("BATTER_MIX", new Ingredient("unused", 0, "unused", 0, 1), 0x100000, null, true, null);
        public static final Type JERKY_RUB = new Type("JERKY_MIX", new Ingredient("unused", 0, "unused", 0, 1), 0x100000, null, true, null);
        public static final Type POTATO_STARCH = new Type("POTATO_STARCH", new Ingredient("unused", 0, "unused"), 0, "ingredientStarch", true, null);
        public static final Type BEET = new Type("BEET", new Ingredient("unused", 0, "foodBeets"), 69632, "ingredientBeet", false, (Integer)12612474);
        public static final Type PICKLING = new Type("PICKLING", new Ingredient("unused", 0, "unused", 0, 1), 0x100000, null, true, null);
        private final String _name;
        private final int _ordinal;
        private final int _meta;
        private final Ingredient _item;
        private final int _uses;
        private final Integer _colorValue;
        private final String _substituteFor;
        private final boolean _compound;

        public static final Collection<Type> values() {
            return Collections.unmodifiableCollection(_VALUES.values());
        }

        Type(int id, String name, Ingredient item, int uses, String subsFor, boolean xrecipeFlag, Integer colorValue) {
            this._name = name = name.toUpperCase();
            this._ordinal = _NEXT_ORDINAL++;
            this._meta = id < 0 ? this._ordinal : id;
            this._item = item;
            this._uses = uses;
            this._substituteFor = subsFor;
            this._colorValue = colorValue;
            this._compound = xrecipeFlag;
            _VALUES.put(name, this);
        }

        Type(String name, Ingredient item, int uses, String subsFor, boolean xrecipeFlag, Integer colorValue) {
            this(-1, name, item, uses, subsFor, xrecipeFlag, colorValue);
        }

        Type(String name, ItemStack item, int uses, String subsFor, Integer colorValue) {
            this(-1, name, new Ingredient("unused", 0, item), uses, subsFor, false, colorValue);
        }

        Type(String name, ItemStack item, int uses, Integer colorValue) {
            this(-1, name, new Ingredient("unused", 0, item), uses, null, false, colorValue);
        }

        Type(String name, ItemStack item, int uses, MapColor color) {
            this(name, item, uses, null, color.field_76291_p);
        }

        Type(String name, ItemStack item, int uses, String subsFor) {
            this(name, item, uses, subsFor, null);
        }

        Type(String name, ItemStack item, int uses, boolean xrecipeFlag) {
            this(-1, name, new Ingredient("unused", 0, item), uses, null, xrecipeFlag, (Integer)null);
        }

        public Type(int id, String name, ItemStack item, int uses, String subsFor, Integer colorValue) {
            this(id, name, new Ingredient("unused", 0, item), uses, subsFor, false, colorValue);
        }

        public Type(int id, String name, ItemStack item, int uses, int multiplier, String subsFor, Integer colorValue) {
            this(id, name, new Ingredient("unused", 0, item, multiplier), uses, subsFor, false, colorValue);
        }

        public Type(int id, String name, ItemStack item, int uses, String subsFor, boolean xrecipeFlag) {
            this(id, name, new Ingredient("unused", 0, item), uses, subsFor, xrecipeFlag, null);
        }

        public final String name() {
            return this._name;
        }

        public final int ordinal() {
            return this._ordinal;
        }

        public final int meta() {
            return this._meta;
        }

        Ingredient item() {
            return this._item;
        }

        public boolean isBreadFlavor() {
            return (this._uses & 0x10) == 16;
        }

        public boolean isDrinkFlavor() {
            return (this._uses & 1) == 1;
        }

        public boolean isSoupFlavor() {
            return (this._uses & 0x1000) == 4096;
        }

        public boolean isCookieFlavor() {
            return (this._uses & 0x100) == 256;
        }

        public boolean isSeasoningFlavor() {
            return (this._uses & 0x100000) == 0x100000;
        }

        public boolean isColorer() {
            return this._colorValue != null && (this._uses & 0x10000) == 65536;
        }

        public Integer colorValue() {
            return this._colorValue;
        }

        public String substitutionFor() {
            return this._substituteFor;
        }

        public boolean isCompound() {
            return this._compound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.name()).append("|").append(this.meta()).append("|").append(this._uses).append("|").append(this.colorValue());
            return sb.toString();
        }

        public boolean equals(Object o) {
            return o == null ? false : (o instanceof Type ? ((Type)o)._meta == this._meta : false);
        }

        public int hashCode() {
            return this._meta + this._name.hashCode();
        }

        @Override
        public int compareTo(Type o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            return this._ordinal > o._ordinal ? 1 : (this._ordinal < o._ordinal ? -1 : 0);
        }

        public static final List<Type> orderedValues() {
            ArrayList<Type> list = new ArrayList<Type>(_VALUES.values());
            Collections.sort(list);
            return list;
        }

        static final void checkReservedPowderCount() {
            Validate.validState((_NEXT_ORDINAL < 40 ? 1 : 0) != 0, (String)"At most %d builtin food powders are expected (currently at %d)", (Object[])new Object[]{40, _NEXT_ORDINAL});
        }

        public static int reservedPowderCount() {
            return 40;
        }
    }

    public static enum Usage {
        DRINK_FLAVOR(240),
        BREAD_FLAVOR(DRINK_FLAVOR.idLast() + 100),
        COOKIE_FLAVOR(BREAD_FLAVOR.idLast() + 100),
        SOUP_FLAVOR(COOKIE_FLAVOR.idLast() + 100),
        COLORING(SOUP_FLAVOR.idLast() + 100),
        SEASONING_FLAVOR(COLORING.idLast() + 100),
        OTHER(SEASONING_FLAVOR.idLast() + 100);

        private final int _offset;

        private Usage(int offset) {
            this._offset = offset;
        }

        public int idLast() {
            return this._offset;
        }

        public int idFirst() {
            return this._offset - 100 + 1;
        }
    }
}

