/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

final class RennetBuildHelper
extends VfpBuildHelperSupport {
    RennetBuildHelper() {
    }

    @Override
    protected String categoryName() {
        return "Rennet";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.getConfig().includeCalfDrops()) {
            MinecraftForge.EVENT_BUS.register((Object)ForgeDropEventHandler.instance);
        }
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Calf_Stomach_obj = VfpBuilder.newMisc(VfpOid.Calf_Stomach);
        VfpObj.Enzyme_Extract_Agent_obj = VfpBuilder.newAdditive(VfpOid.Enzyme_Extractor_Agent);
        VfpObj.Curdling_Agent_obj = VfpBuilder.newAdditive(VfpOid.Rennet);
        OreDictionary.registerOre((String)"additiveMilkCurdle", (Item)VfpObj.Curdling_Agent_obj);
    }

    @Override
    public void doBuildRecipes(FMLStateEvent event, VfpRuntime runtime) {
        int additive_count = VfpCapacity.ADDITIVE_BATCH.count();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Curdling_Agent_obj, additive_count * 2), new Object[]{"i  ", "Whd", "   ", Character.valueOf('i'), VfpObj.Calf_Stomach_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('d'), "additiveDrying"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Enzyme_Extract_Agent_obj, additive_count), new Object[]{"xxx", "iii", "fw ", Character.valueOf('x'), "additiveScaffold", Character.valueOf('i'), Items.field_151075_bm, Character.valueOf('f'), FoodPowders.get(FoodPowders.Type.FEATHER, 1), Character.valueOf('w'), "portionWaterSmall"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Curdling_Agent_obj, additive_count * 2), new Object[]{"iii", "iii", "eWd", Character.valueOf('i'), "treeSapling", Character.valueOf('e'), VfpObj.Enzyme_Extract_Agent_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('d'), "additiveDrying"}));
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(VfpObj.Enzyme_Extract_Agent_obj, VfpAchievements.Id.PantryBegun);
        VfpRewards.addRewardingCraftItem(VfpObj.Curdling_Agent_obj, VfpAchievements.Id.PantryBegun);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Calf_Stomach, VfpObj.Calf_Stomach_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rennet, VfpObj.Curdling_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Enzyme_Extractor_Agent, VfpObj.Enzyme_Extract_Agent_obj);
        }
    }

    static final class ForgeDropEventHandler {
        static final ForgeDropEventHandler instance = new ForgeDropEventHandler();

        ForgeDropEventHandler() {
        }

        @SubscribeEvent
        public void onLivingDrops(LivingDropsEvent event) {
            EntityCow moo;
            if (VfpObj.Calf_Stomach_obj == null) {
                return;
            }
            Entity entity = event.entity;
            World world = entity.field_70170_p;
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobLoot") && !entity.func_70027_ad() && entity instanceof EntityCow && (moo = (EntityCow)entity).func_70631_g_()) {
                entity.func_145779_a(VfpObj.Calf_Stomach_obj, 1);
                if (VfpObj.Small_Bone_obj != null) {
                    entity.func_145779_a(VfpObj.Small_Bone_obj, 1);
                }
            }
        }
    }
}

