/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.agents.RockSaltOreWorldGenerator;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpOreBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

final class SaltBuildHelper
extends VfpBuildHelperSupport {
    SaltBuildHelper() {
    }

    @Override
    protected String categoryName() {
        return "Salt";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.isOreGenerationEnabled()) {
            RockSaltOreWorldGenerator wg = RockSaltOreWorldGenerator.create(config);
            GameRegistry.registerWorldGenerator((IWorldGenerator)wg, (int)wg.importance());
        }
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.RockSalt_Crystals_obj = VfpBuilder.newItem(VfpOid.Rock_Salt_Crystals);
        VfpObj.RockSalt_Ingot_obj = VfpBuilder.newItem(VfpOid.Rock_Salt_Ingot);
        VfpObj.RockSalt_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Rock_Salt_Ore, Blocks.field_150348_b, new ItemStack(VfpObj.RockSalt_Crystals_obj, 3), 2).autoregister();
        OreDictionary.registerOre((String)"oreRockSalt", (Block)VfpObj.RockSalt_OreBlock_obj);
        VfpObj.Nether_RockSalt_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Rock_Salt_Ore_Nether, Blocks.field_150424_aL, new ItemStack(VfpObj.RockSalt_Crystals_obj, 4), 3).autoregister();
        OreDictionary.registerOre((String)"oreRockSalt", (Block)VfpObj.Nether_RockSalt_OreBlock_obj);
        VfpObj.Salt_obj = VfpBuilder.newAdditive(VfpOid.Salt);
        VfpObj.Portion_Salt_obj = VfpBuilder.newAdditive(VfpOid.Portion_Salt);
        VfpObj.Salt_Pantry_Block_obj = new VfpPantryBlock((VfpProfile)VfpOid.Salt_Pantry_Block, (Block)Blocks.field_150354_m, VfpObj.Salt_obj).autoregister();
        OreDictionary.registerOre((String)"ingredientSalt", (Item)VfpObj.Salt_obj);
        OreDictionary.registerOre((String)"portionSalt", (Item)VfpObj.Salt_obj);
        OreDictionary.registerOre((String)"portionSaltSmall", (Item)VfpObj.Portion_Salt_obj);
    }

    @Override
    public void doBuildRecipes(FMLStateEvent event, VfpRuntime runtime) {
        VfpBuilder.autorecipe("Salt", VfpCapacity.PORTABLE, (Object)VfpObj.RockSalt_Crystals_obj, VfpObj.RockSalt_Ingot_obj, VfpObj.RockSalt_Crystals_obj);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Salt_obj, VfpCapacity.CRYSTAL_BATCH.count()), (Object[])new Object[]{VfpObj.RockSalt_Crystals_obj});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Portion_Salt_obj, VfpCapacity.PINCHES_BATCH.count()), (Object[])new Object[]{VfpObj.Salt_obj});
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Salt_obj, VfpObj.Salt_Pantry_Block_obj, VfpObj.Salt_obj);
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(VfpObj.Portion_Salt_obj, VfpAchievements.Id.PortionInTime);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Crystals, VfpObj.RockSalt_Crystals_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ingot, VfpObj.RockSalt_Ingot_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ore, VfpObj.RockSalt_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ore_Nether, VfpObj.Nether_RockSalt_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Salt, VfpObj.Salt_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Salt, VfpObj.Portion_Salt_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Salt_Pantry_Block, VfpObj.Salt_Pantry_Block_obj);
        }
    }
}

