/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public final class MinecraftGlue {
    public static final int MAX_ARRAY_SIZE_OF_PERSISTABLE_INDEX_META() {
        return 16;
    }

    public static final boolean validForBlockmeta(int size) {
        return size >= 0 && size <= MinecraftGlue.MAX_ARRAY_SIZE_OF_PERSISTABLE_INDEX_META();
    }

    public static final int PLAYER_CRAFT_GRID_SIZE() {
        return 4;
    }

    public static final int TABLE_CRAFT_GRID_SIZE() {
        return 9;
    }

    public static final int MAX_STACK_SIZE() {
        return 64;
    }

    public static final int CHUNK_DIM() {
        return 16;
    }

    public static final float LIGHT_TO_LEVEL_MULTIPLIER() {
        return 0.06666667f;
    }

    public static final float HARDNESS_TO_RESISTENCE_MULTIPLIER() {
        return 5.0f;
    }

    public static final float RESISTENCE_TO_RESISTENCE_SETTER_MULTIPLIER() {
        return 0.33333334f;
    }

    public static final float BLAST_RESISTENCE_TO_RESISTENCE_MULTIPLIER() {
        return MinecraftGlue.HARDNESS_TO_RESISTENCE_MULTIPLIER();
    }

    public static final String I18N_ITEM_KEY_PREFIX() {
        return "item.";
    }

    public static final String I18N_BLOCK_KEY_PREFIX() {
        return "tile.";
    }

    public static final int FREE_MOBILITY() {
        return 0;
    }

    public static final int NO_PUSH_MOBILITY() {
        return 1;
    }

    public static final int JUNK_WEIGHT() {
        return 10;
    }

    public static final int UNCOMMON_WEIGHT() {
        return 3;
    }

    public static final int TREASURE_WEIGHT() {
        return 1;
    }

    public static final int PLAIN_HORSE_TYPE() {
        return 0;
    }

    public static final String AWKWARD_POTION_EFFECT_ENCODING() {
        return "+4";
    }

    public static final boolean isLivingHorseOrMuleOrDonkey(EntityHorse e) {
        boolean is = false;
        if (e != null) {
            int type = e.func_110265_bP();
            is = type == 0 || type == 1 || type == 2;
        }
        return is;
    }

    public static ItemFood setMilkBasedRegenEffect(ItemFood item) {
        return item.func_77844_a(Potion.field_76428_l.field_76415_H, 15, 2, 1.0f);
    }

    public static void cureBadPotionEffectsWithMilk(EntityPlayer player, boolean muscle_boosted) {
        if (player != null) {
            player.func_82170_o(Potion.field_76433_i.field_76415_H);
            player.func_82170_o(Potion.field_76440_q.field_76415_H);
            player.func_82170_o(Potion.field_76431_k.field_76415_H);
            player.func_82170_o(Potion.field_76436_u.field_76415_H);
            player.func_82170_o(Potion.field_76438_s.field_76415_H);
            if (muscle_boosted) {
                MinecraftGlue.cureBadPotionEffectsWithMuscle(player);
            }
        }
    }

    public static void cureBadPotionEffectsWithMuscle(EntityPlayer player) {
        if (player != null) {
            player.func_82170_o(Potion.field_76437_t.field_76415_H);
            player.func_82170_o(Potion.field_76421_d.field_76415_H);
            player.func_82170_o(Potion.field_76419_f.field_76415_H);
        }
    }

    public static void giveGoodPotionEffectWithMuscle(EntityPlayer player, int boost_mins) {
        if (player != null) {
            if (boost_mins <= 0) {
                boost_mins = 2;
            }
            int duration = 60 * boost_mins * 20;
            player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, duration, 1, false, false));
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, duration, 1, false, false));
        }
    }

    public static void onMuscleFoodEaten(EntityPlayer player, int boost_mins) {
        MinecraftGlue.cureBadPotionEffectsWithMuscle(player);
        MinecraftGlue.giveGoodPotionEffectWithMuscle(player, boost_mins);
    }

    public static boolean isSwampishBiomeAtPos(World world, BlockPos pos) {
        BiomeGenBase biome = world.func_180494_b(pos);
        boolean is = false;
        if (biome != null && (BiomeGenBase.field_76782_w.func_150569_a(biome) || BiomeGenBase.field_76780_h.func_150569_a(biome))) {
            is = true;
        }
        return is;
    }
}

