/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class VfpConfig {
    static final String _GENERAL = "a Options";
    static final String _BAKERY = "b Bakery";
    static final String _BUTCHER = "c Butcher";
    static final String _PRODUCE = "d Produce";
    static final String _UPSIZER = "e Upsizer";
    static final String _OTHRMOD = "x Integration";
    static final String _MISC = "z Miscellaneous";
    private static final VfpConfig _defaultvaluesINSTANCE = new VfpConfig();
    private static VfpConfig _sharedINSTANCE;
    private Configuration _forgeConfig;
    private CreativeTabs _vfpTab;
    private final Map<String, Object> _cache = new HashMap<String, Object>(41);
    private final Map<String, Object> _builderContext = new HashMap<String, Object>();
    private boolean _dontSave;

    public VfpConfig() {
        this._forgeConfig = new Configuration();
    }

    public VfpConfig(FMLPreInitializationEvent event) {
        File genericLoc = event.getSuggestedConfigurationFile();
        File configFile = new File(genericLoc.getParentFile(), "Wabbity_" + genericLoc.getName());
        this._forgeConfig = new Configuration(configFile, "1");
        this._forgeConfig.load();
        this.validateVersion();
    }

    public static final synchronized VfpConfig setInstance(VfpConfig activeConfig) {
        VfpConfig oldConfig = _sharedINSTANCE;
        _sharedINSTANCE = activeConfig;
        return oldConfig;
    }

    public static final synchronized boolean clrInstance(VfpConfig expectedConfig) {
        boolean switched;
        boolean bl = switched = _sharedINSTANCE == expectedConfig;
        if (switched) {
            VfpConfig.setInstance(null);
        }
        return switched;
    }

    public static final synchronized VfpConfig getInstance() {
        VfpConfig c = _sharedINSTANCE;
        if (c == null) {
            c = _defaultvaluesINSTANCE;
        }
        return c;
    }

    public boolean isModLoaded(Integrations mod) {
        return Loader.isModLoaded((String)mod.modid());
    }

    public boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public final boolean isDebugMode() {
        if (VanillaFoodPantry.DESPERATION_DEBUG) {
            return true;
        }
        String PROPERTY = "debug_mode";
        Boolean b = (Boolean)this._cache.get("a Optionsdebug_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "debug_mode", false, "INTERNAL. Development messages enabled.");
        b = p.getBoolean();
        this._cache.put("a Optionsdebug_mode", b);
        return b;
    }

    public boolean useOwnTab() {
        String PROPERTY = "use_custom_tab";
        Boolean b = (Boolean)this._cache.get("a Optionsuse_custom_tab");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "use_custom_tab", true, "Set to true to force all VFP items and blocks to a single custom 'VFP' tab in creative or NEI views. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsuse_custom_tab", b);
        return b;
    }

    public void setVfpTab(CreativeTabs tab) {
        this._vfpTab = tab;
        this._builderContext.put("vfpTab", tab);
        VfpUtils.setVfpTabOverride(tab);
    }

    public CreativeTabs getVfpTab() {
        return this._vfpTab;
    }

    public boolean isSuperCompatibilityMode() {
        String PROPERTY = "super_compatibility_mode";
        Boolean b = (Boolean)this._cache.get("a Optionssuper_compatibility_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "super_compatibility_mode", false, "Set to true to force all the basic recipes to have a mod-specific element to ensure no collisions with other mod recipes; for example, instead of just a bucket of water to make bits o' water, the recipe will require a water bucket and a mod-specific item. OFF by default.");
        b = p.getBoolean();
        this._cache.put("a Optionssuper_compatibility_mode", b);
        return b;
    }

    public boolean includeCraftXpAndAchievements() {
        String PROPERTY = "achievements_and_xp_enabled";
        Boolean b = (Boolean)this._cache.get("a Optionsachievements_and_xp_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "achievements_and_xp_enabled", true, "Set to false to disable generation of experience and achievements from crafting VFP foods. Note that this option does not affect smelting or mining Xp. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsachievements_and_xp_enabled", b);
        return b;
    }

    public boolean generousCraftingXp() {
        String PROPERTY = "generous_xp";
        Boolean b = (Boolean)this._cache.get("a Optionsgenerous_xp");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "generous_xp", true, "Set to false to disable compensation for Minecraft ignoring small amounts of crafting Xp. Note that this option is ignored if crafting Xp is disabled. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsgenerous_xp", b);
        return b;
    }

    public boolean isOreGenerationEnabled() {
        String PROPERTY = "ore_generate_enabled";
        Boolean b = (Boolean)this._cache.get("a Optionsore_generate_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "ore_generate_enabled", true, "Set to false to disable generation of custom VFP ores like rock salt in new worlds and chunks. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsore_generate_enabled", b);
        return b;
    }

    public boolean alwaysIncludeSimpleFlourRecipe() {
        String PROPERTY = "always_include_simple_flour_recipe";
        Boolean b = (Boolean)this._cache.get("b Bakeryalways_include_simple_flour_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BAKERY, "always_include_simple_flour_recipe", false, "Set to true to disable the VFP check for a pre-existing flour recipe. Normally VFP will not include its own (1 wheat to 1 flour) recipe if one exists (regardless of what ingredients the other one uses). Disabled by default.");
        b = p.getBoolean();
        this._cache.put("b Bakeryalways_include_simple_flour_recipe", b);
        return b;
    }

    public boolean alwaysIncludeSimpleFriedEggRecipe() {
        String PROPERTY = "always_include_fried_egg_recipe";
        Boolean b = (Boolean)this._cache.get("c Butcheralways_include_fried_egg_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "always_include_fried_egg_recipe", false, "Set to true to disable the VFP check for a pre-existing fried egg recipe. Normally VFP will not include its own (smelt 1 egg) recipe if one exists (regardless of what ingredients or method the other one uses). Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcheralways_include_fried_egg_recipe", b);
        return b;
    }

    public boolean enableBoneSmelting() {
        String PROPERTY = "enable_bone_smelting";
        Boolean b = (Boolean)this._cache.get("c Butcherenable_bone_smelting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "enable_bone_smelting", !this.isSuperCompatibilityMode(), "Set to false to disable smelting of big bones directly to gelatin powder. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherenable_bone_smelting", b);
        return b;
    }

    public VfpCapacity maxDrinksStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "drinks_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizerdrinks_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "drinks_max_stacksize", defaultSize.count(), "Max stack size for all bottled items like fizzy and milk drinks. Default stack size is 24. Allowed sizes are [1,4,8,16,24,32,64].", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizerdrinks_max_stacksize", (Object)n);
        return n;
    }

    public VfpCapacity maxSoupsStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "soups_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizersoups_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "soups_max_stacksize", defaultSize.count(), "Max stack size for all soupy items like creamy soups and chowders. Default stack size is 24. Allowed sizes are [1,4,8,16,24,32,64].", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizersoups_max_stacksize", (Object)n);
        return n;
    }

    public VfpCapacity maxEggsStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "eggs_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizereggs_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "eggs_max_stacksize", defaultSize.count(), "Max stack size for all just-an-egg items like fried eggs that we inherit from other mods. Preferred stack size is 64; allowed sizes are [16,32,64]. Does NOT affect raw egg stack size.", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizereggs_max_stacksize", (Object)n);
        return n;
    }

    public boolean includeBatDrops() {
        String PROPERTY = "include_bat_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_bat_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_bat_drops", true, "Set to false to disable all VFP drops from killing a bat. VFP adds bat meat and bat poop (used to create rotten flesh or as a fertilizer like bone meal). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_bat_drops", b);
        return b;
    }

    public boolean includeCalfDrops() {
        String PROPERTY = "include_calf_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_calf_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_calf_drops", true, "Set to false to disable stomach lining drops from killing baby cows. VFP adds calf stomach lining for use in creating curdling agent for cheese. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_calf_drops", b);
        return b;
    }

    public boolean includePigDrops() {
        String PROPERTY = "include_pig_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_pig_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_pig_drops", true, "Set to false to disable all VFP drops from killing pigs. VFP adds drops like raw pork hocks and pig tails. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_pig_drops", b);
        return b;
    }

    public boolean includeHorseDrops() {
        String PROPERTY = "include_horse_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_horse_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_horse_drops", true, "Set to true to enable all VFP drops from killing horses. VFP adds drops like horse tears and raw horse meat. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_horse_drops", b);
        return b;
    }

    public boolean includeWolfDrops() {
        String PROPERTY = "include_wolf_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_wolf_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_wolf_drops", true, "Set to true to enable all VFP drops from killing wolves (tamed and untamed). VFP adds raw wolf meat. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_wolf_drops", b);
        return b;
    }

    public boolean increaseMeatDrops() {
        String PROPERTY = "upsize_meat_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherupsize_meat_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "upsize_meat_drops", true, "Set to true to increase the number of meat dropped from killing cows, pigs, sheep, etc. The increase is from 0 to 3 more pieces with auxilliary items (like hides) always included. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherupsize_meat_drops", b);
        return b;
    }

    public boolean excludeHorseMeatDrops() {
        String PROPERTY = "exclude_horse_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_horse_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_horse_meat", false, "Set to true to disable ONLY meat drops from killing horses when 'include_horse_drops' is enabled; ignored otherwise. Use if you have another mod that already drops horse meat. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_horse_meat", b);
        return b;
    }

    public boolean excludeWolfMeatDrops() {
        String PROPERTY = "exclude_wolf_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_wolf_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_wolf_meat", false, "Set to true to disable ONLY meat drops from killing wolves when 'include_wolf_drops' is enabled; ignored otherwise. Use if you have another mod that already drops wolf meat. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_wolf_meat", b);
        return b;
    }

    public boolean useMushroomBlocksForPantry() {
        String PROPERTY = "use_mushroom_blocks_as_storage";
        Boolean b = (Boolean)this._cache.get("d Produceuse_mushroom_blocks_as_storage");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_PRODUCE, "use_mushroom_blocks_as_storage", true, "Set to false to disable (un)crafting of (9) mushrooms from standard mushroom blocks. If enabled you can increase storage size of mushrooms per slot and unlock all the mushroomy goodness of giant mushrooms! Enabled by default.");
        b = p.getBoolean();
        this._cache.put("d Produceuse_mushroom_blocks_as_storage", b);
        return b;
    }

    public boolean craftOtherSourcesOfWater() {
        String PROPERTY = "extra_water_items_crafting";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousextra_water_items_crafting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "extra_water_items_crafting", true, "Set to false to disable extra craft recipes for water buckets and bottles (for instance the recipe to convert ice blocks to buckets of water). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousextra_water_items_crafting", b);
        return b;
    }

    public boolean craftPantryMigrationRecipes() {
        String PROPERTY = "pantry_migration_crafting";
        Boolean b = (Boolean)this._cache.get("z Miscellaneouspantry_migration_crafting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "pantry_migration_crafting", false, "Set to true to enable extra craft recipes for migration of other food mod crafted items to their equivalent (or mostly equivalent) VFP items. Disabled by default. INTERNAL.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneouspantry_migration_crafting", b);
        return b;
    }

    public boolean fixPMPFoodDictionary() {
        String PROPERTY = "fix_food_dictionary";
        String _PMP_CATEGORY = "x Integration.PMP";
        Boolean b = (Boolean)this._cache.get("x Integration.PMPfix_food_dictionary");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.PMP", "fix_food_dictionary", true, "Set to false to disable installing 'food*' dictionary mappings for PMP-based foodstuffs. Only used if PMP mod detected and is a version where this tweak is needed (ignored otherwise). Enabled by default. INTERNAL.");
        b = p.getBoolean();
        this._cache.put("x Integration.PMPfix_food_dictionary", b);
        return b;
    }

    public String[] getPMPWaterFlavorFlowers() {
        String PROPERTY = "flower_water_flavors";
        String _PMP_CATEGORY = "x Integration.PMP";
        String[] values = (String[])this._cache.get("x Integration.PMPflower_water_flavors");
        if (values != null) {
            return values;
        }
        values = this.forgeConfig().getStringList("flower_water_flavors", "x Integration.PMP", new String[]{"flowerTulip", "flowerRose"}, "Set to the names of PMP flowers (tulips+roses) that can be converted to flavored waters. Defaults to all tulips and roses as of PMP 5.07(1.8)");
        this._cache.put("x Integration.PMPflower_water_flavors", values);
        return values;
    }

    public String[] getPMPEdibleMushrooms() {
        String PROPERTY = "edible_mushrooms";
        String _PMP_CATEGORY = "x Integration.PMP";
        String[] values = (String[])this._cache.get("x Integration.PMPedible_mushrooms");
        if (values != null) {
            return values;
        }
        values = this.forgeConfig().getStringList("edible_mushrooms", "x Integration.PMP", new String[]{"fungusChanterelle", "fungusGiantClub", "fungusWeepingMilkCap", "fungusStinkhorn"}, "Set to the names of PMP mushrooms (fungi) that can be eaten and converted to mushroom powder. Defaults to common mushrooms as of PMP 5.07(1.8)");
        this._cache.put("x Integration.PMPedible_mushrooms", values);
        return values;
    }

    public boolean fixHVCFoodDictionary() {
        String PROPERTY = "fix_food_dictionary";
        String _HVC_CATEGORY = "x Integration.HVC";
        Boolean b = (Boolean)this._cache.get("x Integration.HVCfix_food_dictionary");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.HVC", "fix_food_dictionary", true, "Set to false to disable installing 'food*' dictionary mappings for Harvestcraft-based foodstuffs. Only used if Harvestcraft mod detected and is a version where this tweak is needed (ignored otherwise). Enabled by default. INTERNAL.");
        b = p.getBoolean();
        this._cache.put("x Integration.HVCfix_food_dictionary", b);
        return b;
    }

    public boolean includeModRecipes() {
        String PROPERTY = "recipe_use_enabled";
        Boolean b = (Boolean)this._cache.get("x Integrationrecipe_use_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_OTHRMOD, "recipe_use_enabled", true, "Set to false to disable recipe-making with non-vanilla foodstuffs (for example PMP or Harvestcraft). Note turning this off _after_ you've created mod-dependent items can result in lost items. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integrationrecipe_use_enabled", b);
        return b;
    }

    public boolean harderFries() {
        String PROPERTY = "use_harder_fries_recipe";
        Boolean b = (Boolean)this._cache.get("z Miscellaneoususe_harder_fries_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "use_harder_fries_recipe", false, "Set to true to enable a more complex raw fries recipe (requires salt and vinegar bath).  Disabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneoususe_harder_fries_recipe", b);
        return b;
    }

    public boolean ignoreMagicalEmptiesBug() {
        String PROPERTY = "ignore_magical_empties_bug";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousignore_magical_empties_bug");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "ignore_magical_empties_bug", false, "Set to true to enable setting of empties for things like drinks, soups, and bags. Disabled by default. INTERNAL.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousignore_magical_empties_bug", b);
        return b;
    }

    public boolean alwaysIncludeRedFlintDrops() {
        String PROPERTY = "always_include_red_flint_drops";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousalways_include_red_flint_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "always_include_red_flint_drops", false, "Set to true to enable red flint drops whether in super-compatibility mode or not. Some recipes require red flint. If you want these recipes always, turn this option on. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousalways_include_red_flint_drops", b);
        return b;
    }

    public boolean isAutocraftingEnabled() {
        String PROPERTY = "automation_enabled";
        Boolean b = (Boolean)this._cache.get("x Integrationautomation_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_OTHRMOD, "automation_enabled", true, "Set to false to disable integration with automation mods like smart-hoppers that support auto-crafting mechanics. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integrationautomation_enabled", b);
        return b;
    }

    public final void persist() {
        this.fullyDefine();
        if (!this._dontSave) {
            this.forgeConfig().save();
        }
    }

    final Configuration forgeConfig() {
        return this._forgeConfig;
    }

    public Map<String, Object> builderContext() {
        return this._builderContext;
    }

    public boolean isPresent(String feature) {
        return Boolean.valueOf(true).equals(this._builderContext.get(feature + ".present"));
    }

    public void setPresent(String feature) {
        this._builderContext.put(feature + ".present", true);
    }

    public String getPresentAs(String feature) {
        Object value = this._builderContext.get(feature + ".forgeid");
        return value == null ? null : String.valueOf(value);
    }

    public void setPresentAs(String feature, String as) {
        this._builderContext.put(feature + ".present", true);
        this._builderContext.put(feature + ".forgeid", as);
    }

    public void captureContextOres() {
        List<String> ores = Arrays.asList(OreDictionary.getOreNames());
        this._builderContext.put("__ores", ores);
    }

    public List<String> capturedContextOres() {
        List ores = (List)List.class.cast(this._builderContext.get("__ores"));
        return ores != null ? ores : Collections.EMPTY_LIST;
    }

    private void fullyDefine() {
        this.useOwnTab();
        this.isSuperCompatibilityMode();
        this.includeCraftXpAndAchievements();
        this.generousCraftingXp();
        this.isOreGenerationEnabled();
        this.increaseMeatDrops();
        this.includeBatDrops();
        this.includeCalfDrops();
        this.includePigDrops();
        this.includeHorseDrops();
        this.includeWolfDrops();
        this.alwaysIncludeSimpleFlourRecipe();
        this.alwaysIncludeSimpleFriedEggRecipe();
        this.enableBoneSmelting();
        this.excludeHorseMeatDrops();
        this.excludeWolfMeatDrops();
        this.maxDrinksStackCapacity(VfpLiquidFood.DEFAULT_STACK_SIZE);
        this.maxSoupsStackCapacity(VfpLiquidFood.DEFAULT_STACK_SIZE);
        this.maxEggsStackCapacity(VfpCapacity.BULK_STACK);
        this.craftOtherSourcesOfWater();
        this.useMushroomBlocksForPantry();
        this.includeModRecipes();
        this.fixPMPFoodDictionary();
        this.getPMPWaterFlavorFlowers();
        this.getPMPEdibleMushrooms();
        this.fixHVCFoodDictionary();
        this.harderFries();
        this.alwaysIncludeRedFlintDrops();
        this.craftPantryMigrationRecipes();
        this.ignoreMagicalEmptiesBug();
        this.isAutocraftingEnabled();
    }

    private void validateVersion() {
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)this._forgeConfig.getLoadedConfigVersion())) {
            int v_load = NumberUtils.toInt((String)this._forgeConfig.getLoadedConfigVersion(), (int)-1);
            int v_curr = NumberUtils.toInt((String)"1");
            if (v_load < 0 || v_load > v_curr) {
                this._dontSave = true;
                FMLLog.warning((String)"Unrecognized configuration version detected; config changes will NOT be saved this session", (Object[])new Object[0]);
            }
        }
    }
}

