/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public abstract class VfpLiquidMultiItem
extends VfpPantryMultiItem {
    protected final VfpVariantSet _variantset;

    protected static final synchronized boolean register(Ingredient flavor, List<Ingredient> variant_flavors, String typename) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for %s", (Object[])new Object[]{typename});
        boolean added = false;
        if (!variant_flavors.contains(flavor)) {
            added = variant_flavors.add(flavor);
        }
        return added;
    }

    protected VfpLiquidMultiItem(VfpProfile oid, VfpVariantSet set, CreativeTabs tab) {
        super(oid, false, set.variants(), tab, true);
        this._variantset = set;
        this.func_77625_d(this.getItemMaxStackSize().count());
        this.completeInit(oid);
    }

    protected abstract ItemStack getNewEmptyContainer();

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    @SideOnly(value=Side.CLIENT)
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = null;
        if (type != null) {
            if (ingredient instanceof FoodColor) {
                int num = ((FoodColor)((Object)ingredient)).color(ingredient.recipeitem());
                if (num != 0xF1F1F1) {
                    colorValue = num;
                }
            } else if (ingredient.recipeitem().func_77973_b() instanceof FoodColor) {
                int num = ((FoodColor)ingredient.recipeitem().func_77973_b()).color(ingredient.recipeitem());
                if (num != 0xF1F1F1) {
                    colorValue = num;
                }
            } else {
                int num = ingredient.recipeitem().func_77973_b().func_82790_a(ingredient.recipeitem(), renderPass);
                if (num != 0xFFFFFF) {
                    colorValue = num;
                }
            }
        }
        return colorValue;
    }

    @SideOnly(value=Side.CLIENT)
    protected int getColorFromMeta(int meta, int renderPass) {
        Integer colorValue;
        Ingredient ingredient;
        int color_num = 0;
        VfpVariant type = this._variantset.lookup(meta);
        if (type != null && (ingredient = type.datadata(Ingredient.class)) != null && (colorValue = this.getVariantColorFromMeta(type, ingredient, renderPass)) != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        int default_color_num;
        int color_num = default_color_num = super.func_82790_a(stack, renderPass);
        if (renderPass <= 0 && (color_num = this.getColorFromMeta(stack.func_77960_j(), renderPass)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        String name = MinecraftGlue.I18N_ITEM_KEY_PREFIX() + this._variantset.typeName();
        if (variant != null) {
            name = name + "_" + variant.datadata(Named.class).name();
        }
        return name;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        player.func_71024_bL().func_151686_a((ItemFood)this, stack);
        world.func_72956_a((Entity)player, "random.burp", 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_77849_c(stack, world, player);
        player.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack empty = this.getNewEmptyContainer();
            if (stack.field_77994_a <= 0) {
                return empty;
            }
            if (!player.field_71071_by.func_70441_a(empty)) {
                player.func_71019_a(empty, false);
            }
        }
        return stack;
    }

    protected static abstract class VariantSet
    extends VfpVariantSet.ByMapInstance {
        protected VariantSet(VfpProfile typedef, Class<?> marker) {
            super(typedef, marker, "flavor");
        }

        @Override
        public String[] renderNames() {
            return new String[]{"vanillafoodpantry:" + this.typeName()};
        }
    }
}

