/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpOreBlock
extends VfpPlainBlock {
    private static final int MAX_XP = 8;
    protected final ItemStack _drop;
    protected final int _max_dropcount;
    private final int _alt_dropcount;
    private final Integer _breakXp;

    public VfpOreBlock(VfpProfile oid, Material likeMaterial, Block likeBlock, ItemStack drop, Integer bXp, CreativeTabs tab) {
        super(oid, likeMaterial, likeBlock, tab);
        Validate.notNull((Object)drop, (String)"A non-null drop item is required for an ore block", (Object[])new Object[0]);
        this._drop = drop;
        this._breakXp = bXp;
        this._max_dropcount = this._oid.capacity().count();
        this._alt_dropcount = Math.max(1, this._drop.field_77994_a >> 1);
    }

    public VfpOreBlock(VfpProfile oid, Block likeBlock, ItemStack drop, Integer bXp) {
        this(oid, null, likeBlock, drop, bXp, null);
    }

    public int func_149679_a(int fortune, Random random) {
        int chance;
        int count = this._drop.field_77994_a + random.nextInt(this._alt_dropcount);
        if (fortune > 0 && count < this._max_dropcount && (chance = random.nextInt(this._max_dropcount + fortune)) > count) {
            count = chance;
        }
        if (count > this._max_dropcount) {
            count = this._max_dropcount;
        }
        return count;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this._drop.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return this._drop.func_77960_j();
    }

    public int getExpDrop(IBlockAccess world, BlockPos pos, int fortune) {
        int Xp = 0;
        if (this._breakXp != null) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            Xp = MathHelper.func_76136_a((Random)rand, (int)1, (int)this._breakXp);
            if (fortune > 0 && ((World)world).field_73012_v.nextInt(2) > 0) {
                Xp += fortune;
            }
            if (Xp > 8) {
                Xp = 8;
            }
        }
        return Xp;
    }

    public static final void oreSpawn(IBlockState spawnBlock, Block targetBlock, World world, Random random, int blockX, int blockZ, int maxXDim, int maxZDim, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        Validate.isTrue((minY <= maxY ? 1 : 0) != 0, (String)"A valid minY relative to maxY is required", (Object[])new Object[0]);
        Validate.isTrue((minY > 0 && maxY < 256 ? 1 : 0) != 0, (String)"A valid minY and maxY is required", (Object[])new Object[0]);
        Validate.isTrue((maxXDim > 0 && maxXDim <= MinecraftGlue.CHUNK_DIM() ? 1 : 0) != 0, (String)"A valid maxX-offset from block is required", (Object[])new Object[0]);
        Validate.isTrue((maxZDim > 0 && maxZDim <= MinecraftGlue.CHUNK_DIM() ? 1 : 0) != 0, (String)"A valid maxZ-offset from block is required", (Object[])new Object[0]);
        int maxYDim = maxY - minY + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = blockX + random.nextInt(maxXDim);
            int y = minY + random.nextInt(maxYDim);
            int z = blockZ + random.nextInt(maxZDim);
            new WorldGenMinable(spawnBlock, maxVeinSize, (Predicate)BlockStateHelper.func_177638_a((Block)targetBlock)).func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

