/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public class VfpPantryMultiBlock
extends VfpPantryBlock {
    static final String UNKNOWN_NAME = MinecraftGlue.I18N_BLOCK_KEY_PREFIX() + RandomStringUtils.randomAlphabetic((int)16);
    private static final ThreadLocal<VfpVariantSet> _set_under_construction = new ThreadLocal();
    private static final Class[] MULTI_BLOCK_CTOR_SIG_I = new Class[0];
    protected final VfpVariantSet _variants;
    private CreativeTabs[] _tabs;
    private final IProperty[] _variantsPA;
    final VfpVariant[] _variantsJA;

    public static void set_under_construction(VfpVariantSet set) {
        _set_under_construction.set(set);
    }

    static final VfpVariantSet get_under_construction() {
        return _set_under_construction.get();
    }

    protected VfpPantryMultiBlock(VfpProfile oid, Block likeBlock, ItemStack constituent, VfpVariantSet variants, CreativeTabs tab) {
        super(oid, null, likeBlock, constituent, tab);
        Validate.isTrue((VfpPantryMultiBlock.get_under_construction() == variants ? 1 : 0) != 0);
        Validate.isTrue((boolean)MinecraftGlue.validForBlockmeta(variants.size()), (String)"Variant set size must be <= 16", (Object[])new Object[0]);
        Validate.isTrue((variants.size() > 0 ? 1 : 0) != 0, (String)"Must have at least ONE variant of a %s item to need multiblock", (Object[])new Object[]{oid});
        this._variants = variants;
        this._variantsPA = new IProperty[]{variants};
        this._variantsJA = variants.variants();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this._variantsPA[0], (Comparable)this._variantsJA[0]));
        this.func_149663_c("");
    }

    protected VfpPantryMultiBlock(VfpProfile oid, Block likeBlock, Item constituent, VfpVariantSet variants, CreativeTabs tab) {
        this(oid, likeBlock, new ItemStack(constituent), variants, tab);
    }

    protected VfpPantryMultiBlock(VfpProfile oid, VfpPantryMultiBlock from, int compressionIncrement) {
        super(oid, from, compressionIncrement, false);
        this._variants = from._variants;
        this._variantsPA = new IProperty[]{this._variants};
        this._variantsJA = this._variants.variants();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this._variantsPA[0], (Comparable)this._variantsJA[0]));
        this.func_149663_c("");
    }

    protected BlockState func_180661_e() {
        Validate.validState((VfpPantryMultiBlock.get_under_construction() != null ? 1 : 0) != 0, (String)"pantry multi-block under_construction not set", (Object[])new Object[0]);
        return new BlockState((Block)this, new IProperty[]{VfpPantryMultiBlock.get_under_construction()});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this._variantsPA[0], (Comparable)VfpVariant.byMetadata(meta, this._variantsJA));
    }

    public int func_176201_c(IBlockState state) {
        VfpVariant variant = (VfpVariant)state.func_177229_b(this._variantsPA[0]);
        return variant.metadata();
    }

    protected int getMaxStackFromMeta(int meta) {
        return -1;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    protected ItemStack getVariantItemDropped(IBlockState state) {
        return this._constituent;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        ItemStack drop = this.getVariantItemDropped(state);
        return drop.func_77973_b();
    }

    @Override
    public int func_180651_a(IBlockState state) {
        ItemStack drop = this.getVariantItemDropped(state);
        return drop.func_77960_j();
    }

    @Override
    protected boolean isEffectivelyDense(IBlockState state) {
        if (this._oid.isLiquid()) {
            return false;
        }
        if (this._oid.isDense()) {
            return true;
        }
        if (state != null) {
            int wouldDrop = this.quantityDropped(state, 0, null);
            return wouldDrop >= VfpCapacity.DENSE_BLOCK.count();
        }
        return super.isEffectivelyDense(state);
    }

    final CreativeTabs[] getTabs() {
        if (this._tabs == null) {
            this._tabs = VfpUtils.getTabs(this._variantsJA, this.func_149708_J());
        }
        return this._tabs;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List subBlocks) {
        if (tab == null) {
            for (int index = 0; index < this._variantsJA.length; ++index) {
                subBlocks.add(new ItemStack(itemIn, 1, this._variantsJA[index].metadata()));
            }
        } else {
            CreativeTabs preferredTab = VfpUtils.preferredTab();
            CreativeTabs defaultTab = this.func_149708_J();
            for (int index = 0; index < this._variantsJA.length; ++index) {
                CreativeTabs wantTab;
                VfpVariant variant = this._variantsJA[index];
                CreativeTabs creativeTabs = preferredTab != null ? preferredTab : (wantTab = variant.tab() != null ? variant.tab() : defaultTab);
                if (wantTab != tab) continue;
                subBlocks.add(new ItemStack(itemIn, 1, variant.metadata()));
            }
        }
    }

    @Override
    public VfpPlainBlock autoregister() {
        GameRegistry.registerBlock((Block)this, ItemBlock.class, (String)this._variants.typeName());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends VfpPantryMultiBlock> T create(VfpVariantSet set, Class<T> ofType, boolean register) {
        VfpPantryMultiBlock block = null;
        Object[] args = new Object[]{};
        Class<VfpPantryMultiBlock> clazz = VfpPantryMultiBlock.class;
        synchronized (VfpPantryMultiBlock.class) {
            try {
                VfpPantryMultiBlock.set_under_construction(set);
                block = (VfpPantryMultiBlock)ConstructorUtils.invokeExactConstructor(ofType, (Object[])args, (Class[])MULTI_BLOCK_CTOR_SIG_I);
            }
            catch (Throwable ctorX) {
                throw new IllegalArgumentException("Unable to create dynamic VFP multi-block " + set.typeName(), ctorX);
            }
            finally {
                VfpPantryMultiBlock.set_under_construction(null);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (register) {
                block.autoregister();
            }
            return (T)((VfpPantryMultiBlock)ofType.cast(block));
        }
    }

    public static final class ItemBlock
    extends VfpPlainBlock.VfpItemBlock {
        public ItemBlock(Block block) {
            super(block);
            Validate.isInstanceOf(VfpPantryMultiBlock.class, (Object)block);
            this.func_77655_b("");
            this.func_77627_a(true).func_77656_e(0);
        }

        public String func_77667_c(ItemStack stack) {
            VfpPantryMultiBlock myblock = this.getVfpBlock();
            VfpVariant variant = VfpVariant.byItemStack(stack, myblock._variantsJA, myblock._variants.markerObject());
            return variant != null ? super.func_77658_a() + variant.fmlid() : UNKNOWN_NAME;
        }

        public int func_77647_b(int blockmeta) {
            return blockmeta;
        }

        public CreativeTabs[] getCreativeTabs() {
            return this.getVfpBlock().getTabs();
        }

        public int getItemStackLimit(ItemStack stack) {
            int max = this.getVfpBlock().getMaxStackFromMeta(stack.func_77960_j());
            return max > 0 ? max : super.getItemStackLimit(stack);
        }

        private VfpPantryMultiBlock getVfpBlock() {
            return (VfpPantryMultiBlock)VfpPantryMultiBlock.class.cast(this.func_179223_d());
        }
    }
}

