/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpPotionItem
extends ItemPotion
implements VfpAware {
    public static final String NBT_POTION_I18N_ID = "vfp_unlocalizedName";
    public static final String NBT_POTION_COLOR_ID = "vfp_colorValue";
    protected final VfpProfile _oid;

    public VfpPotionItem(VfpProfile oid) {
        Validate.isTrue((boolean)oid.isItem(), (String)"A pantry item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._oid = oid;
        this.func_77655_b(oid.fmlid());
    }

    public VfpPotionItem() {
        this(VfpOid.Potion_Base);
        this.func_77655_b("potion");
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public final <T extends VfpPotionItem> T autoregister(Class<T> of) {
        GameRegistry.registerItem((Item)this, (String)this._oid.fmlid());
        return (T)((VfpPotionItem)of.cast(this));
    }

    public final VfpPotionItem autoregister() {
        GameRegistry.registerItem((Item)this, (String)this._oid.fmlid());
        return this;
    }

    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 30 : 15;
    }

    public String func_150896_i(ItemStack stack) {
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
    }

    public String func_77667_c(ItemStack stack) {
        String s = stack.func_77942_o() && stack.func_77978_p().func_150297_b(NBT_POTION_I18N_ID, 8) ? MinecraftGlue.I18N_ITEM_KEY_PREFIX() + stack.func_77978_p().func_74779_i(NBT_POTION_I18N_ID) : super.func_77667_c(stack);
        return s;
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    public int getMetadata(ItemStack stack) {
        return stack.func_77973_b() == this ? 8206 : super.getMetadata(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_77620_a(int meta) {
        return 16742400;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass > 0) {
            return 0xFFFFFF;
        }
        int color = stack.func_77942_o() && stack.func_77978_p().func_150297_b(NBT_POTION_COLOR_ID, 3) ? stack.func_77978_p().func_74762_e(NBT_POTION_COLOR_ID) : super.func_82790_a(stack, renderPass);
        return color;
    }
}

