/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplPMP {
    private static final String _CORN = "foodCorn";
    private static final String _CASSAVA = "foodCassavaRoot";
    private static final String _TARO = "foodTaroRoot";
    private static final String _RICE = "foodRice";
    private static final String _TOMATO = "foodTomato";
    private static final String _CELERY = "foodCelery";
    private static final String _ONION = "foodOnion";
    private static final String _LEEK = "foodLeek";
    private static final String _CUCUMBER = "foodCucumber";
    private static final String _SWEETPEPPER_Y = "foodBellPepperYellow";
    private static final String _SWEETPEPPER_R = "foodBellPepperRed";
    private static final String _SWEETPEPPER_O = "foodBellPepperOrange";
    private static final String _EGGPLANT = "foodEggplant";
    private static final String _BROCCOLI = "foodBroccoli";
    private static final String _GREENBEANS = "foodGreenBeans";
    private static final String _BEETS = "foodBeet";
    private static final String _SPINACH = "foodSpinach";
    private static final String _WATERCRESS = "foodWatercress";
    private static final String _GRAPES = "foodGrapesPurple";
    private static final String _STRAWBERRY = "foodStrawberry";
    private static final String _BLUEBERRY = "foodBlueberry";
    private static final String _KIWI = "foodKiwi";
    private static final String _PEANUTS = "foodPeanuts";
    private static final String _PBJ_SANDWICH = "foodSandwichPBJ";
    private static final String _COOKED_RICE = "foodCookedRice";
    private static final String _T = "_T";
    private static final String _F = "_F";

    ImplPMP() {
    }

    static final void fixFoodDictionary(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && config.fixPMPFoodDictionary()) {
            boolean registered;
            boolean bl = registered = mappings.contains(_TARO) && mappings.contains(_SWEETPEPPER_O) && mappings.contains(_CASSAVA);
            if (!registered) {
                String[] pmp_pantry;
                for (String pmp_fooditem : pmp_pantry = new String[]{_CORN, _CASSAVA, _TARO, _RICE, _EGGPLANT, _BROCCOLI, _GREENBEANS, _SPINACH, _WATERCRESS, _TOMATO, _CELERY, _ONION, _LEEK, _CUCUMBER, _BEETS, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O, _GRAPES, _STRAWBERRY, _BLUEBERRY, _KIWI, _PEANUTS}) {
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, pmp_fooditem, pmp_fooditem);
                }
            }
        }
    }

    static final void detectFeatureSupport(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String forgeid;
            boolean generalize = config.fixPMPFoodDictionary();
            if (!config.isPresent("cassava") && mappings.contains(_CASSAVA)) {
                forgeid = _CASSAVA;
                if (generalize) {
                    forgeid = "foodCassava";
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _CASSAVA);
                }
                config.setPresentAs("cassava", forgeid);
            }
            if (!config.isPresent("grapes") && mappings.contains(_GRAPES)) {
                forgeid = _GRAPES;
                if (generalize) {
                    forgeid = "foodGrapes";
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _GRAPES);
                }
                config.setPresentAs("grapes", forgeid);
            }
            if (!config.isPresent("bellpepper") && mappings.contains(_SWEETPEPPER_Y)) {
                if (generalize) {
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_O);
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_Y);
                    IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBellPepper", _SWEETPEPPER_R);
                    config.setPresentAs("bellpepper", "foodBellPepper");
                } else {
                    config.setPresentAs("bellpepper", _SWEETPEPPER_Y);
                }
            }
            if (mappings.contains(_BEETS)) {
                if (!config.isPresent("beets")) {
                    forgeid = _BEETS;
                    if (generalize) {
                        forgeid = "foodBeets";
                        IntegrationsImpl._registerFoodItem(Integrations.PMP, forgeid, _BEETS);
                    }
                    config.setPresentAs("beets", forgeid);
                }
                IntegrationsImpl._registerFoodItem(Integrations.PMP, "foodBeets", _BEETS);
            }
        }
    }

    static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && !config.fixPMPFoodDictionary()) {
            String[] primary = new String[]{_BROCCOLI, _EGGPLANT, _CASSAVA};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabMain", primary);
            String[] fillers = new String[]{_TOMATO, _ONION, _LEEK, _CORN, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientKebabFill", fillers);
            String[] nuggets = new String[]{_BROCCOLI, _EGGPLANT};
            IntegrationsImpl._registerFoodItems(Integrations.PMP, "ingredientVegNugget", nuggets);
        }
    }

    static final void registerFoodPowders(int slotid_0th, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP) && !config.fixPMPFoodDictionary()) {
            FoodPowders.Type fpt;
            Item item;
            boolean debug = config.isDebugMode();
            int id = slotid_0th;
            if (FoodPowders.findType("strawberry") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_STRAWBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "strawberry", new ItemStack(item), 1, 2, null, (Integer)0xDD6161);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("blueberry") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_BLUEBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "blueberry", new ItemStack(item), 1, 3, null, (Integer)6384842);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("peanuts") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_PEANUTS))) != null) {
                fpt = new FoodPowders.Type(id, "peanuts", new ItemStack(item), 0, 3, null, (Integer)12816928);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("leek") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_LEEK))) != null) {
                fpt = new FoodPowders.Type(id, "leek", new ItemStack(item), 0x101000, null, (Integer)15859668);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("tomato") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_TOMATO))) != null) {
                fpt = new FoodPowders.Type(id, "tomato", new ItemStack(item), 4096, 2, "ingredientTomato", (Integer)14111549);
                OreDictionary.registerOre((String)"ingredientTomato", (Item)item);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("celery") == null && (item = Item.func_111206_d((String)Integrations.PMP.itemid(_CELERY))) != null) {
                fpt = new FoodPowders.Type(id, "celery", new ItemStack(item), 0x100000, null, null);
                if (debug) {
                    FMLLog.fine((String)"PMP foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
        }
    }

    static final void registerEdibleFlowers(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] flowers;
            boolean generalize = config.fixPMPFoodDictionary();
            for (String flower_name : flowers = config.getPMPWaterFlavorFlowers()) {
                Block flower;
                if (!flower_name.startsWith("flower") || (flower = Block.func_149684_b((String)Integrations.PMP.itemid(flower_name))) == null) continue;
                ItemStack all_varieties = new ItemStack(flower, 1, Item.func_150898_a((Block)flower).func_77614_k() ? Short.MAX_VALUE : 0);
                if (generalize) {
                    OreDictionary.registerOre((String)"foodFlower", (ItemStack)all_varieties);
                }
                OreDictionary.registerOre((String)"ingredientFlower", (ItemStack)all_varieties);
                if (!flower_name.startsWith("flowerRose")) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodRoseFlower", (Block)flower);
                }
                OreDictionary.registerOre((String)"ingredientRoseFlower", (Block)flower);
            }
        }
    }

    static final void registerMushrooms(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            String[] fungi;
            boolean generalize = config.fixPMPFoodDictionary();
            for (String fungus : fungi = config.getPMPEdibleMushrooms()) {
                Block item = Block.func_149684_b((String)Integrations.PMP.itemid(fungus));
                if (item == null) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodMushroom", (Block)item);
                }
                OreDictionary.registerOre((String)"ingredientMushroom", (Block)item);
                OreDictionary.registerOre((String)"ingredientKebabFill", (Block)item);
            }
            IntegrationsImpl._registerFoodItem(Integrations.PMP, "ingredientBeet", _BEETS);
        }
    }

    static final void registerPackagedFoods(VfpConfig config) {
        if (!config.isModLoaded(Integrations.PMP)) {
            return;
        }
        boolean debug = config.isDebugMode();
        VfpCapacity BULK = VfpCapacity.BULK_STACK;
        String[] baggables = new String[]{"fruit", _STRAWBERRY, "strawberries", _F, "fruit", _BLUEBERRY, "blueberries", _F, "fruit", _PEANUTS, "peanuts", _F, "fruit", _GRAPES, "grapes", _T, "vegetable", _CORN, "corn", _F, "vegetable", _BROCCOLI, "broccoli", _F, "vegetable", _SPINACH, "spinach", _F, "vegetable", _TOMATO, "tomatoes", _F, "vegetable", _EGGPLANT, "eggplant", _F, "vegetable", _CASSAVA, "cassava", _F, "bakery", _PBJ_SANDWICH, "sandwich_pbj", _F, "general", _COOKED_RICE, "precooked_rice", _T};
        for (int i = 0; i < baggables.length; i += 4) {
            PackagedFood.Type type = PackagedFood.Type.valueOf(baggables[i]);
            Item item = Item.func_111206_d((String)Integrations.PMP.itemid(baggables[i + 1]));
            if (!(item instanceof ItemFood)) continue;
            PackagedFood pf = new PackagedFood(type.name(), baggables[i + 2], new LikeFood((ItemFood)item), null, null, BULK);
            if (baggables[i + 3] == _T) {
                CartonsBuildHelper.exclude(type, pf);
            }
            if (!debug) continue;
            FMLLog.finer((String)"PMP packagedFood '%s' registers: %s", (Object[])new Object[]{baggables[i], pf});
        }
    }

    static final void registerAutocraftingRecipes(VfpConfig config) {
        if (!config.isModLoaded(Integrations.PMP)) {
            return;
        }
    }

    static final void autorecipeMisc(VfpConfig config) {
        if (config.isModLoaded(Integrations.PMP)) {
            Item eggplant;
            Item corn_on_cob = Item.func_111206_d((String)Integrations.PMP.itemid(_CORN));
            if (corn_on_cob instanceof ItemFood) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(corn_on_cob), (ItemStack)new ItemStack(VfpObj.Roast_Corn_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if ((eggplant = Item.func_111206_d((String)Integrations.PMP.itemid(_EGGPLANT))) instanceof ItemFood) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(eggplant), (ItemStack)new ItemStack(VfpObj.Roasted_Eggplant_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
        }
    }
}

