/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Kebabs
extends VfpPantryMultiItem {
    private static final int KEBAB_BATCH = 4;
    private static final int SMALL_KEBAB_BATCH = 2;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Kebab, Kebabs.class, "type");
    private static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "kebab_meat_raw", LikeFood.uncooked_kebab, VARIANT_SET, true), new VfpVariant(1, "kebab_meat", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(2, "kebab_poultry_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(3, "kebab_poultry", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(4, "kebab_fish_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(5, "kebab_fish", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(6, "kebab_veggie_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(7, "kebab_veggie", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(8, "kebab_fruit_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(9, "kebab_fruit", LikeFood.kebab, VARIANT_SET, false), new VfpVariant(10, "kebab_adventure_raw", LikeFood.uncooked_kebab, VARIANT_SET, false), new VfpVariant(11, "kebab_adventure", LikeFood.kebab, VARIANT_SET, false)};
    private static Kebabs INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static final int _MEAT_KEBAB_COOKED = 1;
    private static final int _ADVENTURE_KEBAB_RAW = 10;

    public Kebabs(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    static final synchronized Kebabs get() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Kebab, Kebabs.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static final void addMKebabs(int raw_meta, int cooked_meta, PackagedFood[] meats, boolean is_fish, List<ItemStack> instances) {
        for (PackagedFood meat : meats) {
            ItemStack _main = meat.food().sample();
            ItemStack raw_kebab = new ItemStack((Item)INSTANCE, is_fish ? 2 : 4, raw_meta);
            ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
            raw_kebab.field_77994_a = 1;
            GameRegistry.addSmelting((ItemStack)raw_kebab, (ItemStack)kebab, (float)LikeFood.uncooked_kebab.smeltExperience());
            instances.add(raw_kebab);
            instances.add(kebab);
        }
    }

    private static final void addVKebabs(int raw_meta, int cooked_meta, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 4, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        String _main = "ingredientKebabMain";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
        raw_kebab.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)raw_kebab, (ItemStack)kebab, (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    private static final void addFKebabs(int raw_meta, int cooked_meta, List<ItemStack> instances, VfpConfig config) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 2, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vv", "xs", Character.valueOf('v'), "ingredientKebabFruit", Character.valueOf('x'), "ingredientSweetener", Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
        if (config.isPresent("mini_fruit")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vvv", "vvv", "xs ", Character.valueOf('v'), "ingredientKebabMiniFruit", Character.valueOf('x'), "ingredientSweetener", Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
        }
        raw_kebab.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)raw_kebab, (ItemStack)kebab, (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    private static final void addAKebabs(int raw_meta, int cooked_meta, List<ItemStack> instances) {
        ItemStack raw_kebab = new ItemStack((Item)INSTANCE, 4, raw_meta);
        ItemStack kebab = new ItemStack((Item)INSTANCE, 1, cooked_meta);
        String _main = "ingredientKebabAdventure";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vv", "cS", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('c'), FoodPowders.get(FoodPowders.Type.CACTUS, 1), Character.valueOf('S'), "portionSaltSmall", Character.valueOf('m'), _main, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
        raw_kebab.field_77994_a = 1;
        GameRegistry.addSmelting((ItemStack)raw_kebab, (ItemStack)kebab, (float)LikeFood.uncooked_kebab.smeltExperience());
        instances.add(raw_kebab);
        instances.add(kebab);
    }

    static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null) {
            Kebabs.get();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            Kebabs.addMKebabs(0, 1, new PackagedFood[]{PackagedFood.BEEF, PackagedFood.MUTTON}, false, instances);
            Kebabs.addMKebabs(2, 3, new PackagedFood[]{PackagedFood.CHICKEN}, false, instances);
            Kebabs.addMKebabs(4, 5, new PackagedFood[]{PackagedFood.CODFISH, PackagedFood.SALMON}, true, instances);
            Kebabs.addVKebabs(6, 7, instances);
            Kebabs.addFKebabs(8, 9, instances, config);
            Kebabs.addAKebabs(10, 11, instances);
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> allButAdventure = new ArrayList<ItemStack>();
        for (int i = 0; i < TYPED_INSTANCES.length; i += 2) {
            if (i == 10) continue;
            allButAdventure.add(TYPED_INSTANCES[1]);
        }
        return allButAdventure;
    }

    public static final ItemStack meat() {
        return TYPED_INSTANCES == null ? new ItemStack(VfpObj.Eek_obj) : TYPED_INSTANCES[1].func_77946_l();
    }

    public static final ItemStack adventure() {
        return TYPED_INSTANCES == null ? new ItemStack(VfpObj.Eek_obj) : TYPED_INSTANCES[11].func_77946_l();
    }
}

