/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JJJJar;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpStew;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.eggs.EggPies;
import org.jwaresoftware.mcmods.vfp.meats.BattyExtensions;
import org.jwaresoftware.mcmods.vfp.meats.FlintButcherAxe;
import org.jwaresoftware.mcmods.vfp.meats.HorseItems;
import org.jwaresoftware.mcmods.vfp.meats.Kebabs;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;
import org.jwaresoftware.mcmods.vfp.meats.MobDrops;
import org.jwaresoftware.mcmods.vfp.meats.Nuggets;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.meats.WolfItems;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

public class MeatExtrasBuildHelper
extends VfpBuildHelperSupport {
    private BattyExtensions _battyHelper = new BattyExtensions();
    private HorseItems _horseHelper = new HorseItems();
    private WolfItems _wolfHelper = new WolfItems();
    private static String _butcherToolId = "Butcher Knife";

    @Override
    protected String categoryName() {
        return "MeatExtras";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        MobDrops.ForgeDropEventHandler eventHandler = MobDrops.ForgeDropEventHandler.init(runtime.getConfig());
        if (eventHandler != null) {
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        }
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        OreDictionary.registerOre((String)"foodSandwich", (ItemStack)DoughBallType.cookedMeat(1));
        VfpObj.Flint_Butcher_Axe_obj = new FlintButcherAxe(VfpOid.Flint_Butcher_Axe).autoregister();
        VfpObj.Skewers_Wood_obj = VfpBuilder.newItem(VfpOid.Skewers_Wood);
        VfpObj.Small_Bone_obj = VfpBuilder.newMisc(VfpOid.Small_Bone);
        VfpObj.Gelatin_Ball_obj = VfpBuilder.newMisc(VfpOid.Gelatin_Ball);
        VfpObj.Broth_Jar_obj = JJJJar.newJar(VfpOid.Broth_Jar, "portionBroth");
        VfpObj.Salt_Pork_obj = VfpBuilder.newFood(VfpOid.Salt_Pork, LikeFood.uncooked_salt_pork);
        VfpObj.Cooked_Salt_Pork_obj = VfpBuilder.newFood(VfpOid.Cooked_Salt_Pork, LikeFood.salt_pork);
        VfpObj.Salt_Fish_obj = VfpBuilder.newFood(VfpOid.Cod_Salted, LikeFood.salt_fish_portion);
        VfpObj.Ham_Egg_Sandwich_obj = VfpBuilder.newFood(VfpOid.Ham_Egg_Sandwich, LikeFood.hamegg_sandwich);
        VfpObj.Other_Pork_Meats_obj = PigMeats.get();
        VfpObj.Ham_Hocks_Stew_obj = VfpStew.newStew(VfpOid.Ham_Hocks_Stew, LikeFood.meat_stew);
        this._battyHelper.doBuildPrimaryObjects(event, runtime);
        this._horseHelper.doBuildPrimaryObjects(event, runtime);
        this._wolfHelper.doBuildPrimaryObjects(event, runtime);
        String _idid = "butcher.ironsword.marker.text";
        String s = StatCollector.func_74838_a((String)"butcher.ironsword.marker.text");
        if (!"butcher.ironsword.marker.text".equals(s) && !StringUtils.isWhitespace((CharSequence)s)) {
            _butcherToolId = s;
        }
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Meat_Portions_obj = MeatPortions.get();
        VfpObj.Portion_Jerky_obj = VfpBuilder.newFood(VfpOid.Portion_Jerky, LikeFood.meat_portion);
        VfpObj.Portion_Ham_obj = VfpBuilder.newFood(VfpOid.Portion_Ham, LikeFood.meat_portion);
        MeatPortions.registerSourcesUnder("foodGoodMeat");
        this._battyHelper.doBuildSecondaryObjects(event, runtime);
        this._horseHelper.doBuildSecondaryObjects(event, runtime);
        this._wolfHelper.doBuildSecondaryObjects(event, runtime);
        VfpObj.Egg_Pies_obj = EggPies.get();
        VfpObj.Kebabs_obj = Kebabs.get();
        VfpObj.Nuggets_obj = Nuggets.get();
    }

    @Override
    public void doInitLikeFoods(FMLStateEvent event, VfpRuntime runtime) {
        LikeFood.uncooked_meat_portion.food().item(MeatPortions.get(PackagedFood.BEEF));
        LikeFood.meat_portion.food().item(VfpObj.Portion_Jerky_obj);
        LikeFood.salt_pork.food().item(VfpObj.Cooked_Salt_Pork_obj);
        LikeFood.uncooked_salt_pork.food().item(VfpObj.Salt_Pork_obj);
        LikeFood.hamegg_sandwich.food().item(VfpObj.Ham_Egg_Sandwich_obj);
        LikeFood.meat_stew.food().item(VfpObj.Ham_Hocks_Stew_obj);
        LikeFood.salt_fish_portion.food().item(VfpObj.Salt_Fish_obj);
        this._battyHelper.doInitLikeFoods(event, runtime);
        this._horseHelper.doInitLikeFoods(event, runtime);
        this._wolfHelper.doInitLikeFoods(event, runtime);
    }

    @Override
    public void doBuildRecipes(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Flint_Butcher_Axe_obj), new Object[]{"xx", "xw", "x ", Character.valueOf('x'), "itemRawFlint", Character.valueOf('w'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Skewers_Wood_obj, 4), new Object[]{"stickWood", "stickWood", "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Broth_Jar_obj, 2, 3), new Object[]{"MM ", "Wh ", "jj ", Character.valueOf('M'), "foodGoodMeat", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('j'), VfpObj.Empty_Jar_obj}));
        MeatPortions.autorecipe(VfpObj.Portion_Jerky_obj);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Salt_Pork_obj), new Object[]{".s.", "sps", ".s.", Character.valueOf('p'), Items.field_151147_al, Character.valueOf('s'), "ingredientSalt"}));
        GameRegistry.addSmelting((Item)VfpObj.Salt_Pork_obj, (ItemStack)new ItemStack(VfpObj.Cooked_Salt_Pork_obj), (float)LikeFood.uncooked_salt_pork.smeltExperience());
        PigMeats.autorecipe(config);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Ham_Hocks_Stew_obj, 3), new Object[]{"hhd", "cpW", "bbb", Character.valueOf('h'), PigMeats.smoked_hocks(1), Character.valueOf('d'), DoughBallType.plain(1), Character.valueOf('c'), Items.field_151172_bF, Character.valueOf('p'), Items.field_151168_bH, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), Items.field_151054_z}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Portion_Ham_obj, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{VfpObj.Cooked_Salt_Pork_obj, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Salt_Fish_obj, 4), new Object[]{".s.", "sFs", ".s.", Character.valueOf('F'), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), Character.valueOf('s'), "ingredientSalt"}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Small_Bone_obj, 2), (Object[])new Object[]{Items.field_151076_bf, VfpObj.Drying_Agent_obj});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Small_Bone_obj, 2), (Object[])new Object[]{Items.field_179558_bo, VfpObj.Drying_Agent_obj});
        GameRegistry.addShapelessRecipe((ItemStack)VfpObj.Bonemeal_obj, (Object[])new Object[]{VfpObj.Small_Bone_obj, VfpObj.Small_Bone_obj});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151103_aS), new Object[]{"III", "III", Character.valueOf('I'), VfpObj.Small_Bone_obj}));
        ItemStack gelatin_powder = FoodPowders.get(FoodPowders.Type.GELATIN, 1);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gelatin_powder, new Object[]{"III", "Whd", Character.valueOf('I'), VfpObj.Small_Bone_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('d'), "additiveDrying"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(VfpObj.Gelatin_Ball_obj, new Object[]{gelatin_powder, gelatin_powder, "itemWaterBottle"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(DoughBallType.meat(2), new Object[]{"foodDough", "portionMeat", "portionMeat", Items.field_151168_bH}));
        GameRegistry.addSmelting((ItemStack)DoughBallType.meat(1), (ItemStack)DoughBallType.cookedMeat(1), (float)LikeFood.mini_pie.smeltExperience());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Ham_Egg_Sandwich_obj, VfpCapacity.SANDWICH_BATCH.count()), new Object[]{"eee", "hb ", Character.valueOf('e'), "foodEggFried", Character.valueOf('h'), VfpObj.Cooked_Salt_Pork_obj, Character.valueOf('b'), "foodBreadSandwich"}));
        this._battyHelper.doBuildRecipes(event, runtime);
        this._horseHelper.doBuildRecipes(event, runtime);
        this._wolfHelper.doBuildRecipes(event, runtime);
        EggPies.autorecipe(config);
        Kebabs.autorecipe(config);
        Nuggets.autorecipe(config);
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        List<ItemStack> nugget_combos = Nuggets.achievementCandidates();
        VfpRewards.addRewardingCraftItem(VfpObj.Portion_Ham_obj, VfpAchievements.Id.PortionInTime);
        for (ItemStack portion : MeatPortions.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(portion, VfpAchievements.Id.PortionInTime);
        }
        VfpRewards.addRewardingCraftItem(VfpObj.Flint_Butcher_Axe_obj, VfpAchievements.Id.GetTheMeats);
        for (ItemStack combo : nugget_combos) {
            VfpRewards.addRewardingCraftItem(combo, VfpAchievements.Id.FingerFoodie);
        }
        VfpRewards.addRewardingCraftItem(PigMeats.smoked_hocks(1), VfpAchievements.Id.NewWorldsOfTaste);
        VfpRewards.addRewardingCraftItem(VfpObj.Ham_Hocks_Stew_obj, VfpAchievements.Id.NowYoureCooking);
        for (ItemStack kebab : Kebabs.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(kebab, VfpAchievements.Id.GrillMeister);
        }
        VfpRewards.addRewardingCraftItem(Kebabs.adventure(), VfpAchievements.Id.BraveStomach);
        VfpRewards.addRewardingCraftItem(VfpObj.Wolf_Spirit_obj, VfpAchievements.Id.NoFriendOfMan);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            JJJJar broth = (JJJJar)VfpObj.Broth_Jar_obj;
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Skewers_Wood, VfpObj.Skewers_Wood_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flint_Butcher_Axe, VfpObj.Flint_Butcher_Axe_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Small_Bone, VfpObj.Small_Bone_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Gelatin_Ball, VfpObj.Gelatin_Ball_obj);
            runtime.doRenderSetupOrFail(VfpOid.Broth_Jar, broth, broth.getUsesRenderNames(), broth.getUsesRenderMetas());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Meat_Portion, VfpObj.Meat_Portions_obj, MeatPortions.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Jerky, VfpObj.Portion_Jerky_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Ham, VfpObj.Portion_Ham_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Salt_Pork, VfpObj.Salt_Pork_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cooked_Salt_Pork, VfpObj.Cooked_Salt_Pork_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cod_Salted, VfpObj.Salt_Fish_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Ham_Egg_Sandwich, VfpObj.Ham_Egg_Sandwich_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Pork_Meat_Product, VfpObj.Other_Pork_Meats_obj, PigMeats.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Ham_Hocks_Stew, VfpObj.Ham_Hocks_Stew_obj);
        }
        this._battyHelper.doFinish(event, runtime);
        this._horseHelper.doFinish(event, runtime);
        this._wolfHelper.doFinish(event, runtime);
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Egg_Pie, VfpObj.Egg_Pies_obj, EggPies.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Kebab, VfpObj.Kebabs_obj, Kebabs.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Nuggets, VfpObj.Nuggets_obj, Nuggets.variants());
        }
    }

    public static final boolean isUsingButcheringTool(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack with;
        DamageSource attacksource = event.source;
        if (attacksource instanceof EntityDamageSource && ((EntityDamageSource)attacksource).func_76346_g() instanceof EntityPlayer && (with = (player = (EntityPlayer)((EntityDamageSource)attacksource).func_76346_g()).func_70694_bm()) != null) {
            if (with.func_77973_b() instanceof FlintButcherAxe) {
                return true;
            }
            if (with.func_77973_b() == Items.field_151040_l && with.func_82833_r().contains(_butcherToolId)) {
                return true;
            }
        }
        return false;
    }
}

