/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;

public final class MobDrops {

    public static final class ForgeDropEventHandler {
        static ForgeDropEventHandler INSTANCE;
        private final boolean _flintDrops;
        private final boolean _batDrops;
        private final boolean _pigDrops;
        private final boolean _horseDrops;
        private final boolean _wolfDrops;
        private final boolean _skipHorseMeat;
        private final boolean _skipWolfMeat;
        private final boolean _livingDrops;
        private final boolean _moreMeat;
        private final boolean _skipBones;

        public static final ForgeDropEventHandler init(VfpConfig config) {
            if (INSTANCE == null) {
                INSTANCE = new ForgeDropEventHandler(config);
            }
            return INSTANCE.isEnabled() ? INSTANCE : null;
        }

        private ForgeDropEventHandler(VfpConfig config) {
            this._flintDrops = config.isSuperCompatibilityMode() || config.alwaysIncludeRedFlintDrops();
            this._batDrops = config.includeBatDrops();
            this._pigDrops = config.includePigDrops();
            this._wolfDrops = config.includeWolfDrops();
            this._horseDrops = config.includeHorseDrops();
            this._skipHorseMeat = config.excludeHorseMeatDrops();
            this._skipWolfMeat = config.excludeWolfMeatDrops();
            this._moreMeat = config.increaseMeatDrops();
            this._skipBones = config.isPresent("bone_drops");
            this._livingDrops = this._batDrops || this._pigDrops || this._horseDrops || this._wolfDrops || this._moreMeat;
        }

        final boolean isEnabled() {
            return this._livingDrops || this._flintDrops;
        }

        @SubscribeEvent
        public void onLivingDrops(LivingDropsEvent event) {
            if (!this._livingDrops) {
                return;
            }
            EntityLivingBase entity = event.entityLiving;
            World world = entity.field_70170_p;
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobLoot")) {
                boolean all = MeatExtrasBuildHelper.isUsingButcheringTool(event);
                boolean onFire = entity.func_70027_ad();
                boolean done = false;
                if (this._batDrops) {
                    done = this.doBatDrops(event, world, entity, all, onFire);
                }
                if (!done && this._horseDrops) {
                    done = this.doHorseDrops(event, world, entity, all, onFire);
                }
                if (!done && this._wolfDrops) {
                    done = this.doWolfDrops(event, world, entity, all, onFire);
                }
                if (!done) {
                    if (this._pigDrops) {
                        done = this.doPigDrops(event, world, entity, all, onFire);
                    }
                    if (this._moreMeat) {
                        done = this.upsizeDrops(event, world, entity, all, onFire);
                    }
                }
            }
        }

        private int countDrops(LivingDropsEvent event, boolean first, Item ... items) {
            int n = 0;
            for (EntityItem e : event.drops) {
                ItemStack drop = e.func_92059_d();
                for (Item item : items) {
                    if (drop.func_77973_b() != item) continue;
                    ++n;
                    if (!first) continue;
                    return n;
                }
            }
            return n;
        }

        private boolean upsizeDrops(LivingDropsEvent event, World world, EntityLivingBase entity, boolean all, boolean onFire) {
            if (!entity.func_70631_g_()) {
                Class<?> entityClass;
                int bonus_count = world.field_73012_v.nextInt(2);
                int bonus_bones = 0;
                if (!this._skipBones) {
                    bonus_bones = this.countDrops(event, false, Items.field_151103_aS);
                    bonus_bones = bonus_bones > 1 || !all && event.lootingLevel <= 0 ? 0 : bonus_count;
                }
                if ((entityClass = entity.getClass()) == EntityCow.class || entityClass == EntityMooshroom.class) {
                    int hide_count;
                    int min_meat = (all ? 5 : 2) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, Items.field_151082_bd, Items.field_151083_be);
                    if (meat_count < min_meat) {
                        entity.func_145779_a(onFire ? Items.field_151083_be : Items.field_151082_bd, min_meat - meat_count);
                    }
                    if (all && (hide_count = this.countDrops(event, true, Items.field_151116_aA)) == 0) {
                        entity.func_145779_a(Items.field_151116_aA, 1);
                    }
                    if (bonus_bones > 0) {
                        entity.func_145779_a(Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityPig.class) {
                    int min_meat = (all ? 2 : 1) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, Items.field_151147_al, Items.field_151157_am);
                    if (meat_count < min_meat) {
                        entity.func_145779_a(onFire ? Items.field_151157_am : Items.field_151147_al, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        entity.func_145779_a(Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntitySheep.class) {
                    int min_meat = (all ? 2 : 1) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, Items.field_179561_bm, Items.field_179557_bn);
                    if (meat_count < min_meat) {
                        entity.func_145779_a(onFire ? Items.field_179557_bn : Items.field_179561_bm, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        entity.func_145779_a(Items.field_151103_aS, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityRabbit.class) {
                    int hide_count;
                    int meat_count = this.countDrops(event, true, Items.field_179558_bo, Items.field_179559_bp);
                    if (meat_count == 0) {
                        entity.func_145779_a(onFire ? Items.field_179559_bp : Items.field_179558_bo, 1);
                    }
                    if (all && (hide_count = this.countDrops(event, true, Items.field_179555_bs)) == 0) {
                        entity.func_145779_a(Items.field_179555_bs, 1);
                    }
                    if (bonus_bones > 0) {
                        entity.func_145779_a(VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityChicken.class) {
                    int feather_count;
                    if (bonus_bones > 0) {
                        entity.func_145779_a(VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    if (all && (feather_count = this.countDrops(event, false, Items.field_151008_G)) < 2) {
                        entity.func_145779_a(Items.field_151008_G, 2 - feather_count);
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean doBatDrops(LivingDropsEvent event, World world, EntityLivingBase entity, boolean all, boolean onFire) {
            boolean mine = entity instanceof EntityBat;
            if (mine) {
                int n;
                int n2 = n = event.lootingLevel > 0 || all ? 2 : 1;
                if (!onFire) {
                    boolean bonus;
                    entity.func_145779_a(VfpObj.Bat_Poop_obj, n + world.field_73012_v.nextInt(3));
                    entity.func_145779_a(VfpObj.Bat_Raw_obj, n + world.field_73012_v.nextInt(4));
                    entity.func_145779_a(VfpObj.Small_Bone_obj, world.field_73012_v.nextInt(2));
                    boolean bl = all ? true : (bonus = world.field_73012_v.nextInt(12) == 0);
                    if (bonus) {
                        EntityDamageSource e;
                        entity.func_145779_a(VfpObj.Bat_Sonar_Sac_obj, 1);
                        if (!all && event.source instanceof EntityDamageSource && (e = (EntityDamageSource)event.source).func_76346_g() instanceof EntityPlayer) {
                            VfpAchievements.triggerAchievement((EntityPlayer)e.func_76346_g(), VfpAchievements.Id.BatSplat);
                        }
                    }
                } else {
                    entity.func_145779_a(VfpObj.Bat_Cooked_obj, n);
                    entity.func_145779_a(VfpObj.Bat_Poop_obj, world.field_73012_v.nextInt(3));
                }
            }
            return mine;
        }

        private boolean doPigDrops(LivingDropsEvent event, World world, EntityLivingBase entity, boolean all, boolean onFire) {
            boolean mine = entity instanceof EntityPig;
            if (mine) {
                int n;
                int n2 = n = event.lootingLevel > 0 || all ? 2 : 1;
                if (!entity.func_70631_g_()) {
                    if (onFire) {
                        entity.func_70099_a(PigMeats.smoked_hocks(n + world.field_73012_v.nextInt(2)), 0.0f);
                    } else {
                        entity.func_70099_a(PigMeats.hocks(n + world.field_73012_v.nextInt(2)), 0.0f);
                        entity.func_70099_a(PigMeats.pigtail(all ? 1 : world.field_73012_v.nextInt(2)), 0.0f);
                    }
                }
            }
            return mine;
        }

        private boolean doHorseDrops(LivingDropsEvent event, World world, EntityLivingBase entity, boolean all, boolean onFire) {
            boolean mine = entity instanceof EntityHorse;
            if (!onFire && mine) {
                int n;
                boolean uncommonDrop;
                EntityHorse horse = (EntityHorse)entity;
                if (!MinecraftGlue.isLivingHorseOrMuleOrDonkey(horse)) {
                    return mine;
                }
                boolean isAdult = !horse.func_70631_g_();
                boolean bl = uncommonDrop = world.field_73012_v.nextInt(12) == 0;
                if (isAdult && horse.func_110265_bP() == MinecraftGlue.PLAIN_HORSE_TYPE() && (all || uncommonDrop)) {
                    n = 1;
                    if (event.lootingLevel > 0) {
                        ++n;
                    }
                    entity.func_145779_a(VfpObj.Horse_Tear_obj, n);
                }
                if (isAdult) {
                    if (all || world.field_73012_v.nextInt(4) == 0) {
                        n = all || event.lootingLevel > 0 ? 2 : 1;
                        entity.func_145779_a(VfpObj.Horse_Hoof_obj, n);
                    }
                    if (uncommonDrop) {
                        entity.func_145779_a(VfpObj.Horse_Sweat_obj, 1);
                    }
                }
                if (!this._skipHorseMeat) {
                    if (!isAdult) {
                        entity.func_145779_a(VfpObj.Horse_Raw_obj, 1);
                    } else {
                        int n2;
                        boolean bonanza = event.lootingLevel > 0 || all;
                        int n3 = n2 = bonanza ? 3 : 1;
                        if (all) {
                            ++n2;
                        }
                        entity.func_145779_a(VfpObj.Horse_Raw_obj, n2 + world.field_73012_v.nextInt(3));
                        if (bonanza && !this._skipBones) {
                            entity.func_145779_a(Items.field_151103_aS, 2 + world.field_73012_v.nextInt(2));
                        }
                    }
                }
            }
            return mine;
        }

        private boolean doWolfDrops(LivingDropsEvent event, World world, EntityLivingBase entity, boolean all, boolean onFire) {
            boolean mine = entity instanceof EntityWolf;
            if (mine) {
                boolean uncommonDrop;
                int n = event.lootingLevel > 0 || all ? 3 : 2;
                boolean bl = uncommonDrop = world.field_73012_v.nextInt(12) == 0;
                if (!entity.func_70631_g_()) {
                    if (!this._skipWolfMeat) {
                        if (onFire) {
                            entity.func_145779_a(VfpObj.Wolf_Cooked_obj, n + world.field_73012_v.nextInt(2));
                        } else {
                            entity.func_145779_a(VfpObj.Wolf_Raw_obj, n + world.field_73012_v.nextInt(2));
                        }
                    }
                    if (uncommonDrop) {
                        entity.func_70099_a(WolfsSpiritElement.random(1, world.field_73012_v), 0.0f);
                    }
                    if (!this._skipWolfMeat && !this._skipBones) {
                        entity.func_145779_a(VfpObj.Small_Bone_obj, --n);
                    }
                }
            }
            return mine;
        }

        @SubscribeEvent
        public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
            Block block;
            if (!this._flintDrops) {
                return;
            }
            World world = event.world;
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !event.isSilkTouching && (block = event.state.func_177230_c()) instanceof BlockGravel) {
                int fortune = event.fortuneLevel;
                if (fortune > 3) {
                    fortune = 3;
                }
                if (world.field_73012_v.nextInt(14 - fortune * 3) == 0) {
                    int j = 1;
                    if (fortune >= 2) {
                        ++j;
                    }
                    event.drops.add(new ItemStack(VfpObj.Red_Flint_obj, j));
                }
            }
        }
    }
}

