/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class MilkDrinks
extends VfpLiquidMultiItem {
    private static final int WHITE_MILKDRINK_COLOR = MapColor.field_151666_j.field_76291_p;
    private static final int CREAM_MILKDRINK_COLOR = 16775636;
    private static final int CHOCO_MILKDRINK_COLOR = MapColor.field_151650_B.field_76291_p;
    private static final int BERRY_MILKDRINK_COLOR = MapColor.field_151671_v.field_76291_p;
    private static final int _PLAIN = 0;
    private static final int _HEAVY = 1;
    private static final int _FIRST_CUSTOM = 2;
    private static int _CHOCO;
    private static final int _REGENX = 1;
    private static final int _MUSCLE = 16;
    private static final List<Ingredient> VARIANT_FLAVORS;
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static MilkDrinks INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a milky drink", (Object[])new Object[0]);
        if (flavor.id() == 0 || flavor.id() == 1) {
            return false;
        }
        return MilkDrinks.register(flavor, VARIANT_FLAVORS, "milky drinks");
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null food powder is required for a milky drink", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowders.Type.CACTUS ? "klingon" : (flavor == FoodPowders.Type.CREAM ? "sweet" : flavor.name().toLowerCase());
        Ingredient ingredient = FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, name);
        boolean done = MilkDrinks.register(ingredient, VARIANT_FLAVORS, "milky drinks");
        if (done) {
            if (flavor == FoodPowders.Type.MUSCLE) {
                ingredient.attributes(17);
            } else if (flavor == FoodPowders.Type.COCOA) {
                _CHOCO = ingredient.id();
            }
        }
        return done;
    }

    public MilkDrinks(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
        this.func_77848_i();
        if (VfpConfig.getInstance().ignoreMagicalEmptiesBug()) {
            this.func_77642_a(VfpObj.Our_Empty_Bottle_obj);
        }
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null && type != null) {
            colorValue = ingredient.name().contains("erry") ? Integer.valueOf(BERRY_MILKDRINK_COLOR) : Integer.valueOf(16775636);
        }
        return colorValue;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorFromMeta(int meta, int renderPass) {
        if (meta == 0) {
            return WHITE_MILKDRINK_COLOR;
        }
        if (meta == 1) {
            return 16775636;
        }
        if (meta == _CHOCO) {
            return CHOCO_MILKDRINK_COLOR;
        }
        return super.getColorFromMeta(meta, renderPass);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        boolean has_muscle_effect = false;
        boolean has_regenx_effect = false;
        if (!world.field_72995_K) {
            Ingredient ingredient = VfpVariant.byItemStack(stack, this._variant_default).datadata(Ingredient.class);
            has_regenx_effect = (ingredient.attributes() & 1) == 1;
            has_muscle_effect = (ingredient.attributes() & 0x10) == 16;
            MinecraftGlue.cureBadPotionEffectsWithMilk(player, has_muscle_effect);
        }
        super.func_77849_c(stack, world, player);
        if (has_regenx_effect) {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 3600, 1));
        }
        if (has_muscle_effect) {
            MinecraftGlue.giveGoodPotionEffectWithMuscle(player, -1);
        }
    }

    private static final LikeFood like(Ingredient ingredient) {
        if (ingredient.id() == 0) {
            return LikeFood.milk;
        }
        if (ingredient.id() == 1) {
            return LikeFood.cream;
        }
        String name = ingredient.name().toUpperCase();
        LikeFood baseline = LikeFood.sweet_milk;
        if (FoodPowders.Type.CREAM.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.cream);
        }
        if (FoodPowders.Type.MUSCLE.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.muscle_boost);
        }
        if (FoodPowders.Type.APPLE.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.apple);
        }
        if (FoodPowders.Type.PUMPKIN.name().equals(name)) {
            return new LikeFood(-1, baseline, LikeFood.melon_slice);
        }
        return baseline;
    }

    public static final synchronized MilkDrinks get() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(19);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                LikeFood food = MilkDrinks.like(ingredient);
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, food, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.MilkDrink, MilkDrinks.class, VfpBuilder.User.INTERNAL);
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_milk_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_milk_drink);
            }
        }
        return INSTANCE;
    }

    static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && MilkDrinks.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(19);
            ItemStack plain_milk = new ItemStack((Item)INSTANCE, 1, 0);
            ItemStack milk_powder = FoodPowders.get(FoodPowders.Type.MILK, 1);
            ItemStack a_milk_drink = plain_milk.func_77946_l();
            instances.add(a_milk_drink.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(a_milk_drink.func_77946_l(), new Object[]{milk_powder, "itemWaterBottle"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(a_milk_drink.func_77946_l(), new Object[]{"xxx", "xbx", "xxx", Character.valueOf('x'), "portionMilkSmall", Character.valueOf('b'), "itemEmptyBottle"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Milk_Portion_obj, VfpCapacity.BOTTLE.count()), (Object[])new Object[]{a_milk_drink.func_77946_l()});
            a_milk_drink.field_77994_a = VfpCapacity.BUCKET.count() / VfpCapacity.BOTTLE.count();
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(a_milk_drink, new Object[]{"X  ", "bb ", "bb ", Character.valueOf('X'), "portionMilkLarge", Character.valueOf('b'), "itemEmptyBottle"}));
            a_milk_drink = new ItemStack((Item)INSTANCE, 1, 1);
            instances.add(a_milk_drink.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(a_milk_drink.func_77946_l(), new Object[]{FoodPowders.get(FoodPowders.Type.CREAM, 1), "itemWaterBottle"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(a_milk_drink.func_77946_l(), new Object[]{milk_powder, milk_powder, "itemWaterBottle"}));
            a_milk_drink.field_77994_a = 2;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(a_milk_drink.func_77946_l(), new Object[]{"X ", "bb", Character.valueOf('X'), "portionMilkLarge", Character.valueOf('b'), "itemEmptyBottle"}));
            a_milk_drink.field_77994_a = 1;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(a_milk_drink.func_77946_l(), new Object[]{"xxx", "xbx", "xxx", Character.valueOf('x'), "portionMilkSmall", Character.valueOf('b'), plain_milk}));
            for (int i = 2; i < VARIANT_ARRAY.length; ++i) {
                Ingredient ingredient = VARIANT_ARRAY[i].datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                a_milk_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                String recipeitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(a_milk_drink, new Object[]{"ss", "ib", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('i'), recipeitem, Character.valueOf('b'), plain_milk}));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack plain(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 0);
    }

    public static final ItemStack heavy(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 1);
    }

    public static final ItemStack other(int id, int amount) {
        for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
            Ingredient ingredient = VARIANT_ARRAY[i].datadata(Ingredient.class);
            if (ingredient.id() != id) continue;
            return new ItemStack((Item)INSTANCE, amount, ingredient.id());
        }
        return null;
    }

    public static final ItemStack other(FoodPowders.Type flavor, int amount) {
        Ingredient powder = FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, null);
        return powder == null ? null : MilkDrinks.other(powder.id(), amount);
    }

    static {
        VARIANT_FLAVORS = new ArrayList<Ingredient>();
        Ingredient plain_milk = new Ingredient("plain", 0, new ItemStack(Items.field_151124_az));
        plain_milk.attributes(1);
        VARIANT_FLAVORS.add(plain_milk);
        Ingredient heavy_milk = new Ingredient("heavy", 1, new ItemStack(Items.field_151143_au));
        heavy_milk.attributes(1);
        VARIANT_FLAVORS.add(heavy_milk);
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.MilkDrink, (Class)MilkDrinks.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

