/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Gelos
extends VfpPantryMultiItem {
    private static final LikeFood sugarbomb = new LikeFood(0, LikeFood.sugar, LikeFood.sugar);
    private static final List<Ingredient> VARIANT_INGREDIENTS = new ArrayList<Ingredient>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Gelos INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null ingredient is required for an edible gelo", (Object[])new Object[0]);
        boolean added = false;
        if (!VARIANT_INGREDIENTS.contains(ingredient)) {
            VARIANT_INGREDIENTS.add(ingredient);
            added = true;
        }
        return added;
    }

    public static final synchronized boolean register(String geloName, int id, Item ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null gelo flavoring ingredient is required", (Object[])new Object[0]);
        return Gelos.register(new Ingredient(geloName, id, new ItemStack(ingredient)));
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for an edible gelo", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowders.Type.CARROT ? "orange" : (flavor == FoodPowders.Type.DANDELION ? "dandy" : (flavor == FoodPowders.Type.POPPY ? "poppy" : (flavor == FoodPowders.Type.CACTUS ? "klingon" : (flavor == FoodPowders.Type.INK ? "midnight" : (flavor == FoodPowders.Type.SYRUP ? "sugarbomb" : flavor.name().toLowerCase())))));
        return Gelos.register(FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, name));
    }

    public static final void validState() {
        Validate.validState((VARIANT_ARRAY != null ? 1 : 0) != 0, (String)"Edible gelos variant array not allocated?", (Object[])new Object[0]);
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"Edible gelos singleton not allocated (no ingredient registered)", (Object[])new Object[0]);
    }

    public Gelos(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    public static final synchronized Gelos get() {
        if (INSTANCE == null && VARIANT_INGREDIENTS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(31);
            String basename = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                String fmlid = basename + "_" + ingredient.name().toLowerCase();
                LikeFood like = ingredient.recipeitem().func_77973_b() == VfpObj.Sugar_obj ? sugarbomb : LikeFood.sugar;
                variants.add(new VfpTransientVariant(ingredient.id(), fmlid, like, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Gelo, Gelos.class, VfpBuilder.User.INTERNAL);
            Gelos.validState();
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_gelo = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodJello", (ItemStack)a_gelo);
            }
        }
        return INSTANCE;
    }

    public static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && Gelos.get() != null) {
            ItemStack gel_powder = FoodPowders.get(FoodPowders.Type.GELATIN, 1);
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(31);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                VfpVariant variant = VARIANT_ARRAY[i];
                Ingredient ingredient = variant.datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack gelo_ball = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                Object ingredient_obj = ingredient.recipeitem();
                if (ingredient.isClassifier()) {
                    ingredient_obj = ingredient.recipeitemName();
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gelo_ball, new Object[]{"gs", "Iw", Character.valueOf('g'), gel_powder, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('I'), ingredient_obj, Character.valueOf('w'), "portionWater"}));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Gelo, (Class)Gelos.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

