/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftOnlyItem;
import org.jwaresoftware.mcmods.vfp.common.VfpFertilizerItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.misc.Gelos;
import org.jwaresoftware.mcmods.vfp.misc.Juices;
import org.jwaresoftware.mcmods.vfp.misc.Migration;
import org.jwaresoftware.mcmods.vfp.misc.RoastedSeeds;
import org.jwaresoftware.mcmods.vfp.misc.StewedItems;
import org.jwaresoftware.mcmods.vfp.misc.VfpCutterItem;
import org.jwaresoftware.mcmods.vfp.sugar.FizzyDrinks;
import org.jwaresoftware.mcmods.vfp.sugar.SimpleCookies;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

public final class MiscBuildHelper
extends VfpBuildHelperSupport {
    private static final int FLINT_CUTTER_USES = 16;

    @Override
    protected String categoryName() {
        return "Miscellaneous";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Red_Flint_obj = VfpBuilder.newItem(VfpOid.Red_Flint);
        OreDictionary.registerOre((String)"itemRawFlint", (Item)Items.field_151145_ak);
        OreDictionary.registerOre((String)"itemRawFlint", (Item)VfpObj.Red_Flint_obj);
        VfpCutterItem cutter = new VfpCutterItem((VfpProfile)VfpOid.Flint_Cutter, 16).autoregister(VfpCutterItem.class);
        VfpObj.Flint_Cutter_obj = cutter;
        int[] metas = cutter.getUsesRenderMetas();
        for (int i = 0; i < metas.length; ++i) {
            ItemStack damaged = new ItemStack((Item)cutter, 1, metas[i]);
            OreDictionary.registerOre((String)"itemFoodCutter", (ItemStack)damaged);
        }
        VfpObj.Sand_Jar_obj = new VfpCraftOnlyItem((VfpProfile)VfpOid.Sand_Jar, true).autoregister();
        VfpObj.Flesh_Meal_obj = new VfpFertilizerItem(VfpOid.Flesh_Meal).autoregister();
        VfpFertilizerItem.initDispenseBehavior(VfpObj.Flesh_Meal_obj);
        VfpObj.Animal_Hide_Tie_obj = VfpBuilder.newMisc(VfpOid.Animal_Hide_Tie);
        OreDictionary.registerOre((String)"itemTieStrong", (Item)VfpObj.Animal_Hide_Tie_obj);
        VfpObj.Fire_Proofing_Powder_obj = VfpBuilder.newBrewingItem(VfpOid.Fire_Proofing_Powder, PotionHelper.field_77931_h, false);
        VfpObj.Fermented_Feather_obj = VfpBuilder.newBrewingItem(VfpOid.Fermented_Feather, PotionHelper.field_77921_e, false);
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.COCOA, SimpleCookies.COCOA_COOKIE_ID, null));
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.CACTUS, SimpleCookies.KLINGON_COOKIE_ID, "klingon"));
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isDrinkFlavor() || powder == FoodPowders.Type.CREAM || powder == FoodPowders.Type.MILK) continue;
            Gelos.register(powder);
        }
        VfpObj.Roasted_Seeds_obj = RoastedSeeds.get(runtime.getConfig());
        VfpObj.Pumpkin_Portion_obj = VfpBuilder.newPortion(VfpOid.Pumpkin_Portion);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)VfpObj.Pumpkin_Portion_obj);
        VfpObj.Roasted_Pumpkin_Portion_obj = VfpBuilder.newFood(VfpOid.Roasted_Pumpkin_Portion, LikeFood.carrot);
        VfpObj.Stewed_Items_obj = StewedItems.get();
        this.setupJuices(runtime.getConfig());
        VfpObj.Roast_Corn_obj = VfpBuilder.newFood(VfpOid.Roast_Corn, LikeFood.potato);
        VfpObj.Roasted_Eggplant_obj = VfpBuilder.newFood(VfpOid.Roasted_Eggplant, LikeFood.potato);
    }

    @Override
    public void doInitLikeFoods(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.SimpleCookies_obj = SimpleCookies.get();
        VfpObj.FizzyDrinks_obj = FizzyDrinks.get();
        VfpObj.Gelos_obj = Gelos.get();
        VfpObj.Juices_obj = Juices.get();
    }

    private void autorecipeRottenThings() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151078_bh, 3), new Object[]{"mmm", " j ", Character.valueOf('m'), "foodRedMeat", Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Flesh_Meal_obj, VfpCapacity.MAX_STACK_LCD.count()), new Object[]{"rrr", "cfw", Character.valueOf('r'), Items.field_151078_bh, Character.valueOf('c'), VfpObj.Charcoal_obj, Character.valueOf('f'), FoodPowders.get(FoodPowders.Type.FEATHER, 1), Character.valueOf('w'), "portionWaterSmall"}));
        ItemStack bonemeal = VfpObj.Bonemeal_obj.func_77946_l();
        bonemeal.field_77994_a = 6;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bonemeal, new Object[]{"xxx", "xxx", "b  ", Character.valueOf('x'), VfpObj.Flesh_Meal_obj, Character.valueOf('b'), VfpObj.Small_Bone_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fermented_Feather_obj, 3), new Object[]{"fff", "fff", "jB ", Character.valueOf('f'), Items.field_151008_G, Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151170_bI, 6), new Object[]{"ppp", "ppp", " j ", Character.valueOf('p'), Items.field_151174_bG, Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151170_bI, 2), new Object[]{"pp", "x ", Character.valueOf('p'), Items.field_151174_bG, Character.valueOf('x'), Items.field_151071_bq}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151170_bI, 2), new Object[]{"pp", "x ", Character.valueOf('p'), Items.field_151174_bG, Character.valueOf('x'), VfpObj.Fermented_Feather_obj}));
    }

    private void autorecipeVanillaStorageBlockIntegration(VfpConfig config) {
        if (config.useMushroomBlocksForPantry()) {
            VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)Blocks.field_150338_P, Blocks.field_150420_aW, (Block)Blocks.field_150338_P);
            VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)Blocks.field_150337_Q, Blocks.field_150419_aX, (Block)Blocks.field_150337_Q);
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)Blocks.field_150338_P, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{Blocks.field_150420_aW, "itemFoodCutter"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)Blocks.field_150337_Q, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{Blocks.field_150419_aX, "itemFoodCutter"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151127_ba, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{Blocks.field_150440_ba, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{Blocks.field_150423_aK, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Blocks.field_150423_aK, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), VfpObj.Pumpkin_Portion_obj}));
        ItemStack any_wool_block = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151007_F, 4), new Object[]{any_wool_block, "itemFoodCutter"}));
    }

    private void autorecipeCutterAnimalHideIntegration(VfpConfig config) {
        ItemStack flint_cutter_unused = new ItemStack(VfpObj.Flint_Cutter_obj, 1, 16);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(flint_cutter_unused, new Object[]{"x ", " x", Character.valueOf('x'), "itemRawFlint"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Animal_Hide_Tie_obj, 4), new Object[]{Items.field_151116_aA, VfpObj.Red_Flint_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Animal_Hide_Tie_obj, 1), new Object[]{Items.field_179555_bs, VfpObj.Red_Flint_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.field_151112_aM), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.field_151031_f), new Object[]{" #X", "# X", " #X", Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('#'), Items.field_151055_y}));
        Object stickiness = Items.field_151123_aH;
        if (VfpUtils.ingredientDefined("portionAdhesive")) {
            stickiness = "portionAdhesive";
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151058_ca, 2), new Object[]{"~~ ", "~O ", "  ~", Character.valueOf('~'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('O'), stickiness}));
    }

    private void autorecipeMultisourceVFPMisc(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(FoodPowders.get(FoodPowders.Type.VINEGAR, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"aaa", "aaa", "Wbd", Character.valueOf('a'), Items.field_151034_e, Character.valueOf('W'), VfpObj.Fermenting_Bucket_obj, Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(FoodPowders.get(FoodPowders.Type.POTATO_STARCH, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"ppc", "bsw", "d  ", Character.valueOf('p'), Items.field_151174_bG, Character.valueOf('c'), "itemFoodCutter", Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('s'), Blocks.field_150433_aE, Character.valueOf('w'), "portionWaterLarge", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
        ItemStack cheese_powder = FoodPowders.get(FoodPowders.Type.CHEESE, 1);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(DoughBallType.cheese(2), new Object[]{"foodDough", cheese_powder, cheese_powder}));
        GameRegistry.addSmelting((ItemStack)DoughBallType.cheese(1), (ItemStack)DoughBallType.cookedCheese(1), (float)LikeFood.mini_bread.smeltExperience());
        GameRegistry.addSmelting((Item)VfpObj.Pumpkin_Portion_obj, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj), (float)LikeFood.uncooked_carrot.smeltExperience());
        GameRegistry.addSmelting((Block)Blocks.field_150423_aK, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), (float)(LikeFood.uncooked_carrot.smeltExperience() * (float)VfpCapacity.STANDARD_BLOCK.count()));
        ItemStack bagof_eggs = BagsOf.sample(PackagedFood.EGG);
        if (bagof_eggs != null) {
            GameRegistry.addSmelting((ItemStack)bagof_eggs, (ItemStack)new ItemStack(VfpObj.Fried_Egg_obj, VfpCapacity.TRAY.count()), (float)(LikeFood.uncooked_egg.smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
        PackagedFood[] meats = new PackagedFood[]{PackagedFood.CHICKEN, PackagedFood.COOKED_CHICKEN, PackagedFood.BEEF, PackagedFood.COOKED_BEEF, PackagedFood.PORK, PackagedFood.COOKED_PORK, PackagedFood.MUTTON, PackagedFood.COOKED_MUTTON, PackagedFood.RABBIT, PackagedFood.COOKED_RABBIT};
        int n = meats.length;
        for (int i = 0; i < n; i += 2) {
            ItemStack bagof_meat = BagsOf.sample(meats[i]);
            if (bagof_meat == null) continue;
            GameRegistry.addSmelting((ItemStack)bagof_meat, (ItemStack)meats[i + 1].food().sample(VfpCapacity.TRAY.count()), (float)(meats[i].food().smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
    }

    private void autorecipeOtherSourcesOfHeat(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 10), new Object[]{new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 2 * VfpCapacity.MAX_STACK_LCD.count()), new Object[]{Items.field_151072_bj, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 2), new Object[]{"logWood", "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151072_bj), new Object[]{"H ", " H", Character.valueOf('H'), VfpObj.Lava_Sand_Portion_obj}));
    }

    private void autorecipeOtherSourcesOfWater(VfpConfig config) {
        if (config.craftOtherSourcesOfWater()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"SS ", "SS ", "B  ", Character.valueOf('S'), Blocks.field_150433_aE, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"I ", "B ", Character.valueOf('I'), Blocks.field_150432_aD, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150432_aD, 4), new Object[]{"I ", "hx", Character.valueOf('I'), Blocks.field_150403_cj, Character.valueOf('h'), "portionHeatSmall", Character.valueOf('x'), "itemFoodCutter"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151126_ay, 4), new Object[]{"S ", "x ", Character.valueOf('S'), Blocks.field_150433_aE, Character.valueOf('x'), "itemFoodCutter"}));
            if (new ItemStack(VfpObj.Water_Bottle_obj).func_77976_d() >= 4) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bottle_obj, 4), new Object[]{"I  ", "bb ", "bb ", Character.valueOf('I'), Blocks.field_150432_aD, Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bottle_obj, 4), new Object[]{"W  ", "bb ", "bb ", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
            }
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bottle_obj), new Object[]{"www", "wbw", "www", Character.valueOf('w'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
    }

    private void autorecipeNoTroubleBrewingMisc(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fire_Proofing_Powder_obj, 1), new Object[]{"In", "nn", Character.valueOf('I'), Blocks.field_150432_aD, Character.valueOf('n'), Blocks.field_150424_aL}));
    }

    @Override
    public void doBuildRecipes(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Sand_Jar_obj, 2), new Object[]{"x ", "jj", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE), Character.valueOf('j'), VfpObj.Empty_Jar_obj}));
        SimpleCookies.autorecipe();
        FizzyDrinks.autorecipe();
        Gelos.autorecipe();
        RoastedSeeds.autorecipe(config);
        Juices.autorecipe();
        StewedItems.autorecipe();
        this.autorecipeCutterAnimalHideIntegration(config);
        this.autorecipeOtherSourcesOfHeat(config);
        this.autorecipeMultisourceVFPMisc(config);
        this.autorecipeRottenThings();
        this.autorecipeVanillaStorageBlockIntegration(config);
        IntegrationsImpl.autorecipeMisc(config);
        this.autorecipeOtherSourcesOfWater(config);
        this.autorecipeNoTroubleBrewingMisc(config);
        this.setupFishedUpStuff();
        if (config.craftPantryMigrationRecipes()) {
            new Migration().doBuildRecipes(event, runtime);
        }
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(VfpObj.Pumpkin_Portion_obj, VfpAchievements.Id.PortionInTime);
        for (ItemStack stew : StewedItems.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(stew, VfpAchievements.Id.NowYoureCooking);
        }
        VfpRewards.addRewardingCraftItem(Breads.uncooked_muscle(1), VfpAchievements.Id.PowahFirstAid);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        if (!runtime.hasUI()) {
            return;
        }
        VfpCutterItem cutter = (VfpCutterItem)VfpObj.Flint_Cutter_obj;
        runtime.doRenderSetupOrFail(VfpOid.Flint_Cutter, VfpObj.Flint_Cutter_obj, cutter.getUsesRenderNames(), cutter.getUsesRenderMetas());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Red_Flint, VfpObj.Red_Flint_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Animal_Hide_Tie, VfpObj.Animal_Hide_Tie_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sand_Jar, VfpObj.Sand_Jar_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flesh_Meal, VfpObj.Flesh_Meal_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fire_Proofing_Powder, VfpObj.Fire_Proofing_Powder_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fermented_Feather, VfpObj.Fermented_Feather_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Seeds, VfpObj.Roasted_Seeds_obj, RoastedSeeds.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Pumpkin_Portion, VfpObj.Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Pumpkin_Portion, VfpObj.Roasted_Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roast_Corn, VfpObj.Roast_Corn_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Eggplant, VfpObj.Roasted_Eggplant_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Juice, VfpObj.Juices_obj, Juices.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cookie, VfpObj.SimpleCookies_obj, SimpleCookies.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.FizzyDrink, VfpObj.FizzyDrinks_obj, FizzyDrinks.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Gelo, VfpObj.Gelos_obj, Gelos.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Stewed, VfpObj.Stewed_Items_obj, StewedItems.variants());
    }

    private void setupJuices(VfpConfig config) {
        int MOD_OFFSET = 10;
        int id0 = FoodPowders.Usage.DRINK_FLAVOR.idFirst();
        Juices.register(new Juices.Flavor("apple", id0 + 0, Items.field_151034_e, null, 10974244));
        Juices.register(new Juices.Flavor("carrot", id0 + 1, Items.field_151172_bF, null, MapColor.field_151676_q.field_76291_p));
        Juices.register(new Juices.Flavor("cane", id0 + 2, Items.field_151120_aE, (Object)Items.field_151127_ba, 15189861));
        Juices.register(new Juices.Flavor("cactus", id0 + 3, new ItemStack((Block)Blocks.field_150434_aF), null, 10009467));
        if (config.includeModRecipes()) {
            int id = id0 + 10;
            String item1 = null;
            String item2 = null;
            item1 = config.getPresentAs("tomato");
            item2 = config.getPresentAs("leek");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("tomato", id, item1, (Object)item2, 12791562));
            }
            ++id;
            item1 = config.getPresentAs("grapes");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("grape", id, item1, (Object)Items.field_151034_e, 8595540));
            }
            ++id;
            item1 = config.getPresentAs("kiwi");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("kiwi", id, item1, (Object)Items.field_151127_ba, 12308059));
            }
            ++id;
            item1 = config.getPresentAs("broccoli");
            item2 = config.getPresentAs("cucumber");
            if (item1 != null && item2 != null) {
                Juices.register(new Juices.Flavor("veggies", id, item1, (Object)item2, -1));
            }
            ++id;
        }
    }

    private void setupFishedUpStuff() {
        int _JUNK = MinecraftGlue.JUNK_WEIGHT();
        FishingHooks.addJunk((WeightedRandomFishable)new WeightedRandomFishable(VfpCutterItem.junk(), _JUNK));
        if (VfpObj.Bit_Pipette_obj != null) {
            FishingHooks.addJunk((WeightedRandomFishable)new WeightedRandomFishable(new ItemStack(VfpObj.Bit_Pipette_obj), _JUNK));
        }
        if (VfpObj.Empty_Jar_obj != null) {
            FishingHooks.addJunk((WeightedRandomFishable)new WeightedRandomFishable(new ItemStack(VfpObj.Empty_Jar_obj), _JUNK));
        }
        if (VfpObj.Jungle_JuJu_Juice_obj != null) {
            FishingHooks.addTreasure((WeightedRandomFishable)new WeightedRandomFishable(JuJuExtensions.jujujuice(), MinecraftGlue.UNCOMMON_WEIGHT()));
        }
    }
}

