/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;

public final class StewedItems
extends VfpLiquidMultiItem {
    private static final int RECIPE_BATCH = 3;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Stewed, StewedItems.class, "dish");
    private static StewedItems INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public StewedItems(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
        this.func_77642_a(null);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(Items.field_151054_z);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? MinecraftGlue.I18N_ITEM_KEY_PREFIX() + variant.fmlid() : UNKNOWN_NAME;
    }

    static final synchronized StewedItems get() {
        if (INSTANCE == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(17);
            for (DishDef dishDef : DishDef.values()) {
                dishDef.install(variants, VARIANT_SET);
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Stewed, StewedItems.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static void addCombo(DishDef dishDef, ItemStack stewed_item, List<ItemStack> instances) {
        if (dishDef.addCombo()) {
            String completer = "foodBreadSandwich";
            switch (dishDef.mealCompleter()) {
                case FLATBREAD: {
                    completer = Breads.flat(1);
                    break;
                }
                case FRIES: {
                    completer = Fries.plain(1);
                }
            }
            ItemStack meal_item = new ItemStack((Item)INSTANCE, 1, dishDef.meal_meta());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(meal_item, new Object[]{stewed_item, completer}));
            instances.add(meal_item);
        }
    }

    static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null) {
            StewedItems.get();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            FoodPowders.Type herbmix = FoodPowders.findType("stew_mix");
            ItemStack herbmix_powder = herbmix != null ? FoodPowders.get(herbmix, 1) : null;
            ItemStack stewed_item = new ItemStack((Item)INSTANCE, 3, DishDef.pumpkin.meta());
            if (herbmix_powder != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Pumpkin_Portion_obj, Character.valueOf('f'), PigMeats.salted_pigtail(1), Character.valueOf('v'), "foodOnion", Character.valueOf('h'), herbmix_powder, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), Items.field_151054_z}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Pumpkin_Portion_obj, Character.valueOf('f'), PigMeats.salted_pigtail(1), Character.valueOf('v'), Items.field_151172_bF, Character.valueOf('h'), Items.field_151168_bH, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), Items.field_151054_z}));
            }
            stewed_item.field_77994_a = 1;
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.pumpkin, stewed_item, instances);
            stewed_item = new ItemStack((Item)INSTANCE, 3, DishDef.eggplant.meta());
            if (herbmix_powder != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Eggplant_obj, Character.valueOf('f'), VfpObj.Salt_Fish_obj, Character.valueOf('v'), "foodTomato", Character.valueOf('h'), herbmix_powder, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), Items.field_151054_z}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vvW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Eggplant_obj, Character.valueOf('f'), VfpObj.Salt_Fish_obj, Character.valueOf('v'), Items.field_151168_bH, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), Items.field_151054_z}));
            }
            stewed_item.field_77994_a = 1;
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.eggplant, stewed_item, instances);
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final List<ItemStack> achievementCandidates() {
        return Arrays.asList(TYPED_INSTANCES);
    }

    static enum DishDef implements Named
    {
        pumpkin(0, "pumpkin", true, Completer.FLATBREAD),
        eggplant(5, "eggplant", true, Completer.FLATBREAD);

        private final int _meta;
        private final String _id;
        private final boolean _veggie;
        private final Completer _meal_completer;

        private DishDef(int meta, String id, boolean veg, Completer addon) {
            this._meta = meta;
            this._id = id;
            this._meal_completer = addon;
            this._veggie = veg;
        }

        final int meta() {
            return this._meta;
        }

        final int meal_meta() {
            return this._meta + 1;
        }

        String fmlid() {
            return "stewed_" + this._id;
        }

        final boolean addCombo() {
            return this._meal_completer != null;
        }

        Completer mealCompleter() {
            return this._meal_completer;
        }

        final void install(List<VfpVariant> variants, VfpVariantSet variantset) {
            String fmlid = this.fmlid();
            LikeFood like = this._veggie ? LikeFood.vegetable_stew : LikeFood.meat_stew;
            variants.add(new VfpTransientVariant(this.meta(), fmlid, like, this, null, variantset));
            if (this.addCombo()) {
                fmlid = fmlid + "_combo";
                like = this._veggie ? LikeFood.vegetable_stew_meal : LikeFood.meat_stew_meal;
                variants.add(new VfpTransientVariant(this.meal_meta(), fmlid, like, this, null, variantset));
            }
        }
    }

    static enum Completer {
        RICE,
        FLATBREAD,
        PASTA,
        FRIES;

    }
}

