/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.smarthoppers.apis.IContraption;
import org.jwaresoftware.mcmods.smarthoppers.apis.IMultiuse;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

@Optional.Interface(iface="org.jwaresoftware.mcmods.smarthoppers.apis.IMultiuse", modid="smarthoppers")
public final class VfpCutterItem
extends VfpPlainItem
implements IMultiuse {
    private final int _max_uses;

    public VfpCutterItem(VfpProfile oid, int max_uses) {
        super(oid);
        this._max_uses = max_uses;
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int uses = stack.func_77960_j();
        ItemStack out = null;
        if (uses > 1) {
            out = new ItemStack(stack.func_77973_b(), 1, uses - 1);
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        int uses = stack.func_77960_j();
        if (uses > 0) {
            tooltip.add(StatCollector.func_74838_a((String)("multiuse.use." + uses)));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int uses = stack.func_77960_j();
        return uses > 0 && uses != this._max_uses;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(this._max_uses - stack.func_77960_j()) / (double)this._max_uses;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        if (tab == null || tab == this.func_77640_w()) {
            subItems.add(new ItemStack(itemIn, 1, this._max_uses));
        }
    }

    @Optional.Method(modid="smarthoppers")
    public boolean represents(ItemStack multiuse, ItemStack candidate, IContraption smhc) {
        return multiuse.func_77973_b() == candidate.func_77973_b() && !candidate.func_77948_v() && multiuse.func_77960_j() >= candidate.field_77994_a;
    }

    public final int[] getUsesRenderMetas() {
        int[] metas = new int[this._max_uses];
        for (int i = 1; i <= this._max_uses; ++i) {
            metas[i - 1] = i;
        }
        return metas;
    }

    public final String[] getUsesRenderNames() {
        return new String[]{this._oid.fmlid()};
    }

    public final ItemStack asJunk() {
        return new ItemStack((Item)this, 1, Math.min(this._max_uses, 4));
    }

    public final ItemStack asGold() {
        return new ItemStack((Item)this, 1, this._max_uses);
    }

    public static final ItemStack junk() {
        return ((VfpCutterItem)VfpObj.Flint_Cutter_obj).asJunk();
    }

    public static final ItemStack gold() {
        return ((VfpCutterItem)VfpObj.Flint_Cutter_obj).asGold();
    }
}

