/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;

public final class Muffins
extends VfpPantryMultiItem {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Muffins, (Class)Muffins.class, "type"){

        @Override
        protected VfpVariant[] declaredVariants() {
            return this.values().toArray(VfpVariant.EMPTY_ARRAY);
        }

        @Override
        public String[] renderNames() {
            VfpVariant[] enumset = this.declaredVariants();
            String[] names = new String[enumset.length];
            String bakedName = "vanillafoodpantry:" + this.typeName();
            String unbakedName = "vanillafoodpantry:uncooked_" + this.typeName();
            for (int i = 0; i < enumset.length; ++i) {
                names[i] = enumset[i].datadata(MuffinDef.class).baked() ? bakedName : unbakedName;
            }
            return names;
        }
    };
    private static Muffins INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public Muffins(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_SET.variants(), tab);
    }

    @SideOnly(value=Side.CLIENT)
    private int getColorFromMeta(int meta, int renderPass) {
        MuffinDef muffinDef;
        Integer colorValue;
        int color_num = 0;
        VfpVariant type = VARIANT_SET.lookup(meta);
        if (type != null && (colorValue = (muffinDef = type.datadata(MuffinDef.class)).colorValue()) != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        int default_color_num;
        int color_num = default_color_num = super.func_82790_a(stack, renderPass);
        if (renderPass <= 0 && (color_num = this.getColorFromMeta(stack.func_77960_j(), renderPass)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        String name = MinecraftGlue.I18N_ITEM_KEY_PREFIX();
        name = variant != null ? name + variant.datadata(MuffinDef.class).unlocalizedName() : name + VARIANT_SET.typeName();
        return name;
    }

    public static final synchronized Muffins get() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(16);
            for (MuffinDef muffinDef : MuffinDef.values()) {
                String fmlid = muffinDef.unlocalizedName();
                LikeFood like = muffinDef.baked() ? LikeFood.muffin : null;
                CreativeTabs tab = muffinDef.baked() ? null : CreativeTabs.field_78035_l;
                variants.add(new VfpTransientVariant(muffinDef.id(), fmlid, like, (Object)muffinDef, tab, VARIANT_SET));
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Muffins, Muffins.class, VfpBuilder.User.INTERNAL);
            for (MuffinDef muffinDef : MuffinDef.values()) {
                if (!muffinDef.baked()) continue;
                ItemStack a_muffin = new ItemStack((Item)INSTANCE, 1, muffinDef.id());
                OreDictionary.registerOre((String)"foodMuffin", (ItemStack)a_muffin);
            }
        }
        return INSTANCE;
    }

    public static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null && Muffins.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            MuffinDef[] muffinDefs = MuffinDef.values();
            int batch_size = VfpCapacity.MUFFIN_BATCH.count();
            for (int i = 0; i < muffinDefs.length; i += 2) {
                ItemStack unbaked_muffin = new ItemStack((Item)INSTANCE, 1, muffinDefs[i].id());
                ItemStack baked_muffin = new ItemStack((Item)INSTANCE, 1, muffinDefs[i + 1].id());
                instances.add(unbaked_muffin.func_77946_l());
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, batch_size, muffinDefs[i].id()), new Object[]{"ec.", "xmx", "fff", Character.valueOf('e'), "ingredientEgg", Character.valueOf('c'), VfpObj.CheeseBall_obj, Character.valueOf('m'), "portionCondensedMilk", Character.valueOf('x'), FoodPowders.get(muffinDefs[i].flavor(), 1), Character.valueOf('f'), "foodFlour"}), LikeFood.muffin.craftExperience()));
                GameRegistry.addSmelting((ItemStack)unbaked_muffin, (ItemStack)baked_muffin, (float)LikeFood.muffin.smeltExperience());
                instances.add(baked_muffin.func_77946_l());
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack pumpkin(int amount) {
        return new ItemStack((Item)INSTANCE, amount, MuffinDef.Pumpkin_SweetCheese.id());
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MuffinDef def : MuffinDef.values()) {
            if (!def.baked()) continue;
            list.add(new ItemStack((Item)INSTANCE, 1, def.id()));
        }
        return list;
    }

    static enum MuffinDef {
        Unbaked_Pumpkin_SweetCheese(false, "pumpkin", FoodPowders.Type.PUMPKIN, FoodPowders.Usage.BREAD_FLAVOR.idFirst(), 15719111),
        Pumpkin_SweetCheese(true, MuffinDef.Unbaked_Pumpkin_SweetCheese._name, FoodPowders.Type.PUMPKIN, MuffinDef.Unbaked_Pumpkin_SweetCheese._id + 1),
        Unbaked_Cocoa_SweetCheese(false, "cocoa", FoodPowders.Type.COCOA, MuffinDef.Pumpkin_SweetCheese._id + 1, 0x887766),
        Cocoa_SweetCheese(true, MuffinDef.Unbaked_Cocoa_SweetCheese._name, FoodPowders.Type.COCOA, MuffinDef.Unbaked_Cocoa_SweetCheese._id + 1),
        Unbaked_Carrot_SweetCheese(false, "carrot", FoodPowders.Type.CARROT, MuffinDef.Cocoa_SweetCheese._id + 1, 14198911),
        Carrot_SweetCheese(true, MuffinDef.Unbaked_Carrot_SweetCheese._name, FoodPowders.Type.CARROT, MuffinDef.Unbaked_Carrot_SweetCheese._id + 1);

        private final int _id;
        private final String _name;
        private final boolean _baked;
        private final FoodPowders.Type _flavor;
        private final Integer _color;

        private MuffinDef(boolean baked, String name, FoodPowders.Type flavor, int id, Integer color) {
            this._id = id;
            this._name = name;
            this._baked = baked;
            this._flavor = flavor;
            this._color = color;
        }

        private MuffinDef(boolean baked, String name, FoodPowders.Type flavor, int id) {
            this(baked, name, flavor, id, null);
        }

        String unlocalizedName() {
            String p = this._baked ? "" : "uncooked_";
            return this._name == null ? p + "muffin" : p + this._name + "_muffin";
        }

        int id() {
            return this._id;
        }

        boolean baked() {
            return this._baked;
        }

        FoodPowders.Type flavor() {
            return this._flavor;
        }

        Integer colorValue() {
            return this._color != null ? this._color : this.flavor().colorValue();
        }
    }
}

