/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.api.IClampedFeature;

public final class Enchants {
    public static final int MAX_OVER_LEVEL_ALLOWED = 10;
    public static final int MAX_XAMPLIFIED_ENCHANTMENT_LEVEL_ALLOWED = 10;
    public static final int HIGH_FORTUNE = Enchantments.field_185308_t.func_77325_b();
    public static final int MAX_FORTUNE = 10;
    public static final int HIGH_LOOTING = Enchantments.field_185304_p.func_77325_b();
    public static final int MAX_LOOTING = 10;
    public static final int MAX_ATTACK_DAMAGE = 10;
    public static final int HIGH_PROTECTION = Enchantments.field_180310_c.func_77325_b();
    public static final int MAX_PROTECTION = 7;
    public static final int HIGH_UNBREAKING = Enchantments.field_185307_s.func_77325_b();
    public static final int MAX_UNBREAKING = 7;
    public static final int HIGH_CURSED_BINDING = Enchantments.field_190941_k.func_77325_b();
    public static final int MAX_CURSED_BINDING = 3;
    public static final int HIGH_EFFICIENCY = 5;
    public static final int MAX_EFFICIENCY = 10;
    public static final int INFINITE_INFINITY = 4;
    public static final String _NBT_ID = "id";
    public static final String _NBT_LEVEL = "lvl";
    public static final String _NBT_RES = "res";
    public static final Predicate<EnchantmentData> ANY_CURSE = new Predicate<EnchantmentData>(){

        public boolean apply(EnchantmentData edata) {
            return edata.field_76302_b == Enchantments.field_190940_C || edata.field_76302_b == Enchantments.field_190941_k || edata.field_76302_b.func_190936_d();
        }
    };

    @Nullable
    public static final Enchantment getByID(@Nonnull String idstring) {
        Enchantment e = null;
        ResourceLocation r = ResourceLocation.func_208304_a((String)idstring);
        if (r != null && ForgeRegistries.ENCHANTMENTS.containsKey(r)) {
            e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(r);
        }
        return e;
    }

    public static final void removeEnchantments(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME());
        }
    }

    public static final void initEnchantments(@Nonnull ItemStack to, ListNBT enchantments, boolean copy) {
        Enchants.removeEnchantments(to);
        if (enchantments != null && enchantments.size() > 0) {
            to.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (INBT)(copy ? enchantments.func_74737_b() : enchantments));
        }
    }

    public static final void copyinitEnchantments(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        Enchants.removeEnchantments(to);
        if (from.func_77948_v()) {
            to.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (INBT)from.func_77986_q().func_74737_b());
        }
    }

    public static final void hideEnchantments(@Nonnull ItemStack on) {
        if (on.func_77942_o()) {
            int current = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            on.func_77978_p().func_74768_a(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), current | 1);
        }
    }

    public static final boolean areHidden(@Nonnull ItemStack on) {
        boolean hidden = false;
        if (on.func_190926_b()) {
            hidden = true;
        } else if (on.func_77942_o() && on.func_77978_p().func_150297_b(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), 99)) {
            int flags = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            hidden = (flags & 1) == 1;
        }
        return hidden;
    }

    public static final int checkedXLevel(Enchantment e, int level) {
        if ((e == Enchantments.field_185298_f || e == Enchantments.field_185300_i) && level > e.func_77325_b()) {
            level = e.func_77325_b();
        }
        return level;
    }

    @Nullable
    public static final ListNBT getBrokenEnchantments(@Nonnull ItemStack stack) {
        ListNBT enchList = null;
        if (stack.func_77942_o() && (enchList = stack.func_77978_p().func_150295_c("BrokenEnchantments", 10)) != null && enchList.size() <= 0) {
            enchList = null;
        }
        return enchList;
    }

    public static final int getBrokenEnchantmentsOriginalSetsize(@Nonnull ItemStack stack) {
        int n = -1;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BrokenEnchantments_Setsize", 3) && (n = stack.func_77978_p().func_74762_e("BrokenEnchantments_Setsize")) > 10) {
            n = 10;
        }
        return n;
    }

    public static final void setBrokenEnchantments(@Nonnull ItemStack stack, @Nullable ListNBT enchList, int original_count) {
        if (enchList == null || enchList.size() == 0) {
            stack.func_196083_e("BrokenEnchantments");
        } else {
            stack.func_77983_a("BrokenEnchantments", (INBT)enchList);
            if (original_count > 1) {
                stack.func_77983_a("BrokenEnchantments_Setsize", (INBT)new IntNBT(original_count));
            }
        }
    }

    @Nullable
    public static final EnchantmentData getRawData(@Nonnull CompoundNBT enchantmentNbt) {
        Enchantment enchantment = Enchants.getByID(enchantmentNbt.func_74779_i(_NBT_ID));
        EnchantmentData edata = null;
        if (enchantment != null) {
            short level = enchantmentNbt.func_74765_d(_NBT_LEVEL);
            edata = new EnchantmentData(enchantment, (int)level);
        }
        return edata;
    }

    @Nullable
    public static final EnchantmentData getData(@Nonnull CompoundNBT enchantmentNbt, boolean clamp) {
        Enchantment enchantment = Enchants.getByID(enchantmentNbt.func_74779_i(_NBT_ID));
        int level = enchantmentNbt.func_74765_d(_NBT_LEVEL);
        if (enchantment == null && enchantmentNbt.func_150297_b(_NBT_RES, 8)) {
            enchantment = Enchants.getByID(enchantmentNbt.func_74779_i(_NBT_RES));
        }
        EnchantmentData edata = null;
        if (enchantment != null) {
            if (clamp || level <= 0) {
                level = Enchants.clampedGeneral(level, enchantment);
            }
            edata = new EnchantmentData(enchantment, level);
        }
        return edata;
    }

    @Nonnull
    public static final Map<Enchantment, Integer> getEnchantments(@Nonnull ItemStack stack, boolean hiddenOk, Item broken) {
        ListNBT enchList;
        ListNBT listNBT;
        LinkedHashMap<Enchantment, Integer> map = new LinkedHashMap<Enchantment, Integer>();
        if (ItemStacks.isEmpty(stack) || !hiddenOk && Enchants.areHidden(stack)) {
            return map;
        }
        Item stackitem = stack.func_77973_b();
        if (stackitem instanceof EnchantedBookItem) {
            EnchantedBookItem cfr_ignored_0 = (EnchantedBookItem)stackitem;
            listNBT = EnchantedBookItem.func_92110_g((ItemStack)stack);
        } else {
            listNBT = enchList = stackitem == broken ? Enchants.getBrokenEnchantments(stack) : stack.func_77986_q();
        }
        if (enchList != null) {
            for (int i = 0; i < enchList.size(); ++i) {
                Integer oldLevel;
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null || (oldLevel = map.put(edata.field_76302_b, edata.field_76303_c)) == null || oldLevel <= edata.field_76303_c) continue;
                map.put(edata.field_76302_b, oldLevel);
            }
        }
        return map;
    }

    @Nonnull
    public static final Map<Enchantment, Integer> getEnchantments(@Nonnull ItemStack stack) {
        return Enchants.getEnchantments(stack, true, null);
    }

    @Nullable
    public static final EnchantmentData getFirst(@Nonnull ItemStack stack, boolean hiddenOk) {
        ListNBT enchList;
        ListNBT listNBT;
        if (ItemStacks.isEmpty(stack) || !hiddenOk && Enchants.areHidden(stack)) {
            return null;
        }
        if (stack.func_77973_b() instanceof EnchantedBookItem) {
            EnchantedBookItem cfr_ignored_0 = (EnchantedBookItem)stack.func_77973_b();
            listNBT = EnchantedBookItem.func_92110_g((ItemStack)stack);
        } else {
            listNBT = enchList = stack.func_77986_q();
        }
        if (enchList != null) {
            for (int i = 0; i < enchList.size(); ++i) {
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null) continue;
                return edata;
            }
        }
        return null;
    }

    public static boolean isAnyEnchantedBook(@Nullable Item item) {
        return item == Items.field_151134_bR || item instanceof EnchantedBookItem;
    }

    public static final boolean isEnchanted(@Nonnull ItemStack stack, boolean hiddenOk) {
        EnchantmentData edata = Enchants.getFirst(stack, hiddenOk);
        return edata != null;
    }

    public static final boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        boolean is;
        boolean bl = is = !ItemStacks.isEmpty(stack);
        if (is) {
            Item itemimpl = stack.func_77973_b();
            if (!itemimpl.func_77616_k(stack)) {
                is = false;
            } else {
                for (Enchantment e : Enchants.getEnchantments(book).keySet()) {
                    if (itemimpl.canApplyAtEnchantingTable(stack, e)) continue;
                    is = false;
                    break;
                }
            }
        }
        return is;
    }

    public static final int getOtherCount(ItemStack itemstack, boolean stopquick, Enchantment ... endemicList) {
        int n = 0;
        if (!ItemStacks.isEmpty(itemstack) && endemicList.length > 0) {
            ListNBT enchList = itemstack.func_77986_q();
            for (int i = 0; i < enchList.size(); ++i) {
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null) continue;
                boolean found = false;
                for (Enchantment owned : endemicList) {
                    if (edata.field_76302_b != owned) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ++n;
                if (stopquick) break;
            }
        }
        return n;
    }

    public static final void removeEnchantments(ItemStack stack, @Nullable Collection<Enchantment> filterList) {
        if (stack != null && stack.func_77948_v()) {
            if (filterList == null) {
                filterList = Collections.EMPTY_LIST;
            }
            if (filterList.isEmpty()) {
                Enchants.removeEnchantments(stack);
            } else {
                ListNBT curList = stack.func_77986_q();
                ListNBT newList = new ListNBT();
                for (int i = 0; i < curList.size(); ++i) {
                    EnchantmentData edata = Enchants.getData(curList.func_150305_b(i), false);
                    if (!filterList.contains(edata.field_76302_b)) continue;
                    newList.add((Object)curList.func_150305_b(i));
                }
                if (newList.size() != curList.size()) {
                    if (newList.size() == 0) {
                        Enchants.removeEnchantments(stack);
                    } else {
                        stack.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (INBT)newList);
                    }
                }
            }
        }
    }

    public static final ListNBT sameItemEnchantments(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        ListNBT outList = null;
        if (stack1.func_77948_v() && stack2.func_77948_v()) {
            ListNBT tagList1 = stack1.func_77986_q();
            ListNBT tagList2 = stack2.func_77986_q();
            int n = tagList1.size();
            if (n == tagList2.size() && n > 0) {
                for (int i = 0; i < n; ++i) {
                    EnchantmentData edata1 = Enchants.getRawData(tagList1.func_150305_b(i));
                    if (edata1 == null) {
                        return null;
                    }
                    boolean match_found = false;
                    for (int j = 0; j < n && !match_found; ++j) {
                        EnchantmentData edata2 = Enchants.getRawData(tagList2.func_150305_b(j));
                        if (edata2 == null) {
                            return null;
                        }
                        if (edata2.field_76302_b != edata1.field_76302_b) continue;
                        if (outList == null) {
                            outList = new ListNBT();
                        }
                        if (edata1.field_76303_c <= edata2.field_76303_c) {
                            outList.add((Object)tagList1.func_150305_b(i).func_74737_b());
                        } else {
                            outList.add((Object)tagList2.func_150305_b(j).func_74737_b());
                        }
                        match_found = true;
                        break;
                    }
                    if (match_found) continue;
                    return null;
                }
            }
        }
        return outList;
    }

    public static final ListNBT addEnchantmentToStack(Enchantment enchantment, int level, ListNBT listNbt) {
        CompoundNBT info = new CompoundNBT();
        if (level <= 0) {
            level = enchantment.func_77319_d();
        }
        info.func_74778_a(_NBT_ID, String.valueOf(enchantment.getRegistryName()));
        info.func_74777_a(_NBT_LEVEL, (short)level);
        listNbt.add((Object)info);
        return listNbt;
    }

    public static void addEnchantmentToStack(Enchantment enchantment, int level, @Nonnull ItemStack stack) {
        Enchants.addEnchantmentToStack(enchantment, level, ItemStacks.getOrCreateData(stack));
    }

    public static final CompoundNBT addEnchantmentToStack(Enchantment enchantment, int level, CompoundNBT stackNbt) {
        ListNBT listNbt = stackNbt.func_150295_c(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), 10);
        Enchants.addEnchantmentToStack(enchantment, level, listNbt);
        stackNbt.func_218657_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (INBT)listNbt);
        return stackNbt;
    }

    public static ItemStack mergeEnchantmentToStack(@Nonnull Enchantment enchantment, int level, @Nonnull ItemStack stack) {
        boolean add;
        boolean bl = add = level > 0;
        if (stack.func_77948_v()) {
            ListNBT list = stack.func_77986_q();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompoundNBT element = list.func_150305_b(i);
                if (enchantment != Enchants.getByID(element.func_74779_i(_NBT_ID))) continue;
                add = false;
                if (level <= 0) {
                    list.remove(i);
                    break;
                }
                short current_level = element.func_74765_d(_NBT_LEVEL);
                if (level <= current_level) break;
                element.func_74777_a(_NBT_LEVEL, (short)level);
                break;
            }
        }
        if (add) {
            stack.func_77966_a(enchantment, level);
        }
        return stack;
    }

    public static ItemStack clearEnchantmentFromStack(@Nonnull Enchantment enchantment, @Nonnull ItemStack stack) {
        return Enchants.mergeEnchantmentToStack(enchantment, -1, stack);
    }

    public static final boolean isLikely(ItemStack stack, @Nonnull Predicate<Map.Entry<Enchantment, Integer>> test) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            for (Map.Entry<Enchantment, Integer> e : Enchants.getEnchantments(stack).entrySet()) {
                if (!test.apply(e)) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    @Nonnull
    public static final List<EnchantmentData> strippedOf(@Nonnull List<EnchantmentData> elist, @Nonnull Predicate<EnchantmentData> test) {
        ListIterator<EnchantmentData> litr = elist.listIterator();
        while (litr.hasNext()) {
            if (!test.apply((Object)litr.next())) continue;
            litr.remove();
        }
        return elist;
    }

    @Nonnull
    public static final List<EnchantmentData> strippedOfCurses(@Nonnull List<EnchantmentData> elist) {
        return Enchants.strippedOf(elist, ANY_CURSE);
    }

    public static final List<EnchantmentData> strippedOfVanishingCurse(List<EnchantmentData> elist) {
        return Enchants.strippedOf(elist, new Predicate<EnchantmentData>(){

            public boolean apply(EnchantmentData edata) {
                return edata.field_76302_b == Enchantments.field_190940_C;
            }
        });
    }

    public static final int clampedGeneral(int level, int max) {
        return Enchants.clampedGeneral(level, -1, max);
    }

    public static final int clampedGeneral(int level, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < 0 || max > 10) {
            max = 10;
        }
        if (min > max) {
            min = max;
        }
        return MathHelper.func_76125_a((int)level, (int)min, (int)max);
    }

    public static final int clampedGeneral(int level, Enchantment e) {
        int max = e.func_77325_b();
        if (e instanceof IClampedFeature) {
            max = ((IClampedFeature)e).getMaxClampedLevel();
        }
        level = Enchants.clampedGeneral(level, e.func_77319_d(), max);
        return level;
    }

    public static final int clampedLooting(int lootingLevel) {
        return Math.min(Math.max(0, lootingLevel), 10);
    }

    public static final int clampedFortune(int fortuneLevel) {
        return Math.min(Math.max(0, fortuneLevel), 10);
    }

    public static final int clampedProtection(int protectionLevel) {
        return Math.min(Math.max(0, protectionLevel), 7);
    }

    @Nonnull
    public static final EnchantmentData getRandom(@Nonnull Enchantment e, @Nonnull Random rng) {
        int rand_level = e.func_77319_d();
        if (e.func_77325_b() > rand_level) {
            rand_level += rng.nextInt(e.func_77325_b() - rand_level + 1);
        }
        return new EnchantmentData(e, Enchants.clampedGeneral(rand_level, e));
    }

    private static final boolean isAllowed(@Nonnull ItemStack target, boolean izaBook, Enchantment e, boolean allowCurses, boolean allowTreasures) {
        if (!allowCurses && e.func_190936_d()) {
            return false;
        }
        if (!allowTreasures && e.func_185261_e()) {
            return false;
        }
        return izaBook && e.isAllowedOnBooks() || e.func_92089_a(target);
    }

    @Nullable
    public static final EnchantmentData getRandom(@Nonnull ItemStack target, boolean allowCurses, boolean allowTreasure, @Nonnull Random rng, boolean compat, int retries) {
        EnchantmentData out = null;
        if (!ItemStacks.isEmpty(target)) {
            boolean isBook = Whatis.isBlankBook(target.func_77973_b());
            if (compat) {
                ArrayList possibles = new ArrayList(37);
                ForgeRegistries.ENCHANTMENTS.forEach(e -> {
                    if (!LibConfig.omitFromRandomGeneration_s(e) && Enchants.isAllowed(target, isBook, e, allowCurses, allowTreasure)) {
                        possibles.add(e);
                    }
                });
                if (!possibles.isEmpty()) {
                    out = Enchants.getRandom((Enchantment)possibles.get(rng.nextInt(possibles.size())), rng);
                }
            } else {
                retries = MathHelper.func_76125_a((int)retries, (int)0, (int)10);
                do {
                    Enchantment e2;
                    if ((e2 = (Enchantment)Registry.field_212628_q.func_186801_a(rng)) == null) {
                        return null;
                    }
                    if (LibConfig.omitFromRandomGeneration_s(e2) || !Enchants.isAllowed(target, isBook, e2, allowCurses, allowTreasure)) continue;
                    out = Enchants.getRandom(e2, rng);
                    break;
                } while (--retries >= 0);
            }
        }
        return out;
    }

    @Nullable
    public static final EnchantmentData getRandom(@Nonnull ItemStack target, @Nonnull Random rng) {
        return Enchants.getRandom(target, true, true, rng, false, -1);
    }

    public static final void init0() {
    }

    protected Enchants() {
    }
}

