/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jwaresoftware.mcmods.lib.CarrotsLib;
import org.jwaresoftware.mcmods.lib.LibFMLMessage;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;

public final class LibConfig
implements IModConfig {
    private static LibConfig _sharedINSTANCE = new LibConfig();
    private boolean _INITIALIZED = false;
    private final List<Enchantment> _OMITTED_FROM_RANDOM_ENCHANTS = new ArrayList<Enchantment>();
    private final List<Potion> _OMITTED_FROM_RANDOM_POTIONS = new ArrayList<Potion>();
    private boolean _UPDATE_ADVANCEMENT_TRIGGERS;
    private boolean _UPDATE_SCORE_BASED_TRIGGERS;
    private int _UPDATE_TRIGGERS_FREQUENCY_TICKS = -1;

    @Nonnull
    public LibConfig setInstance() {
        _sharedINSTANCE = this;
        return this;
    }

    @Nonnull
    public static final LibConfig getInstance() {
        return _sharedINSTANCE;
    }

    public void initEarly() {
        this._INITIALIZED = true;
    }

    @Override
    public boolean isLoaded() {
        return this._INITIALIZED;
    }

    @Override
    public boolean isPresent(@Nonnull String feature) {
        return false;
    }

    @Override
    public boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        return defaultValue;
    }

    public void initFinalize() {
        ArrayList<Potion> omitted_potions = new ArrayList<Potion>();
        ArrayList<Enchantment> omitted_enchants = new ArrayList<Enchantment>();
        MutableInt autotickDelaySeconds = new MutableInt(60);
        InterModComms.getMessages((String)"carrots").forEach(msg -> {
            LibFMLMessage msgid = LibFMLMessage.findOrNone(msg.getMethod());
            switch (msgid) {
                case TICK_SCORE_ADVANCEMENTS: {
                    int i;
                    this._UPDATE_SCORE_BASED_TRIGGERS = true;
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (!(unsafe instanceof Number) || (i = ((Number)unsafe).intValue()) <= 1 || i >= autotickDelaySeconds.intValue()) break;
                    autotickDelaySeconds.setValue(i);
                    break;
                }
                case TICK_ADVANCEMENTS: {
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    break;
                }
                case OMIT_FROM_RANDOM_POTIONS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Potion) {
                        rid = ((Potion)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Potion p = null;
                        if (ForgeRegistries.POTION_TYPES.containsKey(rid)) {
                            p = (Potion)ForgeRegistries.POTION_TYPES.getValue(rid);
                        }
                        if (!Potions.isEmpty(p)) {
                            omitted_potions.add(p);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.instance.getLog().warn("Unable to process omit potion FML request from '{}' for '{}'. Unrecognized potion identifier. Understands strings, resource locations, and object references for REGISTERED potions only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
                case OMIT_FROM_RANDOM_ENCHANTS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Enchantment) {
                        rid = ((Enchantment)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Enchantment e = null;
                        if (ForgeRegistries.ENCHANTMENTS.containsKey(rid)) {
                            e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rid);
                        }
                        if (e != null) {
                            omitted_enchants.add(e);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.instance.getLog().warn("Unable to process omit enchantment FML request from '{}' for '{}'. Unrecognized enchantment identifier. Understands strings, resource locations, and object references for REGISTERED enchantments only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
            }
        });
        this.finalizeBlockedEnchantments(omitted_enchants);
        this.finalizeBlockedPotions(omitted_potions);
        if (this._UPDATE_SCORE_BASED_TRIGGERS) {
            this._UPDATE_TRIGGERS_FREQUENCY_TICKS = SharedGlue.ticksFromSeconds(autotickDelaySeconds.intValue());
        }
    }

    private void finalizeBlockedEnchantments(Collection<Enchantment> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_ENCHANTS.clear();
            this._OMITTED_FROM_RANDOM_ENCHANTS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nullable Enchantment e) {
        return LibConfig.getInstance()._OMITTED_FROM_RANDOM_ENCHANTS.contains(e);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Enchantment e) {
        return e == null || e.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(e);
    }

    private void finalizeBlockedPotions(Collection<Potion> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_POTIONS.clear();
            this._OMITTED_FROM_RANDOM_POTIONS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nullable Potion p) {
        return LibConfig.getInstance()._OMITTED_FROM_RANDOM_POTIONS.contains(p);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Potion p) {
        return p == null || p.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(p);
    }

    public static final boolean installAdvancementAutoTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS || LibConfig.getInstance()._UPDATE_SCORE_BASED_TRIGGERS;
    }

    public static final boolean tickAdvancementTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS;
    }

    public static final int tickScoreTriggersFrequency() {
        return LibConfig.getInstance()._UPDATE_TRIGGERS_FREQUENCY_TICKS;
    }
}

