/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.NetherBiome;
import net.minecraft.world.biome.TheEndBiome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.SharedGlue;

@ParametersAreNonnullByDefault
public final class Locations {
    public static final int DIMENSION_SURFACE = 0;
    public static final int DIMENSION_NETHER = -1;
    public static final int DIMENSION_END = 1;
    public static final ResourceLocation BIOME_ID_END = new ResourceLocation("the_end");
    public static final ResourceLocation BIOME_ID_NETHER = new ResourceLocation("nether");

    public static final boolean isBiomeLike(Biome biome, Biome baseline, BiomeDictionary.Type ... plus) {
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type wantedType : BiomeDictionary.getTypes((Biome)baseline)) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        if (plus != null) {
            for (BiomeDictionary.Type wantedType : plus) {
                if (biomeTypes.contains(wantedType)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isBiomeLike(@Nonnull Biome biome, BiomeDictionary.Type ... plus) {
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type wantedType : plus) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        return true;
    }

    public static final boolean inBiomeLike(@Nonnull Entity entity, Biome target_biome, BiomeDictionary.Type ... plus) {
        Biome source_biome = entity.func_130014_f_().func_180494_b(entity.func_180425_c());
        return Locations.isBiomeLike(source_biome, target_biome, plus);
    }

    public static final boolean isaRegularJungle(Biome biome) {
        return biome == Biomes.field_76782_w || biome == Biomes.field_76792_x || biome == Biomes.field_150574_L || biome == Biomes.field_185446_X || biome == Biomes.field_185447_Y || biome == Biomes.field_222370_aw || biome == Biomes.field_222371_ax;
    }

    public static final boolean isaRegularSwamp(Biome biome) {
        return biome == Biomes.field_76780_h || biome == Biomes.field_150599_m;
    }

    public static final boolean isaRegularTaiga(Biome biome) {
        return biome == Biomes.field_76768_g || biome == Biomes.field_76784_u || biome == Biomes.field_150590_f || biome == Biomes.field_150578_U || biome == Biomes.field_150581_V || biome == Biomes.field_150584_S || biome == Biomes.field_150579_T || biome == Biomes.field_185431_ac;
    }

    public static final boolean isaRegularColdMountain(Biome biome) {
        return biome == Biomes.field_76770_e || biome == Biomes.field_150580_W || biome == Biomes.field_76783_v || biome == Biomes.field_185443_S || biome == Biomes.field_185434_af || biome == Biomes.field_150590_f || biome == Biomes.field_185431_ac;
    }

    public static final boolean inHighHumidity(@Nullable Biome biome, World world, BlockPos blockpos) {
        if (biome == null) {
            biome = world.func_180494_b(blockpos);
        }
        return Locations.isaRegularJungle(biome) || Locations.isaRegularSwamp(biome) || world.func_180502_D(blockpos) && biome.func_185353_n() >= 0.8f;
    }

    public static final DimensionType getDimensionType(@Nullable World world) {
        return world == null || world.field_73011_w == null ? DimensionType.field_223227_a_ : world.field_73011_w.func_186058_p();
    }

    public static final int getDimensionId(@Nullable World world) {
        return world == null || world.field_73011_w == null ? 0 : world.field_73011_w.func_186058_p().func_186068_a();
    }

    public static final boolean isOverworld(@Nullable IWorldReader world) {
        return world != null && world.func_201675_m() != null && world.func_201675_m().func_76569_d();
    }

    public static final boolean inTheOverworld(@Nullable World world, @Nonnull Entity wrt) {
        return Locations.isOverworld((IWorldReader)(world != null ? world : wrt.func_130014_f_()));
    }

    public static final boolean inTheNether(@Nullable Biome biome, @Nonnull World world, @Nonnull BlockPos blockpos) {
        if (biome == null) {
            biome = world.func_180494_b(blockpos);
        }
        return biome instanceof NetherBiome || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static final boolean inTheNether(@Nullable World world, @Nonnull Entity wrt) {
        if (world == null) {
            world = wrt.func_130014_f_();
        }
        if (world.field_73011_w != null && Locations.getDimensionId(world) == -1) {
            return true;
        }
        return Locations.inTheNether(null, world, wrt.func_180425_c());
    }

    public static final boolean inTheEnd(@Nullable Biome biome, @Nonnull World world, @Nonnull BlockPos blockpos) {
        if (biome == null) {
            biome = world.func_180494_b(blockpos);
        }
        return biome instanceof TheEndBiome || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
    }

    public static final boolean inTheEnd(@Nullable World world, @Nonnull Entity wrt) {
        if (world == null) {
            world = wrt.func_130014_f_();
        }
        if (world.field_73011_w != null && Locations.getDimensionId(world) == 1) {
            return true;
        }
        return Locations.inTheEnd(null, world, wrt.func_180425_c());
    }

    public static final boolean isLikelyRealPosition(@Nullable IWorldReader aworld, BlockPos blockpos) {
        return !BlockPos.field_177992_a.equals((Object)blockpos) && aworld instanceof World && ((World)aworld).func_175667_e(blockpos);
    }

    public static final boolean isLikelyRealPositionChecked(@Nullable IWorldReader aworld, BlockPos blockpos) {
        if (!Locations.isLikelyRealPosition(aworld, blockpos)) {
            return false;
        }
        return ((World)aworld).func_190525_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 4.0, SharedGlue.IS_BREATHING_PLAYER) != null;
    }

    public static final boolean isGrowableYPos(IBlockReader aworld, BlockPos blockpos) {
        return blockpos.func_177956_o() >= 15 && blockpos.func_177956_o() < SharedGlue.WORLD_HEIGHT();
    }

    public static final boolean canSeeSky(IWorldReader aworld, BlockPos blockpos) {
        return aworld.func_175710_j(blockpos);
    }

    private Locations() {
    }

    public static final void init() {
    }
}

