/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.LanguageMap;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;

public final class Strings {
    private static final String _TT = "carrots.tooltip.";
    public static final String __DEFAULT_VAL = "*DEFAULT*";
    public static final String __NONE_VAL = "*NONE*";
    public static final int MAX_MENU_WIDTH = 33;
    public static final int MAX_DISPLAY_ITEM_COUNT = 10;

    public static final String safe(Object of, String ds) {
        try {
            return String.valueOf(of);
        }
        catch (Throwable igX) {
            return ds;
        }
    }

    public static final String translate(String key) {
        return LanguageMap.func_74808_a().func_74805_b(key);
    }

    public static final String translateDefault(String key, String defaultValue) {
        String out = Strings.translate(key);
        return !key.equals(out) && !StringUtils.isBlank((CharSequence)out) ? out : defaultValue;
    }

    public static final String translateFormatted(String key, Object ... data) {
        String raw = Strings.translate(key);
        try {
            return String.format(raw, data);
        }
        catch (IllegalFormatException fmtX) {
            return key;
        }
    }

    public static final String translateFormattedDefault(String key, String defaultValue, Object ... data) {
        String raw = Strings.translate(key);
        if (Objects.equals(key, raw) || raw.isEmpty()) {
            return defaultValue;
        }
        try {
            return String.format(raw, data);
        }
        catch (IllegalFormatException fmtX) {
            return defaultValue;
        }
    }

    public static final boolean hasTranslation(String key) {
        String out = Strings.translate(key);
        return !Objects.equals(key, out);
    }

    public static final String libraryKey(String key) {
        return "carrots." + String.valueOf(key);
    }

    public static final String tooltipKey(String key) {
        return _TT + String.valueOf(key);
    }

    public static final String translateTooltip(String key) {
        return Strings.translate(_TT + key);
    }

    public static final String translateTooltip(String key, String defaultValue) {
        return Strings.translateDefault(_TT + key, defaultValue);
    }

    public static final String translateFormattedTooltip(String key, Object ... format) {
        return Strings.translateFormatted(_TT + key, format);
    }

    public static final String translateFormattedTooltipDefault(String key, String defaultValue, Object ... format) {
        return Strings.translateFormattedDefault(_TT + key, defaultValue, format);
    }

    public static final boolean isDefaultValue(@Nullable String s, boolean emptyIsTrue) {
        return (s = StringUtils.trimToNull((String)s)) == null ? emptyIsTrue : "DEFAULT".equals(StringUtils.strip((String)s.toUpperCase(Locale.US), (String)"*_"));
    }

    public static final boolean isDefaultValue(@Nullable String s) {
        return Strings.isDefaultValue(s, true);
    }

    public static final String[] __DEFAULT_VAL_SETTINGS() {
        return new String[]{__DEFAULT_VAL, Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    }

    public static final boolean isNoneValue(@Nullable String s, boolean emptyIsTrue) {
        return (s = StringUtils.trimToNull((String)s)) == null ? emptyIsTrue : "NONE".equals(StringUtils.strip((String)s.toUpperCase(Locale.US), (String)"*_"));
    }

    public static final boolean isNoneValue(@Nullable String s) {
        return Strings.isNoneValue(s, false);
    }

    private static String safe_toJson(ITextComponent e) {
        try {
            return ITextComponent.Serializer.func_150696_a((ITextComponent)e);
        }
        catch (Throwable parseX) {
            return "";
        }
    }

    @Nonnull
    public static final String serialize(@Nullable ITextComponent encoded) {
        return encoded == null ? "" : Strings.safe_toJson(encoded);
    }

    private static ITextComponent safe_fromJson(String e, @Nullable ITextComponent df) {
        try {
            return ITextComponent.Serializer.func_150699_a((String)e);
        }
        catch (Throwable parseX) {
            return df;
        }
    }

    @Nullable
    public static final ITextComponent deserialize(@Nullable String encoded, @Nullable ITextComponent defaultIfMissing) {
        return StringUtils.isBlank((CharSequence)encoded) ? defaultIfMissing : Strings.safe_fromJson(encoded, defaultIfMissing);
    }

    @Nullable
    public static final ITextComponent deserialize(String encoded) {
        return Strings.deserialize(encoded, null);
    }

    public static final String boundedDisplayString(@Nonnull ItemStack item, int reserved_width) {
        String resolved = item.func_200301_q().func_150254_d();
        return StringUtils.abbreviate((String)resolved, (int)(33 - reserved_width));
    }

    public static final String boundedUiTipString(@Nonnull ItemStack item, int reserved_width) {
        String resolved = item.func_200301_q().func_150254_d();
        resolved = resolved + (ItemStacks.isSingle(item) ? "" : " (" + ItemStacks.getSize(item) + ")");
        return StringUtils.abbreviate((String)resolved, (int)(33 - reserved_width));
    }

    private Strings() {
    }

    public static final void init() {
    }
}

