/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.OwnerDef;
import org.jwaresoftware.mcmods.lib.Strings;

public final class Tooltips {
    private static final String _MISSING = "\\o/";
    private static final int _TOOWIDE = 200;
    static final AtomicBoolean _defaultFlag = new AtomicBoolean(false);
    static final ConcurrentMap<ModIntegration, Boolean> _hiddenFlags = new ConcurrentHashMap<ModIntegration, Boolean>();
    private static boolean _SIMPLE_FORM_SENTENCE = false;

    public static final boolean isHidden(ModIntegration modid) {
        return modid == null || modid == ModIntegration.CARROTS_LIB ? _defaultFlag.get() : _hiddenFlags.getOrDefault((Object)modid, false).booleanValue();
    }

    public static void setHidden(ModIntegration modid, boolean flag) {
        if (modid != null && modid != ModIntegration.CARROTS_LIB) {
            _hiddenFlags.put(modid, flag);
        } else {
            _defaultFlag.set(flag);
        }
    }

    public static void setHidden(boolean flag) {
        Tooltips.setHidden(null, flag);
    }

    public static final boolean hasUiTip(@Nonnull Item item) {
        String i18n_key = item.func_77658_a();
        String uitip = Strings.translateDefault("tooltip_summ." + i18n_key, _MISSING);
        return !_MISSING.equals(uitip);
    }

    public static final boolean hasUiTip(@Nonnull Block block) {
        String i18n_key = block.func_149739_a();
        String uitip = Strings.translateDefault("tooltip." + i18n_key, _MISSING);
        if (!_MISSING.equals(uitip)) {
            return true;
        }
        uitip = Strings.translateDefault("tooltip_summ." + i18n_key, _MISSING);
        return !_MISSING.equals(uitip);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addWrapped(ItemStack stack, String itemDisplayName, String uitip, int maxlinewidth, List<ITextComponent> tooltip) {
        FontRenderer fontRenderer = stack.func_77973_b().getFontRenderer(stack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        int width = fontRenderer.func_78256_a(itemDisplayName);
        for (String line_text : fontRenderer.func_78271_c(uitip, Math.max(width, maxlinewidth))) {
            ITextComponent line = new StringTextComponent(line_text).func_211708_a(TextFormatting.GRAY);
            tooltip.add(line);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final ITextComponent NL() {
        return new StringTextComponent("");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final ITextComponent SP1() {
        return new StringTextComponent(" ");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final ITextComponent SP2() {
        return new StringTextComponent("  ");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipLine(ItemStack stack, List<ITextComponent> tooltip, String tip_id_prefix) {
        boolean did = false;
        String uitip = Strings.translateDefault(tip_id_prefix + "." + stack.func_77973_b().func_77667_c(stack), _MISSING);
        if (!_MISSING.equals(uitip)) {
            tooltip.add(new StringTextComponent(uitip).func_211708_a(TextFormatting.GRAY));
            did = true;
        }
        return did;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipLine(@Nonnull ModIntegration modid, ItemStack stack, List<ITextComponent> tooltip, String tip_id_prefix) {
        if (Tooltips.isHidden(modid)) {
            return false;
        }
        return Tooltips.addDocTipLine(stack, tooltip, tip_id_prefix);
    }

    static final void initLanguageSupport() {
        Locale SPANISH = new Locale("es");
        String lang = Locale.getDefault().getLanguage();
        _SIMPLE_FORM_SENTENCE = lang.isEmpty() || lang.equals(Locale.ENGLISH.getLanguage()) || lang.equals(SPANISH.getLanguage()) || lang.equals(Locale.FRENCH.getLanguage()) || lang.equals(Locale.GERMAN.getLanguage());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTip(ItemStack stack, List<ITextComponent> tooltip, String tip_id_summ, @Nullable String tip_id_full, boolean longform) {
        boolean want_full = Tooltips.wantsFullDescriptionTip();
        boolean has_full = tip_id_full != null && Strings.hasTranslation(tip_id_full);
        String tip_id = tip_id_summ;
        if (want_full && has_full) {
            tip_id = tip_id_full;
        }
        boolean did = false;
        String uitip = Strings.translateDefault(tip_id, _MISSING);
        if (!_MISSING.equals(uitip)) {
            String uitip_summ;
            if (uitip.startsWith("{SUMM}") && tip_id == tip_id_full && !_MISSING.equals(uitip_summ = Strings.translateDefault(tip_id_summ, _MISSING))) {
                uitip = uitip_summ + uitip.substring(6);
            }
            Tooltips.addWrapped(stack, tooltip.get(0).func_150254_d(), uitip, 200, tooltip);
            if (!want_full && has_full) {
                String howto_tooltip_id;
                String string = howto_tooltip_id = longform ? "full.description.howto" : "howto";
                if (_SIMPLE_FORM_SENTENCE) {
                    StringBuilder ll = new StringBuilder(300);
                    ll.append(tooltip.get(tooltip.size() - 1).func_150261_e());
                    String llu = TextFormatting.func_110646_a((String)ll.toString());
                    char ch = llu.charAt(llu.length() - 1);
                    if (ch != '.' && ch != '!' && Character.isLetterOrDigit(ch)) {
                        ll.append('.');
                    }
                    ll.append(" ").append(Strings.translateTooltip(howto_tooltip_id));
                    tooltip.remove(tooltip.size() - 1);
                    Tooltips.addWrapped(stack, tooltip.get(0).func_150254_d(), ll.toString(), 200, tooltip);
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent(Strings.tooltipKey(howto_tooltip_id), new Object[0]));
                }
            }
            if (Enchants.isEnchanted(stack, false)) {
                tooltip.add(Tooltips.NL());
            }
            did = true;
        }
        return did;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTip(ModIntegration modid, ItemStack stack, List<ITextComponent> tooltip, String tip_id_summ, @Nullable String tip_id_full) {
        if (Tooltips.isHidden(modid)) {
            return false;
        }
        return Tooltips.addDocTip(stack, tooltip, tip_id_summ, tip_id_full, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipDefault(@Nonnull ItemStack stack, List<ITextComponent> tooltip) {
        String i18n = stack.func_77973_b().func_77667_c(stack);
        return Tooltips.addDocTip(stack, tooltip, "tooltip_summ." + i18n, "tooltip_full." + i18n, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipDefault(ModIntegration modid, @Nonnull ItemStack stack, List<ITextComponent> tooltip) {
        if (Tooltips.isHidden(modid)) {
            return false;
        }
        return Tooltips.addDocTipDefault(stack, tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipSharedSummary(@Nonnull ItemStack stack, List<ITextComponent> tooltip, String tip_id_summ) {
        String i18n = stack.func_77973_b().func_77667_c(stack);
        return Tooltips.addDocTip(stack, tooltip, tip_id_summ, "tooltip_full." + i18n, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addDocTipSharedSummary(ModIntegration modid, @Nonnull ItemStack stack, List<ITextComponent> tooltip, String tip_id_summ) {
        if (Tooltips.isHidden(modid)) {
            return false;
        }
        return Tooltips.addDocTipSharedSummary(stack, tooltip, tip_id_summ);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final boolean lastEntryIsEmpty(List<ITextComponent> tooltip) {
        return tooltip.get(tooltip.size() - 1).func_150254_d().isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addHowToMoreItemDetailsTip(List<ITextComponent> tooltip, boolean spacing) {
        if (spacing && !tooltip.isEmpty() && !Tooltips.lastEntryIsEmpty(tooltip)) {
            tooltip.add(Tooltips.NL());
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(Strings.tooltipKey("more.itemdetails.howto"), new Object[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean extendI18nDocTip(String tip_id, ItemStack stack, List<ITextComponent> tooltip) {
        boolean did = false;
        String uitip = Strings.translateDefault("" + tip_id + "." + stack.func_77973_b().func_77667_c(stack), _MISSING);
        if (!_MISSING.equals(uitip)) {
            ITextComponent uitip_obj = new StringTextComponent(uitip).func_211708_a(TextFormatting.GRAY);
            if (tooltip.isEmpty()) {
                tooltip.add(uitip_obj);
            } else {
                String ll = tooltip.get(tooltip.size() - 1).func_150261_e();
                if (ll.isEmpty()) {
                    tooltip.set(tooltip.size() - 1, uitip_obj);
                    tooltip.add(Tooltips.NL());
                } else {
                    tooltip.get(tooltip.size() - 1).func_150258_a(uitip);
                }
            }
            did = true;
        }
        return did;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean extendDocTip(@Nonnull ItemStack stack, List<ITextComponent> tooltip, ITextComponent uitip) {
        boolean shift = false;
        if (!tooltip.isEmpty() && Tooltips.lastEntryIsEmpty(tooltip)) {
            tooltip.set(tooltip.size() - 1, uitip);
            tooltip.add(Tooltips.NL());
            shift = true;
        }
        if (!shift) {
            tooltip.add(uitip);
        }
        return shift;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean addOwnerTip(@Nonnull ItemStack stack, List<ITextComponent> tooltip) {
        boolean did = false;
        OwnerDef owner = Instructions.getOwnerDef(stack);
        if (owner != null) {
            ITextComponent name = owner.name;
            if (name == null) {
                name = new TranslationTextComponent("entity.HIDDEN.name", new Object[0]);
            }
            tooltip.add(new TranslationTextComponent(Strings.tooltipKey("owner"), new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(name.func_211708_a(TextFormatting.GRAY)));
            did = true;
        }
        return did;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addTipLine(List<ITextComponent> tooltip, String labelid, TextFormatting labelcolor, TextFormatting valuecolor, Object rawvalue) {
        if (valuecolor == null) {
            valuecolor = TextFormatting.GRAY;
        }
        if (labelcolor == null) {
            tooltip.add(new TranslationTextComponent(labelid, new Object[0]).func_150257_a((ITextComponent)(rawvalue instanceof ITextComponent ? (ITextComponent)rawvalue : new StringTextComponent(String.valueOf(rawvalue)))));
        } else {
            tooltip.add(new TranslationTextComponent(labelid, new Object[0]).func_211708_a(labelcolor).func_150257_a(rawvalue instanceof ITextComponent ? (ITextComponent)rawvalue : new StringTextComponent(String.valueOf(rawvalue)).func_211708_a(valuecolor)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addTipLine(List<ITextComponent> tooltip, String labelid, TextFormatting labelcolor, Object rawvalue) {
        Tooltips.addTipLine(tooltip, labelid, labelcolor, null, rawvalue);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean isKeyDown(@Nonnull InputMappings.Input key) {
        if (key.func_197938_b() != InputMappings.Type.KEYSYM) {
            return false;
        }
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)key.func_197937_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean isLeftShiftPressed() {
        InputMappings.Input I_KEY_LSHIFT = InputMappings.func_197955_a((String)"key.keyboard.left.shift");
        return Tooltips.isKeyDown(I_KEY_LSHIFT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean isRightShiftPressed() {
        InputMappings.Input I_KEY_RSHIFT = InputMappings.func_197955_a((String)"key.keyboard.right.shift");
        return Tooltips.isKeyDown(I_KEY_RSHIFT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean wantsFullDescriptionTip() {
        return Tooltips.isRightShiftPressed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean wantsMoreItemDetailsTip(boolean advancedFlag) {
        return advancedFlag || Tooltips.isLeftShiftPressed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getShowMoreLabel() {
        return Strings.translateTooltip("howto", "+RSHIFT for more...");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getFullDescriptionLabel() {
        return Strings.translateTooltip("full.description.howto", "+RSHIFT for full description...");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getMoreItemDetailsLabel() {
        return Strings.translateTooltip("more.itemdetails.howto", "+LSHIFT for more details...");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getFullDescriptionKeyLabel() {
        return Strings.translateTooltip("key.RSHIFT", "+RSHIFT");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getMoreItemDetailsKeyLabel() {
        return Strings.translateTooltip("key.LSHIFT", "+LSHIFT");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getUseKeyLabel() {
        KeyBinding keyClickBinding = Minecraft.func_71410_x().field_71474_y.field_74313_G;
        return keyClickBinding.func_197978_k();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final String getSneakKeyLabel() {
        KeyBinding keyClickBinding = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        return keyClickBinding.func_197978_k();
    }

    public static final ITextComponent addSampleSuffixTo(@Nonnull ITextComponent to) {
        return new TranslationTextComponent(Strings.tooltipKey("itemsuffix.sample"), new Object[]{to});
    }

    public static final void addSampleTipLine(List<ITextComponent> to) {
        to.add(new StringTextComponent(Strings.translateTooltip("SAMPLE.label", "SAMPLE ITEM")).func_211708_a(TextFormatting.GREEN));
    }

    public static final void addUsesLeftTipLine(int usesLeft, List<ITextComponent> to) {
        if (usesLeft > 0) {
            to.add((ITextComponent)new TranslationTextComponent(usesLeft == 1 ? "multiuse.left.1" : "multiuse.left.n", new Object[]{usesLeft}));
        }
    }

    private Tooltips() {
    }
}

