/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.advancements.ObservedTrigger;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;

public class CraftedItemTrigger
extends ObservedTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_crafted");
    @Nonnull
    public static final CraftedItemTrigger INSTANCE = new CraftedItemTrigger(NAME);

    public CraftedItemTrigger(ResourceLocation name) {
        super(name);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return Instance.deserialize(this.func_192163_a(), json);
    }

    public void trigger(ServerPlayerEntity player, ItemStack with) {
        ObservedTrigger.Listeners listeners = (ObservedTrigger.Listeners)this._playersToListeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(instance -> instance.test(with));
        }
    }

    public static final void doApply(ServerPlayerEntity player, ItemStack with) {
        INSTANCE.trigger(player, with);
    }

    public static final class Instance
    extends CriterionInstance {
        @Nonnull
        private final ItemPredicate _match;
        @Nonnull
        private final ITemperatureChangeable.UsedEffect _e;

        public Instance(ResourceLocation trigger, ItemPredicate item, ITemperatureChangeable.UsedEffect e) {
            super(trigger);
            this._match = Objects.requireNonNull(item);
            this._e = e != null ? e : ITemperatureChangeable.UsedEffect.UNCHANGED;
        }

        private boolean atTemperature(ItemStack item) {
            if (this._e == ITemperatureChangeable.UsedEffect.UNCHANGED || !(item.func_77973_b() instanceof ITemperatureChangeable)) {
                return true;
            }
            if (!item.func_77942_o()) {
                return false;
            }
            ITemperatureChangeable cap = (ITemperatureChangeable)item.func_77973_b();
            return this._e == ITemperatureChangeable.UsedEffect.HEATED ? cap.isHeated(item) || cap.shouldBeHeated(item) : cap.isCooled(item) || cap.shouldBeCooled(item);
        }

        public boolean test(ItemStack item) {
            return this._match.func_192493_a(item) && this.atTemperature(item);
        }

        public JsonElement func_200288_b() {
            JsonObject json = new JsonObject();
            json.add("item", this._match.func_200319_a());
            if (this._e != ITemperatureChangeable.UsedEffect.UNCHANGED) {
                json.addProperty("state", this._e.name());
            }
            return json;
        }

        public static final Instance deserialize(ResourceLocation trigr, JsonObject json) {
            String estring = JSONUtils.func_151219_a((JsonObject)json, (String)"state", null);
            ITemperatureChangeable.UsedEffect e = ITemperatureChangeable.UsedEffect.fromString(estring);
            JsonElement item = json.get("item");
            if (item == null) {
                throw new JsonParseException("Missing required top-level 'item' element");
            }
            return new Instance(trigr, ItemPredicate.func_192492_a((JsonElement)item), e);
        }
    }
}

