/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementPredicate;
import org.jwaresoftware.mcmods.lib.advancements.ObservedTrigger;
import org.jwaresoftware.mcmods.lib.advancements.RewardPredicate;
import org.jwaresoftware.mcmods.lib.advancements.ScorePredicate;
import org.jwaresoftware.mcmods.lib.advancements.StatPredicate;

public final class PlayerEarnedTrigger
extends ObservedTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_earned");
    @Nonnull
    public static final PlayerEarnedTrigger INSTANCE = new PlayerEarnedTrigger(NAME);

    public PlayerEarnedTrigger(ResourceLocation name) {
        super(name);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return Instance.deserialize(this.func_192163_a(), json);
    }

    public void trigger(ServerPlayerEntity player, ResourceLocation with) {
        ObservedTrigger.Listeners listeners = (ObservedTrigger.Listeners)this._playersToListeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(instance -> instance.test(with));
        }
    }

    public void trigger(ServerPlayerEntity player, ItemStack with) {
        ObservedTrigger.Listeners listeners = (ObservedTrigger.Listeners)this._playersToListeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(instance -> instance.test((PlayerEntity)player, with));
        }
    }

    public static final void doApply(ServerPlayerEntity player, ResourceLocation thing) {
        INSTANCE.trigger(player, thing);
    }

    public static final void doApply(ServerPlayerEntity player, ItemStack thing) {
        INSTANCE.trigger(player, thing);
    }

    public static final void doApply(ServerPlayerEntity player, Item awarded) {
        if (SharedGlue.isDefined(awarded)) {
            INSTANCE.trigger(player, awarded.getRegistryName());
        }
    }

    public static final void doApply(ServerPlayerEntity player) {
        INSTANCE.trigger(player, ItemStack.field_190927_a);
    }

    public static final class Instance
    extends CriterionInstance {
        private final Optional<StatPredicate> _stats;
        private final Optional<AdvancementPredicate> _advancement;
        private final Optional<RewardPredicate> _reward;
        private final Optional<ScorePredicate> _scores;

        public Instance(ResourceLocation trigger, Optional<AdvancementPredicate> advancement, Optional<StatPredicate> stats, Optional<RewardPredicate> reward, Optional<ScorePredicate> scores) {
            super(trigger);
            this._stats = stats != null ? stats : Optional.empty();
            this._reward = reward != null ? reward : Optional.empty();
            this._advancement = advancement != null ? advancement : Optional.empty();
            this._scores = scores != null ? scores : Optional.empty();
        }

        public Instance(ResourceLocation trigger, RewardPredicate reward) {
            this(trigger, null, null, Optional.ofNullable(reward), null);
        }

        public boolean test(ResourceLocation what) {
            if (this._advancement.isPresent() || this._scores.isPresent() || this._stats.isPresent()) {
                return false;
            }
            return this._reward.get().test(what);
        }

        public boolean test(PlayerEntity player, ItemStack what) {
            boolean t;
            boolean bl = t = this._advancement.isPresent() ? this._advancement.get().test(player) : true;
            if (!t) {
                return false;
            }
            boolean bl2 = t = this._reward.isPresent() ? this._reward.get().test(player, what) : true;
            if (!t) {
                return false;
            }
            boolean bl3 = t = this._stats.isPresent() ? this._stats.get().test(player) : true;
            if (!t) {
                return false;
            }
            return this._scores.isPresent() ? this._scores.get().test(player) : true;
        }

        public final boolean test(Item awarded) {
            return SharedGlue.isDefined(awarded) && this.test(awarded.getRegistryName());
        }

        public JsonElement func_200288_b() {
            JsonObject all = new JsonObject();
            if (this._advancement.isPresent()) {
                this._advancement.get().serialize_into(all);
            }
            if (this._stats.isPresent()) {
                this._stats.get().serialize_into(all);
            }
            if (this._reward.isPresent()) {
                this._reward.get().serialize_into(all);
            }
            if (this._scores.isPresent()) {
                this._scores.get().serialize_into(all);
            }
            return all;
        }

        static final Instance deserialize(ResourceLocation trigger, JsonObject all) {
            Optional<RewardPredicate> reward = RewardPredicate.deserialize_outof(all);
            Optional<AdvancementPredicate> advancement = AdvancementPredicate.deserialize_outof(all);
            Optional<StatPredicate> stats = StatPredicate.deserialize_outof(all);
            Optional<ScorePredicate> scores = ScorePredicate.deserialize_outof(all);
            return new Instance(trigger, advancement, stats, reward, scores);
        }
    }
}

