/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.advancements.ObservedTrigger;
import org.jwaresoftware.mcmods.lib.advancements.StatPredicate;

public final class PlayerStatTrigger
extends ObservedTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_stats");
    @Nonnull
    public static final PlayerStatTrigger INSTANCE = new PlayerStatTrigger(NAME);

    public PlayerStatTrigger(ResourceLocation name) {
        super(name);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return Instance.deserialize(this.func_192163_a(), json);
    }

    public final void trigger(ServerPlayerEntity player) {
        this.trigger(player, null);
    }

    public final void trigger(ServerPlayerEntity player, @Nullable String changed_stat) {
        ObservedTrigger.Listeners listeners = (ObservedTrigger.Listeners)this._playersToListeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger((T instance) -> instance.test((PlayerEntity)player, changed_stat));
        }
    }

    public static final void doApply(ServerPlayerEntity player) {
        INSTANCE.trigger(player);
    }

    public static final void doApply(ServerPlayerEntity player, String changed_stat) {
        INSTANCE.trigger(player, changed_stat);
    }

    public static final class Instance
    extends CriterionInstance {
        private final StatPredicate _stats_criteria;

        public Instance(ResourceLocation trigger, @Nonnull StatPredicate stats_criteria) {
            super(trigger);
            this._stats_criteria = Objects.requireNonNull(stats_criteria);
        }

        public boolean test(PlayerEntity player, @Nullable String changed_stat) {
            return changed_stat == null ? this._stats_criteria.test(player) : this._stats_criteria.test(player, changed_stat);
        }

        public JsonElement func_200288_b() {
            return this._stats_criteria.serialize();
        }

        public static final Instance deserialize(ResourceLocation trigr, JsonObject json) {
            return new Instance(trigr, StatPredicate.deserialize_outof(json).get());
        }
    }
}

