/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;

@ParametersAreNonnullByDefault
public class RewardPredicate
implements Predicate<ResourceLocation> {
    public static final String MEMBER = "reward";
    @Nonnull
    private final ResourceLocation _match;
    @Nullable
    private final String _nbt_toplevel;
    private final boolean _owned;

    public RewardPredicate(ResourceLocation thing, boolean owned, @Nullable String nbt_container) {
        this._match = Objects.requireNonNull(thing, "A reward's name must be defined");
        this._owned = owned;
        this._nbt_toplevel = StringUtils.trimToNull((String)nbt_container);
        if (this._nbt_toplevel != null && !owned) {
            throw new IllegalArgumentException("Cannot have nbt check for name-only reward");
        }
    }

    public RewardPredicate(ResourceLocation thing) {
        this(thing, false, null);
    }

    @Override
    public boolean test(@Nullable ResourceLocation what) {
        return this._match.equals((Object)what);
    }

    public boolean test(PlayerEntity player, @Nullable ItemStack what) {
        boolean r = false;
        if (!ItemStacks.isEmpty(what) && this.test(what.func_77973_b().getRegistryName())) {
            r = this._nbt_toplevel != null ? Instructions.isOwner(what, player, this._nbt_toplevel, false) : Instructions.isOwner(what, player, false);
        }
        return r;
    }

    @Nonnull
    public JsonElement serialize_value() {
        if (!this._owned) {
            return new JsonPrimitive(this._match.toString());
        }
        JsonObject reward_criteria = new JsonObject();
        reward_criteria.addProperty("item", this._match.toString());
        if (this._nbt_toplevel != null) {
            reward_criteria.addProperty("owner_nbt", this._nbt_toplevel);
        }
        return reward_criteria;
    }

    @Nonnull
    public JsonObject serialize_into(@Nonnull JsonObject into) {
        into.add(MEMBER, this.serialize_value());
        return into;
    }

    @Nonnull
    public JsonElement serialize() {
        return this.serialize_into(new JsonObject());
    }

    @Nonnull
    public static final RewardPredicate deserialize_named(JsonElement json) {
        ResourceLocation rid = ResourceLocation.func_208304_a((String)json.getAsString());
        return new RewardPredicate(rid);
    }

    @Nonnull
    public static final RewardPredicate deserialize_value(JsonElement json) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return RewardPredicate.deserialize_named(json);
        }
        JsonObject reward_criteria = JSONUtils.func_151210_l((JsonElement)json, (String)MEMBER);
        String rid = JSONUtils.func_151219_a((JsonObject)reward_criteria, (String)"item", null);
        if (rid == null && reward_criteria.has("name")) {
            rid = JSONUtils.func_151200_h((JsonObject)reward_criteria, (String)"name");
        }
        if (rid == null) {
            throw new JsonParseException("A reward's name must be defined");
        }
        String owner_nbt = JSONUtils.func_151219_a((JsonObject)reward_criteria, (String)"owner_nbt", null);
        return new RewardPredicate(ResourceLocation.func_208304_a((String)rid), true, owner_nbt);
    }

    @Nonnull
    public static final Optional<RewardPredicate> deserialize_outof(JsonObject from) {
        return Optional.ofNullable(from.has(MEMBER) ? RewardPredicate.deserialize_value(from.get(MEMBER)) : null);
    }
}

