/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JSONUtils;

@ParametersAreNonnullByDefault
public class ScorePredicate
implements Predicate<PlayerEntity> {
    public static final String MEMBER = "scores";
    private final Map<String, MinMaxBounds.IntBound> _scores_criteria;

    public ScorePredicate(@Nonnull Map<String, MinMaxBounds.IntBound> scores_criteria) {
        this._scores_criteria = Objects.requireNonNull(scores_criteria);
    }

    public ScorePredicate(String objective_id, int at_least) {
        if (at_least < 1 || objective_id == null) {
            throw new IllegalArgumentException();
        }
        this._scores_criteria = Maps.newLinkedHashMap();
        this._scores_criteria.put(objective_id, MinMaxBounds.IntBound.func_211340_b((int)at_least));
    }

    protected final boolean hitObjective(PlayerEntity player, String objective_id, MinMaxBounds.IntBound required) {
        boolean hit = false;
        Scoreboard scoreboard = player.func_96123_co();
        ScoreObjective objective = scoreboard.func_96518_b(objective_id);
        if (objective != null) {
            String player_sid = player.func_195047_I_();
            hit = scoreboard.func_178819_b(player_sid, objective) && required.func_211339_d(scoreboard.func_96529_a(player_sid, objective).func_96652_c());
        }
        return hit;
    }

    @Override
    public boolean test(PlayerEntity player) {
        boolean r = true;
        if (!(player instanceof ServerPlayerEntity)) {
            r = false;
        } else {
            for (Map.Entry<String, MinMaxBounds.IntBound> criteria : this._scores_criteria.entrySet()) {
                if (this.hitObjective(player, criteria.getKey(), criteria.getValue())) continue;
                r = false;
                break;
            }
        }
        return r;
    }

    public final boolean test(PlayerEntity player, @Nullable String changed_score) {
        boolean r = changed_score == null || !this._scores_criteria.containsKey(changed_score) ? false : this.test(player);
        return r;
    }

    private static final MinMaxBounds.IntBound readRange(JsonElement json) throws JsonParseException {
        MinMaxBounds.IntBound b = MinMaxBounds.IntBound.func_211344_a((JsonElement)json);
        return b;
    }

    public JsonElement serialize_value() {
        JsonObject scores_criteria = new JsonObject();
        for (Map.Entry<String, MinMaxBounds.IntBound> criteria : this._scores_criteria.entrySet()) {
            scores_criteria.add(criteria.getKey(), criteria.getValue().func_200321_c());
        }
        return scores_criteria;
    }

    @Nonnull
    public JsonObject serialize_into(@Nonnull JsonObject into) {
        into.add(MEMBER, this.serialize_value());
        return into;
    }

    public JsonElement serialize() {
        return this.serialize_into(new JsonObject());
    }

    @Nonnull
    public static final ScorePredicate deserialize_value(JsonObject json) {
        LinkedHashMap scores_criteria = Maps.newLinkedHashMap();
        for (Map.Entry criteriaDef : json.entrySet()) {
            scores_criteria.put(criteriaDef.getKey(), ScorePredicate.readRange((JsonElement)criteriaDef.getValue()));
        }
        if (scores_criteria.isEmpty()) {
            throw new JsonParseException("At least one tracked score id is required");
        }
        return new ScorePredicate(scores_criteria);
    }

    @Nonnull
    public static final Optional<ScorePredicate> deserialize_outof(JsonObject from) {
        return Optional.ofNullable(from.has(MEMBER) ? ScorePredicate.deserialize_value(JSONUtils.func_152754_s((JsonObject)from, (String)MEMBER)) : null);
    }
}

