/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class StatPredicate
implements Predicate<PlayerEntity> {
    private static final String _USED_STAT = "minecraft.used:";
    private static final String _VANILLA_CUSTOM_STAT = "minecraft.custom:";
    static Map<String, StatType<?>> _MAIN = Collections.EMPTY_MAP;
    public static final String MEMBER = "stats";
    private final Map<ResourceLocation, MinMaxBounds.IntBound> _stats_criteria;

    static final String mk(String s) {
        return "minecraft." + s;
    }

    static final void initFinalize() {
        LinkedHashMap m = Maps.newLinkedHashMap();
        m.put(StatPredicate.mk("mined"), Stats.field_188065_ae);
        m.put(StatPredicate.mk("crafted"), Stats.field_188066_af);
        m.put(StatPredicate.mk("used"), Stats.field_75929_E);
        m.put(StatPredicate.mk("broken"), Stats.field_199088_e);
        m.put(StatPredicate.mk("picked_up"), Stats.field_199089_f);
        m.put(StatPredicate.mk("killed"), Stats.field_199090_h);
        m.put(StatPredicate.mk("killed_by"), Stats.field_199091_i);
        m.put(StatPredicate.mk("custom"), Stats.field_199092_j);
        _MAIN = m;
    }

    public StatPredicate(Map<ResourceLocation, MinMaxBounds.IntBound> stats_criteria) {
        this._stats_criteria = Objects.requireNonNull(stats_criteria);
    }

    public StatPredicate(ResourceLocation stat_id, int at_least) {
        if (at_least < 1 || stat_id == null) {
            throw new IllegalArgumentException();
        }
        this._stats_criteria = Maps.newLinkedHashMap();
        this._stats_criteria.put(stat_id, MinMaxBounds.IntBound.func_211340_b((int)at_least));
    }

    public StatPredicate(ResourceLocation stat_id, MinMaxBounds.IntBound stat_criterion) {
        this._stats_criteria = Maps.newLinkedHashMap();
        this._stats_criteria.put(stat_id, Objects.requireNonNull(stat_criterion));
    }

    protected final boolean hitObjective(ServerPlayerEntity player, ResourceLocation stat, MinMaxBounds.IntBound required) {
        int i;
        boolean hit = false;
        StatType typrepo = _MAIN.get(stat.func_110624_b());
        if (typrepo == null) {
            ResourceLocation typid;
            i = stat.func_110624_b().indexOf(46);
            ResourceLocation resourceLocation = typid = i > 0 ? new ResourceLocation(stat.func_110624_b().substring(0, i), stat.func_110624_b().substring(i + 1)) : new ResourceLocation(stat.func_110624_b());
            if (ForgeRegistries.STAT_TYPES.containsKey(typid)) {
                typrepo = (StatType)ForgeRegistries.STAT_TYPES.getValue(typid);
            }
        }
        if (typrepo != null) {
            Stat objstat;
            i = stat.func_110623_a().indexOf(46);
            ResourceLocation objid = i > 0 ? new ResourceLocation(stat.func_110623_a().substring(0, i), stat.func_110623_a().substring(i + 1)) : new ResourceLocation(stat.func_110623_a());
            Optional obj = typrepo.func_199080_a().func_218349_b(objid);
            if (obj.isPresent() && (objstat = typrepo.func_199076_b(obj.get())) != null) {
                hit = required.func_211339_d(player.func_147099_x().func_77444_a(objstat));
            }
        }
        return hit;
    }

    @Override
    public boolean test(PlayerEntity player) {
        boolean r = true;
        if (!(player instanceof ServerPlayerEntity)) {
            r = false;
        } else {
            for (Map.Entry<ResourceLocation, MinMaxBounds.IntBound> criteria : this._stats_criteria.entrySet()) {
                if (this.hitObjective((ServerPlayerEntity)player, criteria.getKey(), criteria.getValue())) continue;
                r = false;
                break;
            }
        }
        return r;
    }

    public final boolean test(PlayerEntity player, @Nullable String changed_stat) {
        boolean r = changed_stat == null || !this._stats_criteria.containsKey(ResourceLocation.func_208304_a((String)changed_stat)) ? false : this.test(player);
        return r;
    }

    static final MinMaxBounds.IntBound readRange(JsonElement json) throws JsonParseException {
        MinMaxBounds.IntBound b = MinMaxBounds.IntBound.func_211344_a((JsonElement)json);
        if (b.func_211335_c()) {
            b = MinMaxBounds.IntBound.func_211340_b((int)1);
        }
        return b;
    }

    public JsonElement serialize_value() {
        JsonObject stats_criteria = new JsonObject();
        for (Map.Entry<ResourceLocation, MinMaxBounds.IntBound> criteria : this._stats_criteria.entrySet()) {
            stats_criteria.add(criteria.getKey().toString(), criteria.getValue().func_200321_c());
        }
        return stats_criteria;
    }

    @Nonnull
    public JsonObject serialize_into(@Nonnull JsonObject into) {
        into.add(MEMBER, this.serialize_value());
        return into;
    }

    public JsonElement serialize() {
        return this.serialize_into(new JsonObject());
    }

    private static final String normalized(String stat_key) {
        if (stat_key.startsWith("minecraft.consumed:")) {
            stat_key = _USED_STAT + stat_key.substring("minecraft.consumed:".length());
        } else if (stat_key.startsWith("minecraft.player:")) {
            stat_key = _VANILLA_CUSTOM_STAT + stat_key.substring("minecraft.player:".length());
        }
        return stat_key;
    }

    @Nonnull
    public static final StatPredicate deserialize_value(JsonObject json) {
        LinkedHashMap stats_criteria = Maps.newLinkedHashMap();
        for (Map.Entry criteriaDef : json.entrySet()) {
            String stat_key = (String)criteriaDef.getKey();
            int i = stat_key.indexOf(58);
            if (i < 2) {
                throw new JsonParseException("Malformed statistic key '" + stat_key + "'");
            }
            int j = stat_key.indexOf(46);
            if (j < 0 || j > i) {
                stat_key = "minecraft." + stat_key;
            }
            stat_key = StatPredicate.normalized(stat_key);
            stats_criteria.put(new ResourceLocation(stat_key), StatPredicate.readRange((JsonElement)criteriaDef.getValue()));
        }
        if (stats_criteria.isEmpty()) {
            throw new JsonParseException("At least one tracked statistic id is required");
        }
        return new StatPredicate(stats_criteria);
    }

    @Nonnull
    public static final Optional<StatPredicate> deserialize_outof(JsonObject from) {
        return Optional.ofNullable(from.has(MEMBER) ? StatPredicate.deserialize_value(JSONUtils.func_152754_s((JsonObject)from, (String)MEMBER)) : null);
    }
}

