/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.IWorldReader;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.XpCalculations;

public interface IDrinkableFluid {
    public static final IDrinkableFluid NONE = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.NONE;
        }

        @Override
        public boolean isDrinkable() {
            return false;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid WATER = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.WATER;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid MILK = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }
    };
    public static final IDrinkableFluid MILKMILK = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        public int getHealAmount() {
            return 4;
        }

        @Override
        public float getSaturationModifier() {
            return 1.0f;
        }
    };
    public static final IDrinkableFluid MILKMILK_BUCKET = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MILK;
        }

        @Override
        public int getHealAmount() {
            return 4 * MILKMILK.getHealAmount();
        }

        @Override
        public float getSaturationModifier() {
            return 1.0f;
        }
    };
    public static final IDrinkableFluid XP_BUCKET = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.XP;
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (SharedGlue.isaRealNonSpectatingPlayer((Entity)drinker) && SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                XpCalculations.spawnXPBurst(drinker.func_130014_f_(), drinker.field_70165_t, drinker.field_70163_u, drinker.field_70161_v, 34, null);
            }
        }
    };
    public static final IDrinkableFluid POTION = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POTION;
        }
    };
    public static final IDrinkableFluid SHROOSTEW = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.STEW;
        }

        @Override
        public int getHealAmount() {
            return 6;
        }

        @Override
        public float getSaturationModifier() {
            return 0.6f;
        }
    };
    public static final IDrinkableFluid SHROOSTEW_BUCKET = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.STEW;
        }

        @Override
        public int getHealAmount() {
            return 4 * SHROOSTEW.getHealAmount();
        }

        @Override
        public float getSaturationModifier() {
            return 2.75f * SHROOSTEW.getSaturationModifier();
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }
    };
    public static final IDrinkableFluid MEATMILK = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MEATMILK;
        }

        @Override
        public int getHealAmount() {
            return 10;
        }

        @Override
        public float getSaturationModifier() {
            return 0.8f;
        }
    };
    public static final IDrinkableFluid MEATMILK_BUCKET = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.MEATMILK;
        }

        @Override
        public int getHealAmount() {
            return 4 * MEATMILK.getHealAmount();
        }

        @Override
        public float getSaturationModifier() {
            return 2.75f * MEATMILK.getSaturationModifier();
        }

        @Override
        public boolean includeCooldown() {
            return true;
        }
    };
    public static final IDrinkableFluid AMBROSIA = new IDrinkableFluid(){

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.CURATIVE;
        }

        @Override
        public int getHealAmount() {
            return 4;
        }

        @Override
        public float getSaturationModifier() {
            return 1.2f;
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_hunger);
                drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_regeneration, 100, 1));
                drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_absorption, 2400, 0));
            }
        }
    };
    public static final IDrinkableFluid BIRCH_SAP = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POWER;
        }

        @Override
        public int getHealAmount() {
            return 3;
        }

        @Override
        public float getSaturationModifier() {
            return 3.34f;
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_hunger);
                Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_nausea);
                if (drinker.func_70681_au().nextFloat() < 0.5f) {
                    Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_poison);
                }
            }
        }
    };
    public static final IDrinkableFluid BIRCH_SAP_BUCKET = new IDrinkableFluid(){

        @Override
        public boolean isDrinkableAlways() {
            return true;
        }

        @Override
        public boolean includeCooldown() {
            return false;
        }

        @Override
        public LiquidType getDrinkValues() {
            return LiquidType.POWER;
        }

        @Override
        public int getHealAmount() {
            return 2 * BIRCH_SAP.getHealAmount();
        }

        @Override
        public float getSaturationModifier() {
            return BIRCH_SAP.getSaturationModifier();
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            if (SharedGlue.isaServerWorld((IWorldReader)drinker.func_130014_f_())) {
                BIRCH_SAP.onDrunk(what, drinker);
                Potions.removePotionEffectUnconditionally(drinker, SharedGlue.Potion_poison);
                drinker.func_195064_c(new EffectInstance(SharedGlue.Potion_saturation, 2400, 0));
            }
        }
    };

    @Nonnull
    default public LiquidType getDrinkValues() {
        return LiquidType.SLIGHT;
    }

    default public boolean isDrinkable() {
        return true;
    }

    default public boolean isDrinkableAlways() {
        return false;
    }

    default public int getHealAmount() {
        return 0;
    }

    default public float getSaturationModifier() {
        return 0.0f;
    }

    default public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
    }

    default public boolean includeCooldown() {
        return !this.isDrinkableAlways() && this.getHealAmount() > 16;
    }
}

